/*
 * ##################################################### Start MainSite Addon #####################################################
 */

MainSite.prototype.getKimFriendlyName = function() {
  return 'ise KNX Sonos'
}

MainSite.prototype.addProductTopNavMenuItems = function() {
  //  this.pages['LoginPage'] = new LoginPage();

  this.menu.insertAfter(new MenuItem('playlist_config', 'PlaylistConfigurationPage'), this.menu.device_status);
  this.pages['PlaylistConfigurationPage'] = new PlaylistConfigurationPage();

  mainSite.homepage = this.pages['PlaylistConfigurationPage'];
//  this.menu.system.target.insertAsFirst(new MenuItem('change_settings', 'NetworkSettingsPage'));
//  this.pages['NetworkSettingsPage'] = new NetworkSettingsPage();
//  this.pages['NetworkSettingsPage'].ipSettingsFormEnabled = true;
//  this.pages['NetworkSettingsPage'].ntpSettingsFormEnabled = true;
//
//  this.menu.add(new MenuItem('user', new Menu(new MenuItem('change_password', 'ChangePasswordPage'))));
//  this.pages['ChangePasswordPage'] = new ChangePasswordPage();
//
//  this.menu.user.target.add(new MenuItem('logout', 'LogoutPage'));
//  this.pages['LogoutPage'] = new LogoutPage();
}

/*
 * ##################################################### End MainSite Addon #####################################################
 */

/*
* ##################################################### Start StatusPage Addon #####################################################
*/

var maxMaster = 10;
var maxSlaves = 5;

var CO = {
  MasterConnected: 27,
  MasterSlaveState: 30,
  SlaveConnected: 41,
  SlaveActive: 48
}

StatusPage.prototype.updateIPParameterAndStateInfo = function(ipParameterId, ipTextNode, stateCO, stateTextNode) {
  if (mainSite.appState) {
    if (mainSite.appState.state == 'Running' && ipTextNode.nodeValue == i18n.translate('not_configured')) {
      var thisClass = this;
      IscWebService('getIpParameter', {
        number: ipParameterId
      }, function(response) {
        if (response.data != undefined && response.data.value) {
          if (response.data.value != '0.0.0.0') {
            ipTextNode.nodeValue = response.data.value;
            ipTextNode.parentElement.setAttribute('class', 'bold');
            ipTextNode.parentElement.parentElement.removeAttribute('hidden');
            stateTextNode[0].parentElement.parentElement.removeAttribute('hidden');
            if (mainSite.currentCOValues && mainSite.currentCOValues.COs) {
              for (var i in mainSite.currentCOValues.COs) {
                var currentCO = mainSite.currentCOValues.COs[i];
                if (stateCO[0] == currentCO.id) {
                  thisClass.updateCO(stateTextNode[0].parentElement, stateTextNode[0], currentCO)
                } else if (stateCO[1] == currentCO.id) {
                  thisClass.updateCO(stateTextNode[1].parentElement, stateTextNode[1], currentCO)
                }
              }
            }
          } else {
            ipTextNode.nodeValue = i18n.translate('not_configured');
            ipTextNode.parentElement.setAttribute('class', 'bold text--muted');
            ipTextNode.parentElement.removeAttribute('hidden');
            stateTextNode[0].parentElement.parentElement.setAttribute('hidden', '');
          }
        }
      }, false);
    }
  }
};


StatusPage.prototype.appendDOMFragmentCOInfosTo = function(parentElement) {
  var span = document.createElement('span');
  span.setAttribute('hidden', '');
  var thisClass = this;
  thisClass.dataBindings.push(
    function() {
      if (mainSite.deviceInfo && mainSite.deviceInfo.EtsDownload && mainSite.appState) {
        span.removeAttribute('hidden');
      } else {
        span.setAttribute('hidden', '');
      }
    }
  );

  parentElement.appendChild(span);
  parentElement = span;
  for (var groupid = 0; groupid < maxMaster; groupid++) {
    var groupSpan = document.createElement('span');
    groupSpan.setAttribute('hidden', '');
    groupSpan.appendChild(document.createElement('br'));
    var groupLabel = document.createElement('a');
    groupLabel.appendChild(document.createTextNode(i18n.translate('group') + ' ' + (groupid + 1)));
    groupLabel.setAttribute('class', 'groupLabel');
    groupLabel.setAttribute('href', '#PlaylistConfigurationPage?group=' + groupid);
    groupLabel.onclick = function() {
      return mainSite.show(this.href);
    };
    groupSpan.appendChild(groupLabel);
    groupSpan.appendChild(document.createElement('br'));
    groupSpan.appendChild(document.createTextNode(i18n.translate('master_ip') + ': '));
    var textNodeMasterIp = document.createTextNode(i18n.translate('not_configured'));
    var spanMasterIp = document.createElement('span');
    spanMasterIp.setAttribute('class', 'bold text--muted');
    groupSpan.appendChild(spanMasterIp);
    spanMasterIp.appendChild(textNodeMasterIp);
    var spanMasterState = document.createElement('span');
    spanMasterState.setAttribute('class', 'text--muted');
    var textNodeMasterStateConnected = document.createTextNode('');
    var textNodeMasterStateSlaveState = document.createTextNode('');
    spanMasterState.appendChild(textNodeMasterStateConnected);
    spanMasterState.appendChild(textNodeMasterStateSlaveState);
    groupSpan.appendChild(document.createTextNode(' ('));
    groupSpan.appendChild(spanMasterState);
    groupSpan.appendChild(document.createTextNode(')'));
    groupSpan.appendChild(document.createElement('br'));
    thisClass.dataBindings.push(function(ipParameter, textNodeMasterIp_, beginCORange, textNodeMasterState_) {
      thisClass.updateIPParameterAndStateInfo(ipParameter, textNodeMasterIp_, beginCORange, textNodeMasterState_);
    }.bind(this, groupid * maxSlaves + groupid + 1, textNodeMasterIp, [groupid * 100 + CO.MasterConnected, groupid * 100 + CO.MasterSlaveState], [textNodeMasterStateConnected, textNodeMasterStateSlaveState]));

    for (var slaveid = 0; slaveid < maxSlaves; slaveid++) {
      groupSpan.appendChild(document.createTextNode(i18n.translate('slave_ID_ip').replace(/ID/gi, function(x) {
          switch (x) {
            case 'ID':
              return (1 + slaveid);
          }
        }) + ': '));
      var textNodeSlaveIp = document.createTextNode(i18n.translate('not_configured'));
      var spanSlaveIp = document.createElement('span');
      spanSlaveIp.setAttribute('class', 'bold text--muted');
      groupSpan.appendChild(spanSlaveIp);
      spanSlaveIp.appendChild(textNodeSlaveIp);
      var slaveStateSpan = document.createElement('span');
      slaveStateSpan.setAttribute('class', 'text--muted');
      var outerSlaveStateSpan = document.createElement('span');
      var textNodeSlaveStateConnected = document.createTextNode('');
      var textNodeSlaveStateActive = document.createTextNode('');
      slaveStateSpan.appendChild(textNodeSlaveStateActive);
      slaveStateSpan.appendChild(textNodeSlaveStateConnected);
      outerSlaveStateSpan.appendChild(document.createTextNode(' ('));
      outerSlaveStateSpan.appendChild(slaveStateSpan);
      outerSlaveStateSpan.appendChild(document.createTextNode(')'));
      groupSpan.appendChild(outerSlaveStateSpan);
      groupSpan.appendChild(document.createElement('br'));
      thisClass.dataBindings.push(function(ipParameter, textNodeSlaveIp_, beginCORange, textNodeSlaveState_) {
        thisClass.updateIPParameterAndStateInfo(ipParameter, textNodeSlaveIp_, beginCORange, textNodeSlaveState_);
      }.bind(this, groupid * maxSlaves + groupid + 1 + slaveid + 1, textNodeSlaveIp, [groupid * 100 + slaveid * 10 + CO.SlaveConnected, groupid * 100 + slaveid * 10 + CO.SlaveActive], [textNodeSlaveStateConnected, textNodeSlaveStateActive]));
    }
    parentElement.appendChild(groupSpan);
  }

  var thisClass = this;

}

StatusPage.prototype.prepareAppInfo = function(divAppInfomation) {
  headerAppInformation = document.createElement('h3');
  headerAppInformation.setAttribute('class', 'h3');
  headerAppInformation.appendChild(document.createTextNode(i18n.translate('application_information')));
  divAppInfomation.appendChild(headerAppInformation);

  var fragmentAppState = document.createElement('span');
  fragmentAppState.setAttribute('hidden', '');
  divAppInfomation.appendChild(fragmentAppState);
  this.appendDOMFragmentAppStateTo(fragmentAppState);

  var thisClass = this;
  thisClass.dataBindings.push(
    function() {
      if (mainSite.deviceInfo && mainSite.deviceInfo.EtsDownload && mainSite.appState) {
        fragmentAppState.removeAttribute('hidden');
      } else {
        fragmentAppState.setAttribute('hidden', '');
      }
    }
  );

  // Enable this for CO Infos.
  this.appendDOMFragmentCOInfosTo(divAppInfomation);

  divAppInfomation.appendChild(document.createElement('br'));
}
//Example for default handling of Boolean COs and specific String COs handling
var stateBinder = ' / ';
StatusPage.prototype.updateCO = function(span, textNode, currentCO) {

  switch (currentCO.id % 100) {
    case CO.MasterConnected:
      if (currentCO.value == '1') {
        if (textNode.nextSibling.nodeValue == stateBinder + i18n.translate('currently_slave')) {
          span.setAttribute('class', 'text--warning');
        } else {
          span.setAttribute('class', 'text--success');
        }
        textNode.nodeValue = i18n.translate('connected');
      } else if (currentCO.value == '0') {
        span.setAttribute('class', 'text--error');
        textNode.nodeValue = i18n.translate('disconnected');
      } else {
        span.setAttribute('class', 'text--muted');
        textNode.nodeValue = i18n.translate('not_configured');
      }
      break;
    case CO.MasterSlaveState:
      if (currentCO.value == '1') {
        if (textNode.previousSibling.nodeValue == i18n.translate('connected')) {
          span.setAttribute('class', 'text--warning');
        } else {
          span.setAttribute('class', 'text--error');
        }
        textNode.nodeValue = stateBinder + i18n.translate('currently_slave');
      } else if (currentCO.value == '0') {
        textNode.nodeValue = '';
      }
      break;
    default:
      if (((currentCO.id % 100) - CO.SlaveConnected) % 10) {
        if (currentCO.value == '1') {
          if (textNode.nextSibling.nodeValue == stateBinder + i18n.translate('not_active')) {
            span.setAttribute('class', 'text--warning');
          } else {
            span.setAttribute('class', 'text--success');
          }
          textNode.nodeValue = i18n.translate('connected');
        } else if (currentCO.value == '0') {
          span.setAttribute('class', 'text--error');
          textNode.nodeValue = i18n.translate('disconnected');
        } else {
          span.setAttribute('class', 'text--muted');
          textNode.nodeValue = i18n.translate('not_configured');
        }
      } else if (((currentCO.id % 100) - CO.SlaveActive) % 10) {
        textNode.nodeValue = textNode.nodeValue + ' ';
        if (currentCO.value == '1') {
          span.setAttribute('class', 'text--success');
          textNode.nodeValue = stateBinder + i18n.translate('active');
        } else if (currentCO.value == '0') {

          if (textNode.previousSibling.nodeValue == i18n.translate('connected')) {
            span.setAttribute('class', 'text--warning');
          } else {
            span.setAttribute('class', 'text--error');
          }
          textNode.nodeValue = stateBinder + i18n.translate('not_active');
        }
      }
      break;
  }
}
/*
 * ##################################################### End StatusPage Addon #####################################################
 *//*###################################################### www/web/playlist.js #############################################*/
/*
 * ##################################################### Start PlaylistConfigurationPage #####################################################
 */
var SOURCETYPES = {
  NONE: 'none',
  RADIO: 'Radio',
  SONOS: 'Sonos',
  AUDIOIN: 'AudioIn',
  TV: 'TV',
  TEXTTOSPEECH: 'TextToSpeech'
};

function PlaylistConfigurationPage() {
  if (!(this instanceof PlaylistConfigurationPage)) {
    return new PlaylistConfigurationPage();
  }
  PageTemplate.call(this);
  var thisClass = this;

  this.currentGroup = 0;
  this.currentPlaylistConfig = undefined;
  this.currentRowData = undefined;

  this.maxGroups = 10;
  this.playlistConfigurationChanged = false;

  this.divDeviceStatus = undefined;
  this.divAppStatus = undefined;
  this.divSonosPlaylistMapping = undefined;
  this.configTable = undefined;
  this.groupSelectOptions = [];
  this.loadGroupOptions = [];

  this.currentTTSStatus = undefined;
  this.installedTTSVoices = undefined;

  this.prepare = function() {
    if (!thisClass.contentSection) {
      thisClass.currentGroup = parseInt(thisClass.parameter['group']) || 0;
      thisClass.contentSection = document.createElement('div');
      thisClass.sonosPlaylistMapping();
      thisClass.noEtsProjectPage();
      thisClass.wrongAppStatePage();
      thisClass.showPageContent(thisClass.divSonosPlaylistMapping);
    } else if (thisClass.parameter['group'] && (thisClass.currentGroup != parseInt(thisClass.parameter['group']))) {
      thisClass.currentGroup = parseInt(thisClass.parameter['group']);
      thisClass.playlistConfigurationChanged = false;
      thisClass.requestPlaylistsAndSources(thisClass.currentGroup);
      thisClass.requestTTSStatus();
      thisClass.groupSelectionUpdate();
    }
    mainSite.main.appendChild(thisClass.contentSection);
    thisClass.requestData();
    thisClass.update();
  };

  this.showPageContent = function(pageContent) {
    if (pageContent != thisClass.divSonosPlaylistMapping) {
      if (thisClass.contentSection.contains(thisClass.divSonosPlaylistMapping)) {
        thisClass.contentSection.removeChild(thisClass.divSonosPlaylistMapping);
      }
      if (pageContent == thisClass.divDeviceStatus) {
        if (!thisClass.contentSection.contains(thisClass.divDeviceStatus)) {
          if (thisClass.contentSection.contains(thisClass.divAppStatus)) {
            thisClass.contentSection.removeChild(thisClass.divAppStatus);
          }
          thisClass.contentSection.appendChild(thisClass.divDeviceStatus);
        }
      } else {
        if (!thisClass.contentSection.contains(thisClass.divAppStatus)) {
          if (thisClass.contentSection.contains(thisClass.divDeviceStatus)) {
            thisClass.contentSection.removeChild(thisClass.divDeviceStatus);
          }
          thisClass.contentSection.appendChild(thisClass.divAppStatus);
        }
      }
    } else {
      if (!thisClass.contentSection.contains(thisClass.divSonosPlaylistMapping)) {
        if (thisClass.contentSection.contains(thisClass.divAppStatus)) {
          thisClass.contentSection.removeChild(thisClass.divAppStatus);
        }
        if (thisClass.contentSection.contains(thisClass.divDeviceStatus)) {
          thisClass.contentSection.removeChild(thisClass.divDeviceStatus);
        }
        thisClass.contentSection.appendChild(thisClass.divSonosPlaylistMapping);
      }
    }
    if (!thisClass.currentPlaylistConfig) {
      thisClass.requestPlaylistsAndSources(thisClass.currentGroup);
    }
    if (!thisClass.currentTTSStatus) {
      thisClass.requestTTSStatus();
    }
  }

  this.eventFunctionLoad = function() {}
  this.sonosPlaylistMapping = function() {
    thisClass.groupSelectOptions = [];
    thisClass.groupSelectOptions.map = {};
    for (var i = 0; i < thisClass.maxGroups; i++) {
      thisClass.groupSelectOptions.push({
        'value': i,
        'text': i + 1
      });
    }

    thisClass.loadGroupOptions = [];
    thisClass.loadGroupOptions.map = {};
    for (var i = 0; i < thisClass.maxGroups; i++) {
      thisClass.loadGroupOptions.push({
        'value': i,
        'text': i18n.translate("group") + ' ' + (i + 1)
      });
    }

    if (!thisClass.divSonosPlaylistMapping) {
      thisClass.divSonosPlaylistMapping = document.createElement('div');

      var headerSonosPlaqylistConfig = document.createElement('h3');
      headerSonosPlaqylistConfig.setAttribute('class', 'h3');
      headerSonosPlaqylistConfig.appendChild(document.createTextNode(i18n.translate('playlist_title_text')));

      var selectGroup;
      selectGroup = document.createElement('select');
      selectGroup.setAttribute('name', 'group');
      selectGroup.setAttribute('style', 'width:2.2em');
      selectGroup.addEventListener('change', function(evt) {
        thisClass.currentGroup = parseInt(this.options[this.options.selectedIndex].value);
        thisClass.eventFunctionLoad();
        thisClass.parameter['group'] = thisClass.currentGroup;
        location.hash = 'PlaylistConfigurationPage?group=' + thisClass.currentGroup;
        thisClass.playlistConfigurationChanged = false;
        thisClass.requestPlaylistsAndSources(thisClass.currentGroup);
      });

      thisClass.groupSelectionUpdate = function(evt) {
        while (selectGroup.hasChildNodes()) {
          selectGroup.removeChild(selectGroup.firstChild);
        }
        // unselected option
        for (var i = 0; i < thisClass.groupSelectOptions.length; i++) {
          var optionGroup = document.createElement('option');
          optionGroup.value = thisClass.groupSelectOptions[i].value;
          optionGroup.appendChild(document.createTextNode(thisClass.groupSelectOptions[i].text));
          if (thisClass.currentGroup == thisClass.groupSelectOptions[i].value) {
            optionGroup.setAttribute('selected', '');
          }
          selectGroup.appendChild(optionGroup);
        }
      }
      thisClass.groupSelectionUpdate();
      selectGroup.addEventListener('change', thisClass.groupSelectionUpdate());
      headerSonosPlaqylistConfig.appendChild(selectGroup);

      thisClass.divSonosPlaylistMapping.appendChild(headerSonosPlaqylistConfig);
      var spanSonosPlaqylistConfigHint = document.createElement('div');
      spanSonosPlaqylistConfigHint.setAttribute('class', 'text_hint');
      spanSonosPlaqylistConfigHint.appendChild(document.createTextNode(i18n.translate('ets_setting_additional_hint')));
      thisClass.divSonosPlaylistMapping.appendChild(spanSonosPlaqylistConfigHint);

      var divSonosPlaqylistConfigTable = document.createElement('div');
      divSonosPlaqylistConfigTable.setAttribute('id', 'playlists_wrapper');
      divSonosPlaqylistConfigTable.setAttribute('class', 'dataTables_wrapper no-footer');
      divSonosPlaqylistConfigTable.setAttribute('style', 'width: 100%');
      thisClass.configTable = document.createElement('table');
      thisClass.configTable.setAttribute('id', 'playlists');
      thisClass.configTable.setAttribute('class', 'table--hoverRow table--borderHorizontal');
      var thead = document.createElement('thead');

      var tr = document.createElement('tr');
      var th1 = document.createElement('th');
      th1.appendChild(document.createTextNode(i18n.translate('number')));
      var th2 = document.createElement('th');
      th2.appendChild(document.createTextNode(i18n.translate('source_type')));
      var th3 = document.createElement('th');
      th3.appendChild(document.createTextNode(i18n.translate('source')));
      var th4 = document.createElement('th');
      th4.appendChild(document.createTextNode(i18n.translate('column_title')));
      var th5 = document.createElement('th');
      th5.appendChild(document.createTextNode(i18n.translate('column_announcement')));
      var th6 = document.createElement('th');
      th6.appendChild(document.createTextNode(i18n.translate('column_unmute')));
      var th7 = document.createElement('th');
      th7.appendChild(document.createTextNode(i18n.translate('column_playMode')));
      var th8 = document.createElement('th');
      th8.appendChild(document.createTextNode(i18n.translate('column_repeatMode')));
      var th9 = document.createElement('th');
      th9.appendChild(document.createTextNode(i18n.translate('column_volume')));
      var th10 = document.createElement('th');
      th10.appendChild(document.createTextNode('Changed'));
      tr.appendChild(th1);
      tr.appendChild(th2);
      tr.appendChild(th3);
      tr.appendChild(th4);
      tr.appendChild(th5);
      tr.appendChild(th6);
      tr.appendChild(th7);
      tr.appendChild(th8);
      tr.appendChild(th9);
      tr.appendChild(th10);
      thead.appendChild(tr);

      thisClass.configTable.appendChild(thead)
      var tbody = document.createElement('tbody');
      thisClass.configTable.appendChild(tbody)

      thisClass.divSonosPlaylistMapping.appendChild(thisClass.configTable);

      thisClass.dataBindings.push(function() {
        if (thisClass.currentPlaylistConfig && mainSite.currentModalDialog == undefined) {
          thisClass.updatePlaylistTable();
        }
      });

      var ulButtons = document.createElement('ul');
      ulButtons.setAttribute('class', 'buttonlist')
      var clearButton = document.createElement('button');
      clearButton.setAttribute('class', 'button--xsm');
      clearButton.appendChild(document.createTextNode(i18n.translate('clear')));
      var liClearButton = document.createElement('li');
      liClearButton.appendChild(clearButton);
      ulButtons.appendChild(liClearButton);
      var saveButton = document.createElement('button');
      saveButton.setAttribute('class', 'button--xsm');
      saveButton.setAttribute('disabled', 'true');
      thisClass.playlistConfigurationChanged = false;
      saveButton.appendChild(document.createTextNode(i18n.translate('save')));
      saveButton.onclick = thisClass.savePlaylists;
      var liSaveButton = document.createElement('li');
      liSaveButton.appendChild(saveButton);
      ulButtons.appendChild(liSaveButton);

      var loadGroupSelect = document.createElement('select');


      loadGroupSelect.setAttribute('name', 'loadGroup');
      loadGroupSelect.setAttribute('width', '2.2em');

      thisClass.eventFunctionLoad = function(evt) {
        while (loadGroupSelect.hasChildNodes()) {
          loadGroupSelect.removeChild(loadGroupSelect.firstChild);
        }
        // unselected option
        for (var i = 0; i < thisClass.loadGroupOptions.length; i++) {
          if (i != thisClass.currentGroup) {
            var optionGroup = document.createElement('option');
            optionGroup.value = thisClass.loadGroupOptions[i].value;
            optionGroup.appendChild(document.createTextNode(thisClass.loadGroupOptions[i].text));
            loadGroupSelect.appendChild(optionGroup);
          }
        }
      }
      thisClass.eventFunctionLoad();

      var liLoadGroupSelect = document.createElement('li');
      liLoadGroupSelect.appendChild(loadGroupSelect);
      ulButtons.appendChild(liLoadGroupSelect);


      var loadButton = document.createElement('button');
      loadButton.setAttribute('class', 'button--xsm');
      loadButton.appendChild(document.createTextNode(i18n.translate('load')));
      loadButton.onclick = function(ev) {
        var loadGroup = parseInt(loadGroupSelect.options[loadGroupSelect.options.selectedIndex].value);
        // set changed to false to force a redraw of the table, even if the user has changed something
        thisClass.playlistConfigurationChanged = false;
        thisClass.requestPlaylistsAndSources(loadGroup, function() {
          thisClass.playlistConfigurationChanged = true;
          // mark all rows to be changed to ensure data is properly changed
          var tabledata = $(thisClass.configTable).DataTable();
          for (var i = 0; i < tabledata.data().length; i++) {
            tabledata.row(i).data().changed = true;
          }
          thisClass.enableSaveButton();
        });
      };
      var liLoadButton = document.createElement('li');
      liLoadButton.appendChild(loadButton);
      ulButtons.appendChild(liLoadButton);


      thisClass.divSonosPlaylistMapping.appendChild(ulButtons);

      thisClass.enableSaveButton = function() {
        saveButton.removeAttribute('disabled');
      }

      thisClass.clearConfiguration = function() {
        thisClass.currentPlaylistConfig.playlists = [];
        // If the user wants to clear the list and send the (empty) result => Clear list in the SonosApp, we need to set 'changed' to true:
        var tabledata = $(thisClass.configTable).DataTable();
        for (var i = 0; i < tabledata.data().length; i++) {
          tabledata.row(i).data(new KimPlaylist({
            'number': (i + 1),
            'changed': true
          }));
          tabledata.row(i).draw();
        }
        thisClass.setChanged(true);
      };

      clearButton.onclick = thisClass.clearConfiguration;

      thisClass.setChanged = function(value, redraw) {
        redraw = redraw || true;
        var tabledata = $(thisClass.configTable).DataTable();
        thisClass.playlistConfigurationChanged = value;
        tabledata.draw(redraw);
        // enable/disable save button:
        if (value) {
          saveButton.removeAttribute('disabled');
        } else {
          saveButton.setAttribute('disabled', 'true');
        }
      }

      thisClass.dataBindings.push(function() {
        if (mainSite.deviceInfo && mainSite.deviceInfo.EtsDownload == true && mainSite.appState && mainSite.appState.state == 'Running') {
          thisClass.showPageContent(thisClass.divSonosPlaylistMapping);
        }
      });
    }
  };

  this.noEtsProjectPage = function() {
    if (!thisClass.divDeviceStatus) {
      thisClass.divDeviceStatus = document.createElement('div');
      var headerDeviceStatus = document.createElement('h3');
      headerDeviceStatus.setAttribute('class', 'h3');
      headerDeviceStatus.appendChild(document.createTextNode(i18n.translate('error_title_NoEtsProject')));
      var pDeviceStatus = document.createElement('p');
      var device_status = document.createTextNode(i18n.translate('error_text_NoEtsProject'));
      pDeviceStatus.appendChild(device_status);
      thisClass.divDeviceStatus.appendChild(headerDeviceStatus);
      thisClass.divDeviceStatus.appendChild(pDeviceStatus);
      thisClass.divDeviceStatus.appendChild(document.createElement('br'));
      thisClass.dataBindings.push(function() {
        if (mainSite.deviceInfo && mainSite.deviceInfo.EtsDownload == false) {
          thisClass.showPageContent(thisClass.divDeviceStatus);
        }
      });
    }
  }

  this.requestPlaylistsAndSources = function(group, callback) {
    group = (typeof group !== 'undefined') ? group : 0;
    var websocket = CreateWebSocket();
    websocket.onopen = function(evt) {
      var playlistSocket = new PlaylistSocket(websocket);
      playlistSocket.getPlaylistsAndSources(group, function(response) {
        if (response.response == 'playlists_and_sources') {
          thisClass.currentPlaylistConfig = response;
          thisClass.updatePlaylistTable();
          websocket.close();
          if (callback) {
            callback();
          }
        }
      });
    };
    websocket.onerror = function(evt) {
      thisClass.currentPlaylistConfig = undefined;
    };
  }

  this.requestTTSStatus = function() {
    var websocket = CreateWebSocket();
    websocket.onopen = function(evt) {
      var playlistSocket = new PlaylistSocket(websocket);
      playlistSocket.getTTSLicenseStatus(function(response) {
        if (response.get_tts_license_status == "LicenseOK") {
          thisClass.currentTTSStatus = TTSLicenseStatus.LicenseOK;
          thisClass.requestInstalledTTSVoices();
        } else if (response.get_tts_license_status == "LicenseCorrupt") {
          thisClass.currentTTSStatus = TTSLicenseStatus.LicenseCorrupt;
        } else if (response.get_tts_license_status == "LicenseSystemError") {
          thisClass.currentTTSStatus = TTSLicenseStatus.LicenseSystemError;
        } else if (response.get_tts_license_status == "LicenseWrongMac") {
          thisClass.currentTTSStatus = TTSLicenseStatus.LicenseWrongMac;
        } else {
          thisClass.currentTTSStatus = TTSLicenseStatus.LicenseCorrupt;
        }
      });
    }
    websocket.onerror = function(evt) {
      thisClass.currentTTSStatus = TTSLicenseStatus.LicenseCorrupt;
    };
  }

  this.requestInstalledTTSVoices = function() {
    var websocket = CreateWebSocket();
    websocket.onopen = function(evt) {
      var playlistSocket = new PlaylistSocket(websocket);
      playlistSocket.getInstalledTTSVoices(function(response) {
        if (response.response == "get_installed_tts_voices") {
          thisClass.installedTTSVoices = response.voices;
        } else {
          thisClass.installedTTSVoices = undefined;
        }
      });
    }
    websocket.onerror = function(evt) {
      thisClass.installedTTSVoices = undefined;
    };
  }

  this.wrongAppStatePage = function() {
    if (!thisClass.divAppStatus) {
      thisClass.divAppStatus = document.createElement('div');
      var headerAppStatus = document.createElement('h3');
      headerAppStatus.setAttribute('class', 'h3');
      headerAppStatus.appendChild(document.createTextNode(i18n.translate('error_title_WrongAppState')));
      var pAppStatus = document.createElement('p');
      var sonos_status = document.createTextNode(i18n.translate('error_text_WrongAppState_na'));
      pAppStatus.appendChild(sonos_status);
      thisClass.divAppStatus.appendChild(headerAppStatus);
      thisClass.divAppStatus.appendChild(pAppStatus);
      thisClass.divAppStatus.appendChild(document.createElement('br'));

      thisClass.dataBindings.push(function() {
        if (mainSite.appState && mainSite.appState.state != 'Running' && mainSite.deviceInfo.EtsDownload == true) {
          switch (mainSite.appState.state) {
            case 'Stopped':
              sonos_status.nodeValue = i18n.translate('error_text_WrongAppState_0');
              thisClass.showPageContent(thisClass.divAppStatus);
              break;
            case 'Starting':
              sonos_status.nodeValue = i18n.translate('error_text_WrongAppState_1');
              thisClass.showPageContent(thisClass.divAppStatus);
              break;
            case 'Stopping':
              sonos_status.nodeValue = i18n.translate('error_text_WrongAppState_3');
              thisClass.showPageContent(thisClass.divAppStatus);
              break;
            default:
              sonos_status.nodeValue = i18n.translate('error_text_WrongAppState_na');
              thisClass.showPageContent(thisClass.divAppStatus);
              break;
          }
        } else if (!mainSite.appState && mainSite.deviceInfo && mainSite.deviceInfo.EtsDownload == true) {
          sonos_status.nodeValue = i18n.translate('error_text_WrongAppState_na');
          thisClass.showPageContent(thisClass.divAppStatus);
        }
      });

    }
  }

  // Initialize/update the playlist table content
  this.updatePlaylistTable = function() {
    if (thisClass.playlistConfigurationChanged) {
      return;
    }

    var currentPagination = undefined;
    var playlistTable;
    // get table api reference:
    if ($.fn.dataTable.isDataTable(thisClass.configTable)) {
      // table already initialized
      currentPagination = $(thisClass.configTable).dataTable().api().page();
      // get instance
      playlistTable = $(thisClass.configTable).DataTable();
      // delete rows
      playlistTable.rows().remove().draw();
    } else {
      // table not initialized
      if (!thisClass.contentSection.contains(thisClass.divSonosPlaylistMapping)) {
        setTimeout(thisClass.updatePlaylistTable, 200);
        return;
      }
      playlistTable = $(thisClass.configTable).DataTable({
        "language": i18n.msgDatatablesStore,
        "columns": [
          {
            data: 'number',
            "width": "5%"
          },
          {
            data: 'src_type',
            "width": "15%"
          },
          {
            data: 'src',
            "width": "35%"
          },
          {
            data: 'title',
            "width": "5%"
          },
          {
            data: 'announcement',
            "width": "5%"
          },
          {
            data: 'unmute',
            "width": "5%"
          },
          {
            data: 'playMode',
            "width": "5%"
          },
          {
            data: 'repeatMode',
            "width": "5%"
          },
          {
            data: 'volume',
            "width": "5%"
          },
          {
            data: 'changed',
            "width": "5%"
          }
        ],
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
          thisClass.createSourceTypeSelect(aData, nRow.cells[1]);
          thisClass.createSourceSelect(aData, nRow.cells[2]);
          thisClass.createTitleSelector(aData, nRow.cells[3]);
          thisClass.createAnnouncementSelector(aData, nRow.cells[4]);
          thisClass.createUnmuteSelector(aData, nRow.cells[5]);
          thisClass.createPlayModeSelector(aData, nRow.cells[6]);
          thisClass.createRepeatModeSelector(aData, nRow.cells[7]);
          thisClass.createVolumeSelector(aData, nRow.cells[8]);
        },
        "aoColumnDefs": [
          {
            "visible": false,
            "aTargets": [9]
          }
        ]
      });

      $(thisClass.configTable.tBodies[0]).on('click', 'tr', function() {
        if ($(this).hasClass('selected')) {
          $(this).removeClass('selected');
        } else {
          playlistTable.$('tr.selected').removeClass('selected');
          $(this).addClass('selected');
          // Ok current row has been selected, call another function:
          var aData = $(thisClass.configTable).dataTable().fnGetData(this); // get datarow
          if (null != aData) // null if we clicked on title row
          {
            //now aData[0] - 1st column(count_id), aData[1] -2nd, etc.
            thisClass.currentRowData = aData;
          }
        }
      });
    }

    // now add new/updated rows:
    // Magick number of maximum KNX bus supported playlists: 255
    // We count the indice j from 1 to 255 (the visible numbers).
    var rows = [];
    for (var i = 0; i < thisClass.currentPlaylistConfig.playlists.length; ++i) {
      var slot = parseInt(thisClass.currentPlaylistConfig.playlists[i]['number']) - 1;
      rows[slot] = new KimPlaylist(thisClass.currentPlaylistConfig.playlists[i]);
    }
    for (var i = 0; i < 255; ++i) {
      if (rows[i]) {
        continue;
      }
      rows[i] = new KimPlaylist({
        "number": (i + 1),
        "source": {
          "name": "",
          "type": "none"
        }
      });
    }
    playlistTable.rows.add(rows);
    thisClass.setChanged(!thisClass.currentPlaylistConfig.playlists_persisted);
    playlistTable.draw();
    if (currentPagination !== undefined) {
      $(thisClass.configTable).dataTable().api().page(currentPagination).draw(false);
    }
  }

  // Init function for Datatables, called to create a source type select in the cell described by aData.
  this.createSourceTypeSelect = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    var selection = document.createElement('select');
    selection.setAttribute('id', 'sourcetype_' + aData['number']);
    selection.setAttribute('name', 'src_type');
    selection.setAttribute('form', 'src_type_form');
    var thisSelection = selection;
    selection.addEventListener('change', function() {
      thisClass.sourceTypeChanged(thisSelection, aData);
    });

    var sourceTypes = ["none", "Radio", "Sonos", "AudioIn", "TV"]; /* Deactivate the unsupported source type:--> , "TextToSpeech"]; <--*/

    var sourceTypeNames = [i18n.translate("source_type_select"), i18n.translate("source_type_Radio"), i18n.translate("source_type_Sonos"), i18n.translate("source_type_AudioIn"), i18n.translate("source_type_TV"), i18n.translate("source_type_TextToSpeech")];

    for (var i = 0; i < sourceTypes.length; i++) {
      var option = document.createElement('option');
      option.value = sourceTypes[i]
      if (aData["src_type"] === sourceTypes[i]) {
        option.setAttribute('selected', '');
      }
      option.appendChild(document.createTextNode(sourceTypeNames[i]));
      selection.appendChild(option);
    }
    parent.appendChild(selection);
  }

  // Init function for Datatables, called to create a source datalist in the cell described by aData.
  this.createSourceSelect = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    // First build the input box or a non editable label if we have no src_type selected:
    var inputbox = document.createElement('input');
    inputbox.setAttribute('id', 'sourceselect_' + aData['number']);
    inputbox.setAttribute("size", "70");
    inputbox.setAttribute("type", "text");
    inputbox.setAttribute("list", aData['src_type'] + "_sources");
    inputbox.setAttribute("name", "src");
    inputbox.addEventListener('change', function() {
      thisClass.sourceChanged(inputbox, aData);
    });
    if (aData['src_type'] !== SOURCETYPES.NONE && aData['src_type'] !== SOURCETYPES.TEXTTOSPEECH) {
      var initializedDataList = false;
      inputbox.value = aData['src'];

      inputbox.onfocus = function() {
        if (initializedDataList) {
          return;
        }
        initializedDataList = true;
        thisClass.initializeDataList(aData, parent);
      };
    }
    // Non editable InputBox with text
    if (aData['src_type'] === SOURCETYPES.TEXTTOSPEECH) {
      // TODO: this makes no sense
      //inputbox.onclick = goToLicenseWebsite();
      // better way:
      if (thisClass.currentTTSStatus === TTSLicenseStatus.LicenseOK) {
        inputbox.value = aData['src'];
        inputbox.onkeyup = thisClass.ttsTextChanged(inputbox);
      } else {
        inputbox.value = i18n.translate("tts_license_corrupt");
        inputbox.setAttribute('readOnly', true);
        if (thisClass.currentTTSStatus === TTSLicenseStatus.LicenseCorrupt) {
          inputbox.value = i18n.translate("tts_license_corrupt");
        }
        if (thisClass.currentTTSStatus === TTSLicenseStatus.LicenseWrongMac || thisClass.currentTTSStatus === TTSLicenseStatus.LicenseSystemError) {
          inputbox.value = i18n.translate("tts_license_wrong_mac");
        }
        inputbox.onclick = function() {
          dialog = new ModalConfirmDialogOk(i18n.translate("source_type_TextToSpeech"), i18n.translate("tts_license_corrupt"));
          dialog.prepare();
        }
      }
    }
    if (aData['src_type'] && aData['src_type'] !== SOURCETYPES.NONE) {
      parent.append(inputbox);
    }
  }

  this.createTitleSelector = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    var selection = undefined;
    // First build the input box or a non editable label if we have a Sonos src_type selected:
    if (aData['src_type'] === SOURCETYPES.SONOS && ((aData['playMode'] !== 'shuffle_on' && aData['playMode'] !== 'random_start') || aData['announcement'])) {
      selection = document.createElement('input');
      selection.id = 'title_' + aData['number'];
      selection.setAttribute('size', '3');
      selection.type = 'text';
      selection.name = 'title';
      selection.value = aData['title'];
      selection.addEventListener('keyup', function() {
        thisClass.titleEdited(selection, aData);
      });
      selection.addEventListener('change', function() {
        thisClass.titleChanged(selection, aData);
      });
    }
    if (aData['src_type'] === SOURCETYPES.TEXTTOSPEECH && thisClass.currentTTSStatus === TTSLicenseStatus.LicenseOK) {
      // Build selection box for voices if tts is activated

      var voices = thisClass.installedTTSVoices;
      selection = document.createElement('select');
      selection.setAttribute('id', 'voice_' + aData['number']);
      selection.setAttribute('form', 'src_type_form');
      selection.setAttribute('name', 'voice');
      selection.setAttribute('value', aData['voice']);
      selection.addEventListener('change', function() {
        thisClass.voiceChanged(selection);
      });
      selection.addEventListener('click', function() {
        aData.selected = true;
      });

      // first none selected
      var optionVoice = document.createElement('option');
      optionVoice.value = 'none';
      optionVoice.appendChild(document.createTextNode(i18n.translate("voice_select")));
      selection.appendChild(optionVoice);
      if (thisClass.currentTTSStatus === TTSLicenseStatus.LicenseOK) {
        for (var i = 0; i < voices.length; i++) {
          optionVoice = document.createElement('option');
          optionVoice.value = voices[i].split(" (")[0];
          if (aData["voice"] === voices[i].split(" (")[0]) {
            optionVoice.setAttribute('selected', voices[i]);
          }
          optionVoice.appendChild(document.createTextNode(voices[i]));
          selection.appendChild(optionVoice);
        }
      }
    }
    if (selection) {
      parent.append(selection);
    }
  }

  this.createAnnouncementSelector = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    if ((aData['src_type'] === SOURCETYPES.SONOS) || (aData['src_type'] === SOURCETYPES.TEXTTOSPEECH && thisClass.CurrentTTSStatus === TTSLicenseStatus.LicenseOK)) {
      var selection = document.createElement('input');
      selection.id = 'anCbx_' + aData['number'];
      selection.type = 'checkbox';
      selection.name = 'announcement';
      selection.form = 'announcement_form';
      selection.addEventListener('change', function() {
        thisClass.announcementChanged(selection, aData);
      });
      selection.addEventListener('click', function() {
        aData.selected = true;
      });
      selection.checked = aData['announcement'];
      parent.appendChild(selection);
    }
  }

  this.createUnmuteSelector = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    if (aData['src_type'] !== "none") {
      var selection = document.createElement('input');
      selection.id = 'umCbx_' + aData['number'];
      selection.type = 'checkbox';
      selection.name = 'unmute';
      selection.form = 'unmute_form';
      selection.addEventListener('change', function() {
        thisClass.unmuteChanged(selection, aData);
      });
      selection.addEventListener('click', function() {
        aData.selected = true;
      });
      selection.checked = aData['unmute'];
      parent.append(selection);
    }
  }

  this.createVolumeSelector = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    if (aData['src_type'] !== SOURCETYPES.NONE) {
      var selection = document.createElement('select');
      selection.id = 'volume_' + aData['number'];
      selection.name = 'volume';
      selection.form = 'volume_form';
      selection.addEventListener('change', function() {
        thisClass.volumeChanged(selection, aData);
      });

      var selectedVolume = aData['volume'];
      var volumeOption = document.createElement('option');
      volumeOption.value = '';
      volumeOption.appendChild(document.createTextNode(i18n.translate("unchanged")));
      var same = $('<option/>').attr("value", "").html();
      var volumeInt = undefined;
      if (selectedVolume < 0) {
        volumeOption.setAttribute('selected', '');
      }
      selection.appendChild(volumeOption);
      for (var i = 0; i <= 100; i += 5) {
        var str = i.toString();
        volumeOption = document.createElement('option');
        volumeOption.value = str;
        volumeOption.appendChild(document.createTextNode(str + '%'));
        if ((selectedVolume >= 0) && (i >= selectedVolume)) {
          volumeOption.setAttribute('selected', '');
          selectedVolume = undefined;
        }
        selection.appendChild(volumeOption);
      }
      parent.appendChild(selection);
    }
  }

  this.createPlayModeSelector = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    if (aData['src_type'] === SOURCETYPES.SONOS && aData['announcement'] == false) {
      var selection = document.createElement('select');
      selection.id = 'playMode_' + aData['number'];
      selection.name = 'playMode';
      selection.form = 'playMode_form';
      selection.addEventListener('change', function() {
        thisClass.playModeChanged(selection, aData);
      });

      var selectedPlayMode = aData['playMode'];
      var playModes = ["unchanged", "shuffle_on", "shuffle_off", "random_start"];
      for (var i = 0; i < playModes.length; i++) {
        var playModeOption = document.createElement('option');
        playModeOption.value = playModes[i];
        playModeOption.appendChild(document.createTextNode(i18n.translate(playModes[i])));
        if (aData['playMode'] === playModes[i]) {
          playModeOption.setAttribute('selected', '');
        }
        selection.appendChild(playModeOption);
      }
      parent.appendChild(selection);
    }
  }

  this.createRepeatModeSelector = function(aData, parent) {
    while (parent.hasChildNodes()) {
      parent.removeChild(parent.firstChild);
    }
    if (aData['src_type'] === SOURCETYPES.SONOS && aData['announcement'] == false) {
      var selection = document.createElement('select');
      selection.id = 'repeatMode_' + aData['number'];
      selection.name = 'repeatMode';
      selection.form = 'repeatMode_form';
      selection.addEventListener('change', function() {
        thisClass.repeatModeChanged(selection, aData);
      });

      var selectedRepeatMode = aData['repeatMode'];
      var repeatModes = ["unchanged", "repeat_on", "repeat_off"];
      for (var i = 0; i < repeatModes.length; i++) {
        var repeatModeOption = document.createElement('option');
        repeatModeOption.value = repeatModes[i];
        repeatModeOption.appendChild(document.createTextNode(i18n.translate(repeatModes[i])));
        if (aData['repeatMode'] === repeatModes[i]) {
          repeatModeOption.setAttribute('selected', '');
        }
        selection.appendChild(repeatModeOption);
      }
      parent.append(selection);

    }
  }

  ////////////////////
  this.savePlaylists = function() {
    var saveRequestPlaylists = thisClass.createResultingPlaylist();
    websocket = CreateWebSocket();
    websocket.onopen = function(evt) {
      var playlistSocket = new PlaylistSocket(websocket);
      playlistSocket.savePlaylists(thisClass.currentGroup, saveRequestPlaylists, function(response) {
        if (response.response === "saved") {
          // perhaps it makes sense to reset changed only here, so in case of an error, the user still sees his changes (if we mark them)
          thisClass.setChanged(false);
          thisClass.currentPlaylistConfig = undefined;
          thisClass.requestPlaylistsAndSources(thisClass.currentGroup);
        } else {
          CreateErrorDialog(i18n.translateAlert('alert_save_playlist1') + (thisClass.currentGroup + 1) + i18n.translateAlert('alert_save_playlist2') + response.response + '!');
        }
      });
    };
    websocket.onerror = function(evt) {
      CreateErrorDialog(i18n.translateAlert('alert_wss_connection'));
    };
  }

  // Create a changed playlist for the save command and reset the internal changed flag.
  this.createResultingPlaylist = function() {
    var tabledata = $(thisClass.configTable).DataTable();
    var result = [];
    for (var i = 0; i < tabledata.data().length; i++) {
      var data = tabledata.row(i).data();
      // we send only rows, which has been modified by the user:
      if (data.changed == true) {
        // We could add or change and entry (valid src_type and src) or delete an entry (src_type or src 'none' or src is an empty string (not allowed by Sonos)).
        if ((data.src_type == "none") || (data.src == "") || (data.src == "")) {
          result.push({
            "number": data.number,
          });
        } else {
          var mapping = {
            "number": data.number,
            "source": {
              "name": data.src,
              "type": data.src_type
            }
          };
          if (data.title && (data.title >= 1)) {
            mapping.title = data.title;
          }
          if (data.announcement) {
            mapping.announcement = true;
          }
          if (data.unmute) {
            mapping.unmute = true;
          }
          if (data.voice) {
            var v_name = data.voice.split(" (")[0];
            mapping.voice = v_name;
          }
          if ((data.volume !== undefined) && (data.volume >= 0)) {
            mapping.volume = data.volume;
          }
          if (data.playMode !== undefined) {
            mapping.play_mode = data.playMode;
          } else {
            mapping.play_mode = "unchanged";
          }
          if (data.repeatMode !== undefined) {
            mapping.repeat_mode = data.repeatMode;
          } else {
            mapping.repeat_mode = "unchanged";
          }
          result.push(mapping);
        }
        // We reset the changed flag here.
        data.changed = false;
      }
    }
    // redraw table
    tabledata.draw(true);
    return result;
  }

  this.initializeDataList = function(aData, parent) {
    var datalist = document.createElement('datalist');
    datalist.setAttribute('id', aData['src_type'] + "_sources");
    datalist.setAttribute('name', 'src');
    datalist.setAttribute('form', 'src_form');
    //datalist.addEventListener('change', thisClass.sourceChanged(datalist, aData));

    for (var i = 0; i < thisClass.currentPlaylistConfig.available_sources.length; i++) {
      if (thisClass.currentPlaylistConfig.available_sources[i].type === aData['src_type']) {
        var datalistOption = document.createElement('option');
        datalistOption.value = thisClass.currentPlaylistConfig.available_sources[i].name;
        datalistOption.appendChild(document.createTextNode(thisClass.currentPlaylistConfig.available_sources[i].name));
        datalist.appendChild(datalistOption);
      }
    }
    parent.append(datalist);
  }

  // Callback function if the source is changed
  this.sourceChanged = function(origin, aData) {
    var playlistTable = $(thisClass.configTable).dataTable();
    var currentPagination = playlistTable.api().page();
    var playlistTableRowData = $(thisClass.configTable).DataTable().row(aData.number - 1).data();
    playlistTableRowData.src = origin.value;
    // mark line for updating data
    playlistTableRowData.changed = true;
    thisClass.setChanged(true);
    // go back to last page after table redraw:
    playlistTable.api().page(currentPagination).draw(false);
  }

  this.sourceTypeChanged = function(origin, aData) {
    var playlistTable = $(thisClass.configTable).dataTable();
    var currentPagination = playlistTable.api().page();
    var data = new KimPlaylist({
      "number": aData.number
    });
    data.changed = true; // mark line for updating data
    data.src_type = origin.value;
    thisClass.setChanged(true);
    playlistTable.fnUpdate(data, parseInt(origin.id.split("_")[1]) - 1, undefined);
    playlistTable.api().page(currentPagination).draw(false);
  }

  this.titleChanged = function(origin, aData) {
    if ((origin.style.backgroundColor !== "red") && (origin.value.length > 0)) {
      var playlistTable = $(thisClass.configTable).dataTable();
      var currentPagination = playlistTable.api().page();
      var playlistTableRowData = $(thisClass.configTable).DataTable().row(aData.number - 1).data();
      playlistTableRowData.title = parseInt(origin.value);
      // mark line for updating data
      playlistTableRowData.changed = true;
      thisClass.setChanged(true);
      playlistTable.api().page(currentPagination).draw(false);
    }
  }

  this.titleEdited = function(selected) {
    var regDigit = /^\d+$/;
    if ((selected.value.length > 0) && ((!regDigit.test(selected.value)) || (parseInt(selected.value) < 1))) {
      selected.style.backgroundColor = "red";
    } else {
      selected.style.backgroundColor = "";
    }
  }

  this.ttsTextChanged = function(selected) {
    thisClass.setChanged(true);
    while ((selected.value.length > 100)) {
      var str = selected.value;
      str = str.substring(0, str.length - 1);
      selected.value = str;
    }
  }

  //TODO: Needs to be converted alike to all other change callbacks
  this.voiceChanged = function(origin) {
    if ((origin.style.backgroundColor !== "red") && (origin.value.length > 0)) {
      if (thisClass.currentRowData != undefined) {
        var selectedCbxID = "voice_" + thisClass.currentRowData['number'];
      } else {
        var selectedCbxID = "";
      }
      if (origin.id == selectedCbxID) {
        //case: row of data table is preselected
        thisClass.currentRowData['voice'] = origin.value;
        thisClass.currentRowData['changed'] = true;
        thisClass.setChanged(true);
        var playlistTable = $(thisClass.configTable).dataTable();
        var currentPagination = playlistTable.api().page();
        playlistTable.fnUpdate(thisClass.currentRowData['voice'], parseInt(thisClass.currentRowData['number']) - 1, 3);
        // go back to last page after table redraw:
        playlistTable.api().page(currentPagination).draw(false);
      } else {
        //case: checkbox is clicked without selecting its parent row
        var index = parseInt(origin.id.split("_")[1]) - 1;
        var playlistData = $(thisClass.configTable).DataTable(); // get the Data Object
        var data = playlistData.row(index).data(); //getting row data
        data.voice = origin.value; //setting the value manually
        data.changed = true; // mark line for updating data
        thisClass.setChanged(true);
        var playlistTable = $(thisClass.configTable).dataTable();
        var currentPagination = playlistTable.api().page();
        playlistTable.fnUpdate(origin.value, index, 3);
        playlistTable.api().page(currentPagination).draw(false);
      }
    }
  }

  this.announcementChanged = function(origin, aData) {
    var playlistTable = $(thisClass.configTable).dataTable();
    var currentPagination = playlistTable.api().page();
    var playlistTableRowData = $(thisClass.configTable).DataTable().row(aData.number - 1).data();
    playlistTableRowData.announcement = origin.checked;
    // mark line for updating data
    playlistTableRowData.changed = true;
    thisClass.setChanged(true);
    playlistTable.api().page(currentPagination).draw(false);
  }

  this.unmuteChanged = function(origin, aData) {
    var playlistTable = $(thisClass.configTable).dataTable();
    var currentPagination = playlistTable.api().page();
    var playlistTableRowData = $(thisClass.configTable).DataTable().row(aData.number - 1).data();
    playlistTableRowData.unmute = origin.checked;
    // mark line for updating data
    playlistTableRowData.changed = true;
    thisClass.setChanged(true);
    playlistTable.api().page(currentPagination).draw(false);
  }

  this.volumeChanged = function(origin, aData) {
    var playlistTable = $(thisClass.configTable).dataTable();
    var currentPagination = playlistTable.api().page();
    var parsedValue = (origin.value === "" ? -1 : parseInt(origin.value));
    var playlistTableRowData = $(thisClass.configTable).DataTable().row(aData.number - 1).data();
    playlistTableRowData.volume = parsedValue;
    // mark line for updating data
    playlistTableRowData.changed = true;
    thisClass.setChanged(true);
    playlistTable.api().page(currentPagination).draw(false);
  }

  this.playModeChanged = function(origin, aData) {
    var playlistTable = $(thisClass.configTable).dataTable();
    var currentPagination = playlistTable.api().page();
    var parsedValue = origin.value === "" ? "unchanged" : origin.value;
    var playlistTableRowData = $(thisClass.configTable).DataTable().row(aData.number - 1).data();
    playlistTableRowData.playMode = parsedValue;
    // mark line for updating data
    playlistTableRowData.changed = true;
    thisClass.setChanged(true);
    playlistTable.api().page(currentPagination).draw(false);
  }

  this.repeatModeChanged = function(origin, aData) {
    var playlistTable = $(thisClass.configTable).dataTable();
    var currentPagination = playlistTable.api().page();
    var parsedValue = origin.value === "" ? "unchanged" : origin.value;
    var playlistTableRowData = $(thisClass.configTable).DataTable().row(aData.number - 1).data();
    playlistTableRowData.repeatMode = parsedValue;
    // mark line for updating data
    playlistTableRowData.changed = true;
    thisClass.setChanged(true);
    playlistTable.api().page(currentPagination).draw(false);
  }

  this.requestData = function() {
    mainSite.timer.getDeviceInfo.addCallbackFunction(thisClass.update);
    mainSite.timer.getDeviceInfo.oneShot();

    if (!mainSite.timer.getAppState) {
      mainSite.timer.getAppState = new TimedRequest(INTERVAL.HALFMINUTE, 'getAppState', '', mainSite.setAppState);
      mainSite.timer.getAppState.addCallbackFunction(thisClass.update);
      mainSite.timer.getAppState.oneShot();
    } else {
      mainSite.timer.getAppState.timeout = INTERVAL.HALFMINUTE;
      mainSite.timer.getAppState.addCallbackFunction(thisClass.update);
    }
    mainSite.timer.getAppState.resetTimeout();
    mainSite.timer.getAppState.oneShot();
  };

  this.update = function() {
    //update data in site
    for (var i = 0; i < thisClass.dataBindings.length; i++) {
      thisClass.dataBindings[i]();
    }
  };
}

PlaylistConfigurationPage.prototype = new PlaylistConfigurationPage();
PlaylistConfigurationPage.prototype.constructor = PlaylistConfigurationPage;

// Helper to translate between JSON and Datatable fields
function KimPlaylist(entry) {
  this.number = entry.number;
  if (entry.source) {
    this.src_type = (entry.source.type != undefined) ? entry.source.type : SOURCETYPES.NONE;
    this.src = (entry.source.name != undefined) ? entry.source.name : '';
  } else {
    this.src_type = 'none';
    this.src = '';
  }
  this.changed = entry.changed || false;
  this.title = entry.title || 1;
  this.voice = entry.voice;
  this.announcement = entry.announcement || false;
  this.unmute = entry.unmute || false;
  this.volume = (entry.volume != undefined) ? entry.volume : -1;
  this.playMode = (entry.play_mode != undefined) ? entry.play_mode : 'unchanged';
  this.repeatMode = (entry.repeat_mode != undefined) ? entry.repeat_mode : 'unchanged';
}

var TTSLicenseStatus = Object.freeze({
  LicenseOK: {},
  LicenseCorrupt: {},
  LicenseSystemError: {},
  LicenseWrongMac: {}
});

/*
 * ##################################################### End PlaylistConfigurationPage #####################################################
*/
/*###################################################### www/web/playlist.js #############################################*/
/*###################################################### www/web/playlistsocket.js #############################################*/
/*
 * playlistsocket.js
 * copyright 2013-2014 (c) ise GmbH, Oldenburg, Germany
 */

function EndsWith(full, end) {
  return full.substr(full.length - end.length, end.length) === end;
}

function IsSdaHost(host) {
  var sdaHosts = [
    "httpaccess.net",
    "httpaccess.ise.de",
    "rchttpaccess.net"
  ];
  return sdaHosts.some(function(end) {
    return EndsWith(host, end);
  });
}

function GetWebSocketURL(host, webSocketPort) {
  if (IsSdaHost(host)) {
    var h = host.lastIndexOf("-h-");
    return "wss://" + host.substr(0, h) + "-h" + webSocketPort.toString() + "-" + host.substr(h + 3);
  } else {
    return "ws://" + host + ":" + webSocketPort.toString();
  }
}

function CreateWebSocket() {
  var host = window.location.host;
  var uri = GetWebSocketURL(host.split(":")[0], 8153);
  return new WebSocket(uri);
}

var PlaylistSocket = function() {
  var socket = function(websocket) {
    this.websocket = websocket;
    this.pendingRequests = [];
    var this_ = this;
    websocket.onmessage = function(event) {
      if (this_.pendingRequests.length === 0) {
        //TODO unexpected message
        return;
      }
      var response = jQuery.parseJSON(event.data);
      var responseType = response.response;
      var requestSent = this_.pendingRequests.shift();
      if (responseType === "playlists_and_sources") {
        if (requestSent.request === "get_playlists_and_sources") {
          requestSent.callback(response);
          return;
        } else {
          //TODO: wrong response type
        }
      } else if (responseType === "syntax_error") {
        //TODO
      } else if (responseType === "unknown_request") {
        //TODO
      } else if (responseType === "get_tts_license_status") {
        if (requestSent.request === "get_tts_license_status") {
          requestSent.callback(response);
          return;
        }
      } else if (responseType === "get_installed_tts_voices") {
        if (requestSent.request === "get_installed_tts_voices") {
          requestSent.callback(response);
          return;
        }
      } else {
        //TODO unknown response type
      }
      requestSent.callback(response);
    };
    websocket.onerror = function(error) {
      console.log(error);
      if (error.target.readyState == 3) {
        // handled in playlist.js
        //alert("Lost connection to websocket service. Please check the connection and reload this page.");
      }
    }
    websocket.onclose = function(event) {
      // override default handler (shows an alert box)
    }
  }

  socket.prototype.getPlaylistsAndSources = function(group, callback) {
    var request = {
      "request": "get_playlists_and_sources",
      "group": group
    };
    var requestStr = JSON.stringify(request);
    this.websocket.send(requestStr);
    this.pendingRequests.unshift(
      {
        request: "get_playlists_and_sources",
        callback: callback
      });
  };

  socket.prototype.savePlaylists = function(group, playlists, callback) {
    var request = {
      "request": "save_playlists",
      "group": group,
      "playlists": playlists
    };
    var requestStr = JSON.stringify(request);
    this.websocket.send(requestStr);
    this.pendingRequests.unshift(
      {
        request: "save_playlists",
        callback: callback
      });
  };

  socket.prototype.getTTSLicenseStatus = function(callback) {
    var request = {
      "request": "get_tts_license_status",
    };
    var requestStr = JSON.stringify(request);
    this.websocket.send(requestStr);
    this.pendingRequests.unshift(
      {
        request: "get_tts_license_status",
        callback: callback
      });
  };

  socket.prototype.getInstalledTTSVoices = function(callback) {
    var request = {
      "request": "get_installed_tts_voices",
    };
    var requestStr = JSON.stringify(request);
    this.websocket.send(requestStr);
    this.pendingRequests.unshift(
      {
        request: "get_installed_tts_voices",
        callback: callback
      });
  };
  return socket;
}();
/*###################################################### www/web/playlistsocket.js #############################################*/
