/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.triggers.TriggerEvent;

public abstract class Trigger {
    private boolean disarmed = false;
    private Animator animator;
    private Animator reverseAnimator;
    private TriggerEvent triggerEvent;
    private boolean autoReverse = false;

    protected Trigger(Animator animator) {
        this(animator, null);
    }

    protected Trigger(Animator animator, TriggerEvent triggerEvent) {
        this(animator, triggerEvent, false);
    }

    protected Trigger(Animator animator, TriggerEvent triggerEvent, boolean bl) {
        this.animator = animator;
        this.triggerEvent = triggerEvent;
        this.autoReverse = bl;
    }

    public void disarm() {
        this.disarmed = true;
    }

    protected void fire(TriggerEvent triggerEvent) {
        if (this.disarmed) {
            return;
        }
        if (triggerEvent == this.triggerEvent) {
            if (this.autoReverse) {
                if (this.animator.isRunning()) {
                    float f = this.animator.getTimingFraction();
                    this.animator.stop();
                    this.animator.setStartFraction(f);
                } else {
                    this.animator.setStartFraction(0.0f);
                }
            }
            if (this.animator.isRunning()) {
                this.animator.stop();
            }
            this.animator.setStartDirection(Animator.Direction.FORWARD);
            this.fire();
        } else if (this.triggerEvent != null && triggerEvent == this.triggerEvent.getOppositeEvent() && this.autoReverse) {
            if (this.animator.isRunning()) {
                float f = this.animator.getTimingFraction();
                this.animator.stop();
                this.animator.setStartFraction(f);
            } else {
                this.animator.setStartFraction(1.0f - this.animator.getStartFraction());
            }
            this.animator.setStartDirection(Animator.Direction.BACKWARD);
            this.fire();
        }
    }

    protected void fire() {
        if (this.disarmed) {
            return;
        }
        if (this.animator.isRunning()) {
            this.animator.stop();
        }
        this.animator.start();
    }
}

