/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils.localization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.ZipInputStream;

public class Messages {
    private ResourceBundle messages;
    private PropertyResourceBundle externalMessages;

    public Messages(String string) {
        try {
            this.messages = ResourceBundle.getBundle(string, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZippedLanguage(URL uRL) {
        ZipInputStream zipInputStream = null;
        try {
            System.out.println("looking for localization: " + uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            zipInputStream = new ZipInputStream(uRLConnection.getInputStream());
            zipInputStream.getNextEntry();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
            this.externalMessages = new PropertyResourceBundle(inputStreamReader);
            zipInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("No external localization found.");
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String getLang() {
        return Locale.getDefault().getLanguage();
    }

    public char getMnemonic(String string) {
        String string2 = this.getString(string);
        if (string2.length() == 0) {
            return '0';
        }
        return string2.charAt(0);
    }

    public String getString(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        if (this.messages != null) {
            block6: {
                if (this.externalMessages != null) break block6;
                return this.messages.getString(string);
            }
            try {
                return this.externalMessages.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    return this.messages.getString(string);
                }
                catch (MissingResourceException missingResourceException2) {
                    // empty catch block
                }
            }
        }
        System.err.println("Localization missing for: " + string + " (" + new Throwable().getStackTrace()[1].getClassName() + ")");
        return '!' + string + '!';
    }
}

