/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils.licence;

import de.eibport.utils.Base64;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class LicencePool {
    public static final String LICENCE_FILE_HTTP_PATH = "/licence/licence.xml";
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_DEMO_ACTIVE = 2;
    public static final int STATE_DEMO_EXPIRED = 3;
    public static final String KEY_RAP = "rap";
    public static final String KEY_HIC_PHONE = "hic.iphone";
    private Document doc;
    private static LicencePool instance = null;
    private URL baseURL;
    private boolean licencesParsed = false;
    private boolean licenceFileLoaded = false;
    private HashMap<String, Object> licences = new HashMap();

    private LicencePool(URL uRL) {
        this.baseURL = uRL;
    }

    public Date getCreation() {
        Long l = Long.parseLong(this.doc.getRootElement().getChildText("creation"));
        return new Date(l);
    }

    public boolean isAvailable() {
        return this.licenceFileLoaded;
    }

    public int getOwnerId() {
        String string = this.doc.getRootElement().getChildText("ownerId");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public String getCompany() {
        return this.doc.getRootElement().getChildText("company");
    }

    public String getCustomer() {
        return this.doc.getRootElement().getChildText("customer");
    }

    public String getProject() {
        return this.doc.getRootElement().getChildText("project");
    }

    public String getData() {
        String string = this.doc.getRootElement().getChildText("data");
        if (string == null) {
            return null;
        }
        try {
            string = new String(Base64.fromBase64(string), "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String[] getLicenceKeys() {
        if (!this.licencesParsed) {
            this.parseLicences();
        }
        return this.licences.keySet().toArray(new String[this.licences.size()]);
    }

    public String getLicenceDescription(String string) {
        if (!this.licencesParsed) {
            this.parseLicences();
        }
        return ((Element)this.licences.get(string)).getChildText("description");
    }

    public int getLicenceState(String string, String string2) {
        if (!this.licencesParsed) {
            this.parseLicences();
        }
        if (this.licences.get(string) == null) {
            return 0;
        }
        if (this.getData() != null && this.getData().length() > 0 && !string2.equals(this.getData())) {
            return 0;
        }
        if (this.getExpiredDate(string) != null) {
            if (this.getExpiredDate(string).before(new Date())) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public Date getExpiredDate(String string) {
        String string2;
        if (!this.licencesParsed) {
            this.parseLicences();
        }
        if (this.licences.get(string) != null && (string2 = ((Element)this.licences.get(string)).getChildText("expires")) != null) {
            long l = Long.parseLong(string2);
            Date date = new Date(l);
            return date;
        }
        return null;
    }

    private void parseLicences() {
        if (this.doc == null) {
            return;
        }
        List list = this.doc.getRootElement().getChildren("licence");
        for (int i = 0; i < list.size(); ++i) {
            this.licences.put(((Element)list.get(i)).getChildText("product"), list.get(i));
        }
    }

    private void loadLicence(URL uRL, boolean bl) {
        this.licenceFileLoaded = false;
        this.licences.clear();
        this.licencesParsed = false;
        try {
            URL uRL2 = new URL(uRL, LICENCE_FILE_HTTP_PATH);
            URLConnection uRLConnection = uRL2.openConnection();
            uRLConnection.setUseCaches(false);
            this.doc = new SAXBuilder().build(uRLConnection.getInputStream());
            this.licenceFileLoaded = true;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("No licencefile found!");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
    }

    public void reload(boolean bl) {
        this.licencesParsed = false;
        this.loadLicence(this.baseURL, bl);
    }

    public void dispose() {
        instance = null;
    }

    public static LicencePool getInstance(URL uRL, boolean bl, boolean bl2) {
        if (instance == null) {
            instance = new LicencePool(uRL);
        }
        if (bl) {
            instance.loadLicence(uRL, bl2);
        }
        return instance;
    }
}

