/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.utils;

import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class PrintfFormat {
    private Vector vFmt = new Vector();
    private int cPos = 0;
    private DecimalFormatSymbols dfs = null;

    public PrintfFormat(String string) throws IllegalArgumentException {
        this(Locale.getDefault(), string);
    }

    public PrintfFormat(Locale locale, String string) throws IllegalArgumentException {
        this.dfs = new DecimalFormatSymbols(locale);
        int n = 0;
        ConversionSpecification conversionSpecification = null;
        String string2 = this.nonControl(string, 0);
        if (string2 != null) {
            conversionSpecification = new ConversionSpecification();
            conversionSpecification.setLiteral(string2);
            this.vFmt.addElement(conversionSpecification);
        }
        while (this.cPos != -1 && this.cPos < string.length()) {
            for (n = this.cPos + 1; n < string.length(); ++n) {
                char c = '\u0000';
                c = string.charAt(n);
                if (c == 'i' || c == 'd' || c == 'f' || c == 'g' || c == 'G' || c == 'o' || c == 'x' || c == 'X' || c == 'e' || c == 'E' || c == 'c' || c == 's' || c == '%') break;
            }
            n = Math.min(n + 1, string.length());
            conversionSpecification = new ConversionSpecification(string.substring(this.cPos, n));
            this.vFmt.addElement(conversionSpecification);
            string2 = this.nonControl(string, n);
            if (string2 == null) continue;
            conversionSpecification = new ConversionSpecification();
            conversionSpecification.setLiteral(string2);
            this.vFmt.addElement(conversionSpecification);
        }
    }

    private String nonControl(String string, int n) {
        String string2 = "";
        this.cPos = string.indexOf("%", n);
        if (this.cPos == -1) {
            this.cPos = string.length();
        }
        return string.substring(n, this.cPos);
    }

    public String sprintf(Object[] objectArray) {
        Enumeration enumeration = this.vFmt.elements();
        ConversionSpecification conversionSpecification = null;
        char c = '\u0000';
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            conversionSpecification = (ConversionSpecification)enumeration.nextElement();
            c = conversionSpecification.getConversionCharacter();
            if (c == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%");
                continue;
            }
            if (conversionSpecification.isPositionalSpecification()) {
                int n2;
                n = conversionSpecification.getArgumentPosition() - 1;
                if (conversionSpecification.isPositionalFieldWidth()) {
                    n2 = conversionSpecification.getArgumentPositionForFieldWidth() - 1;
                    conversionSpecification.setFieldWidthWithArg((Integer)objectArray[n2]);
                }
                if (conversionSpecification.isPositionalPrecision()) {
                    n2 = conversionSpecification.getArgumentPositionForPrecision() - 1;
                    conversionSpecification.setPrecisionWithArg((Integer)objectArray[n2]);
                }
            } else {
                if (conversionSpecification.isVariableFieldWidth()) {
                    conversionSpecification.setFieldWidthWithArg((Integer)objectArray[n]);
                    ++n;
                }
                if (conversionSpecification.isVariablePrecision()) {
                    conversionSpecification.setPrecisionWithArg((Integer)objectArray[n]);
                    ++n;
                }
            }
            if (objectArray[n] instanceof Byte) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Byte)objectArray[n]).byteValue()));
            } else if (objectArray[n] instanceof Short) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Short)objectArray[n]).shortValue()));
            } else if (objectArray[n] instanceof Integer) {
                stringBuffer.append(conversionSpecification.internalsprintf((Integer)objectArray[n]));
            } else if (objectArray[n] instanceof Long) {
                stringBuffer.append(conversionSpecification.internalsprintf((Long)objectArray[n]));
            } else if (objectArray[n] instanceof Float) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Float)objectArray[n]).floatValue()));
            } else if (objectArray[n] instanceof Double) {
                stringBuffer.append(conversionSpecification.internalsprintf((Double)objectArray[n]));
            } else if (objectArray[n] instanceof Character) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Character)objectArray[n]).charValue()));
            } else if (objectArray[n] instanceof String) {
                stringBuffer.append(conversionSpecification.internalsprintf((String)objectArray[n]));
            } else {
                stringBuffer.append(conversionSpecification.internalsprintf(objectArray[n]));
            }
            if (conversionSpecification.isPositionalSpecification()) continue;
            ++n;
        }
        return stringBuffer.toString();
    }

    public String sprintf() {
        Enumeration enumeration = this.vFmt.elements();
        ConversionSpecification conversionSpecification = null;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            conversionSpecification = (ConversionSpecification)enumeration.nextElement();
            c = conversionSpecification.getConversionCharacter();
            if (c == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c != '%') continue;
            stringBuffer.append("%");
        }
        return stringBuffer.toString();
    }

    public String sprintf(int n) throws IllegalArgumentException {
        Enumeration enumeration = this.vFmt.elements();
        ConversionSpecification conversionSpecification = null;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            conversionSpecification = (ConversionSpecification)enumeration.nextElement();
            c = conversionSpecification.getConversionCharacter();
            if (c == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(n));
        }
        return stringBuffer.toString();
    }

    public String sprintf(long l) throws IllegalArgumentException {
        Enumeration enumeration = this.vFmt.elements();
        ConversionSpecification conversionSpecification = null;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            conversionSpecification = (ConversionSpecification)enumeration.nextElement();
            c = conversionSpecification.getConversionCharacter();
            if (c == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(l));
        }
        return stringBuffer.toString();
    }

    public String sprintf(double d) throws IllegalArgumentException {
        Enumeration enumeration = this.vFmt.elements();
        ConversionSpecification conversionSpecification = null;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            conversionSpecification = (ConversionSpecification)enumeration.nextElement();
            c = conversionSpecification.getConversionCharacter();
            if (c == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(d));
        }
        return stringBuffer.toString();
    }

    public String sprintf(String string) throws IllegalArgumentException {
        Enumeration enumeration = this.vFmt.elements();
        ConversionSpecification conversionSpecification = null;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            conversionSpecification = (ConversionSpecification)enumeration.nextElement();
            c = conversionSpecification.getConversionCharacter();
            if (c == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(string));
        }
        return stringBuffer.toString();
    }

    public String sprintf(Object object) throws IllegalArgumentException {
        Enumeration enumeration = this.vFmt.elements();
        ConversionSpecification conversionSpecification = null;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            conversionSpecification = (ConversionSpecification)enumeration.nextElement();
            c = conversionSpecification.getConversionCharacter();
            if (c == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%");
                continue;
            }
            if (object instanceof Byte) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Byte)object).byteValue()));
                continue;
            }
            if (object instanceof Short) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Short)object).shortValue()));
                continue;
            }
            if (object instanceof Integer) {
                stringBuffer.append(conversionSpecification.internalsprintf((Integer)object));
                continue;
            }
            if (object instanceof Long) {
                stringBuffer.append(conversionSpecification.internalsprintf((Long)object));
                continue;
            }
            if (object instanceof Float) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Float)object).floatValue()));
                continue;
            }
            if (object instanceof Double) {
                stringBuffer.append(conversionSpecification.internalsprintf((Double)object));
                continue;
            }
            if (object instanceof Character) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Character)object).charValue()));
                continue;
            }
            if (object instanceof String) {
                stringBuffer.append(conversionSpecification.internalsprintf((String)object));
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(object));
        }
        return stringBuffer.toString();
    }

    private class ConversionSpecification {
        private boolean thousands = false;
        private boolean leftJustify = false;
        private boolean leadingSign = false;
        private boolean leadingSpace = false;
        private boolean alternateForm = false;
        private boolean leadingZeros = false;
        private boolean variableFieldWidth = false;
        private int fieldWidth = 0;
        private boolean fieldWidthSet = false;
        private int precision = 0;
        private static final int defaultDigits = 6;
        private boolean variablePrecision = false;
        private boolean precisionSet = false;
        private boolean positionalSpecification = false;
        private int argumentPosition = 0;
        private boolean positionalFieldWidth = false;
        private int argumentPositionForFieldWidth = 0;
        private boolean positionalPrecision = false;
        private int argumentPositionForPrecision = 0;
        private boolean optionalh = false;
        private boolean optionall = false;
        private boolean optionalL = false;
        private char conversionCharacter = '\u0000';
        private int pos = 0;
        private String fmt;

        ConversionSpecification() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ConversionSpecification(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new NullPointerException();
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Control strings must have positive lengths.");
            }
            if (string.charAt(0) != '%') throw new IllegalArgumentException("Control strings must begin with %.");
            this.fmt = string;
            this.pos = 1;
            this.setArgPosition();
            this.setFlagCharacters();
            this.setFieldWidth();
            this.setPrecision();
            this.setOptionalHL();
            if (!this.setConversionCharacter()) throw new IllegalArgumentException("Malformed conversion specification=" + string);
            if (this.pos != string.length()) throw new IllegalArgumentException("Malformed conversion specification=" + string);
            if (this.leadingZeros && this.leftJustify) {
                this.leadingZeros = false;
            }
            if (!this.precisionSet || !this.leadingZeros || this.conversionCharacter != 'd' && this.conversionCharacter != 'i' && this.conversionCharacter != 'o' && this.conversionCharacter != 'x') return;
            this.leadingZeros = false;
        }

        void setLiteral(String string) {
            this.fmt = string;
        }

        String getLiteral() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.fmt.length()) {
                if (this.fmt.charAt(n) == '\\') {
                    if (++n < this.fmt.length()) {
                        char c = this.fmt.charAt(n);
                        switch (c) {
                            case 'a': {
                                stringBuffer.append('\u0007');
                                break;
                            }
                            case 'b': {
                                stringBuffer.append('\b');
                                break;
                            }
                            case 'f': {
                                stringBuffer.append('\f');
                                break;
                            }
                            case 'n': {
                                stringBuffer.append(System.getProperty("line.separator"));
                                break;
                            }
                            case 'r': {
                                stringBuffer.append('\r');
                                break;
                            }
                            case 't': {
                                stringBuffer.append('\t');
                                break;
                            }
                            case 'v': {
                                stringBuffer.append('\u000b');
                                break;
                            }
                            case '\\': {
                                stringBuffer.append('\\');
                            }
                        }
                        ++n;
                        continue;
                    }
                    stringBuffer.append('\\');
                    continue;
                }
                ++n;
            }
            return this.fmt;
        }

        char getConversionCharacter() {
            return this.conversionCharacter;
        }

        boolean isVariableFieldWidth() {
            return this.variableFieldWidth;
        }

        void setFieldWidthWithArg(int n) {
            if (n < 0) {
                this.leftJustify = true;
            }
            this.fieldWidthSet = true;
            this.fieldWidth = Math.abs(n);
        }

        boolean isVariablePrecision() {
            return this.variablePrecision;
        }

        void setPrecisionWithArg(int n) {
            this.precisionSet = true;
            this.precision = Math.max(n, 0);
        }

        String internalsprintf(int n) throws IllegalArgumentException {
            String string = "";
            switch (this.conversionCharacter) {
                case 'd': 
                case 'i': {
                    if (this.optionalh) {
                        string = this.printDFormat((short)n);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printDFormat((long)n);
                        break;
                    }
                    string = this.printDFormat(n);
                    break;
                }
                case 'X': 
                case 'x': {
                    if (this.optionalh) {
                        string = this.printXFormat((short)n);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printXFormat((long)n);
                        break;
                    }
                    string = this.printXFormat(n);
                    break;
                }
                case 'o': {
                    if (this.optionalh) {
                        string = this.printOFormat((short)n);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printOFormat((long)n);
                        break;
                    }
                    string = this.printOFormat(n);
                    break;
                }
                case 'C': 
                case 'c': {
                    string = this.printCFormat((char)n);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a int with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return string;
        }

        String internalsprintf(long l) throws IllegalArgumentException {
            String string = "";
            switch (this.conversionCharacter) {
                case 'd': 
                case 'i': {
                    if (this.optionalh) {
                        string = this.printDFormat((short)l);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printDFormat(l);
                        break;
                    }
                    string = this.printDFormat((int)l);
                    break;
                }
                case 'X': 
                case 'x': {
                    if (this.optionalh) {
                        string = this.printXFormat((short)l);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printXFormat(l);
                        break;
                    }
                    string = this.printXFormat((int)l);
                    break;
                }
                case 'o': {
                    if (this.optionalh) {
                        string = this.printOFormat((short)l);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printOFormat(l);
                        break;
                    }
                    string = this.printOFormat((int)l);
                    break;
                }
                case 'C': 
                case 'c': {
                    string = this.printCFormat((char)l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a long with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return string;
        }

        String internalsprintf(double d) throws IllegalArgumentException {
            String string = "";
            switch (this.conversionCharacter) {
                case 'f': {
                    string = this.printFFormat(d);
                    break;
                }
                case 'E': 
                case 'e': {
                    string = this.printEFormat(d);
                    break;
                }
                case 'G': 
                case 'g': {
                    string = this.printGFormat(d);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a double with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return string;
        }

        String internalsprintf(String string) throws IllegalArgumentException {
            String string2 = "";
            if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
                throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
            }
            string2 = this.printSFormat(string);
            return string2;
        }

        String internalsprintf(Object object) {
            String string = "";
            if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
                throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
            }
            string = this.printSFormat(object.toString());
            return string;
        }

        private char[] fFormatDigits(double d) {
            char[] cArray;
            int n;
            int n2;
            int n3;
            char[] cArray2;
            char[] cArray3;
            int n4;
            int n5;
            int n6;
            String string;
            int n7 = 0;
            boolean bl = false;
            if (d > 0.0) {
                string = Double.toString(d);
            } else if (d < 0.0) {
                string = Double.toString(-d);
                bl = true;
            } else {
                string = Double.toString(d);
                if (string.charAt(0) == '-') {
                    bl = true;
                    string = string.substring(1);
                }
            }
            int n8 = string.indexOf(69);
            int n9 = string.indexOf(46);
            int n10 = n9 != -1 ? n9 : (n8 != -1 ? n8 : string.length());
            int n11 = n9 != -1 ? (n8 != -1 ? n8 - n9 - 1 : string.length() - n9 - 1) : 0;
            if (n8 != -1) {
                n6 = n8 + 1;
                n7 = 0;
                if (string.charAt(n6) == '-') {
                    ++n6;
                    while (n6 < string.length() && string.charAt(n6) == '0') {
                        ++n6;
                    }
                    if (n6 < string.length()) {
                        n7 = -Integer.parseInt(string.substring(n6));
                    }
                } else {
                    if (string.charAt(n6) == '+') {
                        ++n6;
                    }
                    while (n6 < string.length() && string.charAt(n6) == '0') {
                        ++n6;
                    }
                    if (n6 < string.length()) {
                        n7 = Integer.parseInt(string.substring(n6));
                    }
                }
            }
            n6 = this.precisionSet ? this.precision : 5;
            char[] cArray4 = string.toCharArray();
            char[] cArray5 = new char[n10 + n11];
            for (n5 = 0; n5 < n10; ++n5) {
                cArray5[n5] = cArray4[n5];
            }
            int n12 = n5 + 1;
            for (n4 = 0; n4 < n11; ++n4) {
                cArray5[n5] = cArray4[n12];
                ++n5;
                ++n12;
            }
            if (n10 + n7 <= 0) {
                cArray3 = new char[-n7 + n11];
                n5 = 0;
                n4 = 0;
                while (n4 < -n10 - n7) {
                    cArray3[n5] = 48;
                    ++n4;
                    ++n5;
                }
                n12 = 0;
                while (n12 < n10 + n11) {
                    cArray3[n5] = cArray5[n12];
                    ++n12;
                    ++n5;
                }
            } else {
                cArray3 = cArray5;
            }
            boolean bl2 = false;
            if (n6 < -n7 + n11 && (bl2 = this.checkForCarry(cArray3, n12 = n7 < 0 ? n6 : n6 + n10))) {
                bl2 = this.startSymbolicCarry(cArray3, n12 - 1, 0);
            }
            if (n10 + n7 <= 0) {
                cArray2 = new char[2 + n6];
                cArray2[0] = !bl2 ? 48 : 49;
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    cArray2[1] = 46;
                    n12 = 0;
                    n5 = 2;
                    while (n12 < Math.min(n6, cArray3.length)) {
                        cArray2[n5] = cArray3[n12];
                        ++n12;
                        ++n5;
                    }
                    while (n5 < cArray2.length) {
                        cArray2[n5] = 48;
                        ++n5;
                    }
                }
            } else {
                if (!bl2) {
                    cArray2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n10 + n7 + n6 + 1] : new char[n10 + n7];
                    n5 = 0;
                } else {
                    cArray2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n10 + n7 + n6 + 2] : new char[n10 + n7 + 1];
                    cArray2[0] = 49;
                    n5 = 1;
                }
                n12 = 0;
                while (n12 < Math.min(n10 + n7, cArray3.length)) {
                    cArray2[n5] = cArray3[n12];
                    ++n12;
                    ++n5;
                }
                while (n12 < n10 + n7) {
                    cArray2[n5] = 48;
                    ++n12;
                    ++n5;
                }
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    cArray2[n5] = 46;
                    ++n5;
                    for (n4 = 0; n12 < cArray3.length && n4 < n6; ++n4) {
                        cArray2[n5] = cArray3[n12];
                        ++n12;
                        ++n5;
                    }
                    while (n5 < cArray2.length) {
                        cArray2[n5] = 48;
                        ++n5;
                    }
                }
            }
            int n13 = 0;
            if (!this.leftJustify && this.leadingZeros) {
                n3 = 0;
                if (this.thousands) {
                    n2 = 0;
                    if (cArray2[0] == '+' || cArray2[0] == '-' || cArray2[0] == ' ') {
                        n2 = 1;
                    }
                    for (n = n2; n < cArray2.length && cArray2[n] != '.'; ++n) {
                    }
                    n3 = (n - n2) / 3;
                }
                if (this.fieldWidthSet) {
                    n13 = this.fieldWidth - cArray2.length;
                }
                if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                    --n13;
                }
                if ((n13 -= n3) < 0) {
                    n13 = 0;
                }
            }
            n5 = 0;
            if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                cArray = new char[cArray2.length + n13 + 1];
                ++n5;
            } else {
                cArray = new char[cArray2.length + n13];
            }
            if (!bl) {
                if (this.leadingSign) {
                    cArray[0] = 43;
                }
                if (this.leadingSpace) {
                    cArray[0] = 32;
                }
            } else {
                cArray[0] = 45;
            }
            n12 = 0;
            while (n12 < n13) {
                cArray[n5] = 48;
                ++n12;
                ++n5;
            }
            n12 = 0;
            while (n12 < cArray2.length) {
                cArray[n5] = cArray2[n12];
                ++n12;
                ++n5;
            }
            n3 = 0;
            if (cArray[0] == '+' || cArray[0] == '-' || cArray[0] == ' ') {
                n3 = 1;
            }
            for (n2 = n3; n2 < cArray.length && cArray[n2] != '.'; ++n2) {
            }
            n = (n2 - n3) / 3;
            if (n2 < cArray.length) {
                cArray[n2] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] cArray6 = cArray;
            if (this.thousands && n > 0) {
                cArray6 = new char[cArray.length + n + n3];
                cArray6[0] = cArray[0];
                n4 = n3;
                for (n12 = n3; n12 < n2; ++n12) {
                    if (n12 > 0 && (n2 - n12) % 3 == 0) {
                        cArray6[n4] = PrintfFormat.this.dfs.getGroupingSeparator();
                        cArray6[n4 + 1] = cArray[n12];
                        n4 += 2;
                        continue;
                    }
                    cArray6[n4] = cArray[n12];
                    ++n4;
                }
                while (n12 < cArray.length) {
                    cArray6[n4] = cArray[n12];
                    ++n12;
                    ++n4;
                }
            }
            return cArray6;
        }

        private String fFormatString(double d) {
            char[] cArray;
            boolean bl = false;
            if (Double.isInfinite(d)) {
                cArray = d == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
                bl = true;
            } else if (Double.isNaN(d)) {
                cArray = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
                bl = true;
            } else {
                cArray = this.fFormatDigits(d);
            }
            char[] cArray2 = this.applyFloatPadding(cArray, false);
            return new String(cArray2);
        }

        private char[] eFormatDigits(double d, char c) {
            char[] cArray;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            char[] cArray2;
            int n7;
            int n8;
            String string;
            int n9 = 0;
            boolean bl = false;
            if (d > 0.0) {
                string = Double.toString(d);
            } else if (d < 0.0) {
                string = Double.toString(-d);
                bl = true;
            } else {
                string = Double.toString(d);
                if (string.charAt(0) == '-') {
                    bl = true;
                    string = string.substring(1);
                }
            }
            int n10 = string.indexOf(69);
            if (n10 == -1) {
                n10 = string.indexOf(101);
            }
            int n11 = (n8 = string.indexOf(46)) != -1 ? n8 : (n10 != -1 ? n10 : string.length());
            int n12 = n8 != -1 ? (n10 != -1 ? n10 - n8 - 1 : string.length() - n8 - 1) : 0;
            if (n10 != -1) {
                n7 = n10 + 1;
                n9 = 0;
                if (string.charAt(n7) == '-') {
                    ++n7;
                    while (n7 < string.length() && string.charAt(n7) == '0') {
                        ++n7;
                    }
                    if (n7 < string.length()) {
                        n9 = -Integer.parseInt(string.substring(n7));
                    }
                } else {
                    if (string.charAt(n7) == '+') {
                        ++n7;
                    }
                    while (n7 < string.length() && string.charAt(n7) == '0') {
                        ++n7;
                    }
                    if (n7 < string.length()) {
                        n9 = Integer.parseInt(string.substring(n7));
                    }
                }
            }
            if (n8 != -1) {
                n9 += n8 - 1;
            }
            int n13 = this.precisionSet ? this.precision : 5;
            char[] cArray3 = n8 != -1 && n10 != -1 ? (string.substring(0, n8) + string.substring(n8 + 1, n10)).toCharArray() : (n8 != -1 ? (string.substring(0, n8) + string.substring(n8 + 1)).toCharArray() : (n10 != -1 ? string.substring(0, n10).toCharArray() : string.toCharArray()));
            n7 = 0;
            int n14 = 0;
            if (cArray3[0] != '0') {
                n14 = 0;
            } else {
                for (n14 = 0; n14 < cArray3.length && cArray3[n14] == '0'; ++n14) {
                }
            }
            if (n14 + n13 < cArray3.length - 1) {
                n7 = this.checkForCarry(cArray3, n14 + n13 + 1) ? 1 : 0;
                if (n7 != 0) {
                    n7 = this.startSymbolicCarry(cArray3, n14 + n13, n14) ? 1 : 0;
                }
                if (n7 != 0) {
                    cArray2 = new char[n14 + n13 + 1];
                    cArray2[n14] = 49;
                    for (n6 = 0; n6 < n14; ++n6) {
                        cArray2[n6] = 48;
                    }
                    n5 = n14;
                    for (n6 = n14 + 1; n6 < n13 + 1; ++n6) {
                        cArray2[n6] = cArray3[n5];
                        ++n5;
                    }
                    ++n9;
                    cArray3 = cArray2;
                }
            }
            int n15 = Math.abs(n9) < 100 && !this.optionalL ? 4 : 5;
            cArray2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[2 + n13 + n15] : new char[1 + n15];
            if (cArray3[0] != '0') {
                cArray2[0] = cArray3[0];
                n6 = 1;
            } else {
                for (n6 = 1; n6 < (n10 == -1 ? cArray3.length : n10) && cArray3[n6] == '0'; ++n6) {
                }
                if (n10 != -1 && n6 < n10 || n10 == -1 && n6 < cArray3.length) {
                    cArray2[0] = cArray3[n6];
                    n9 -= n6;
                    ++n6;
                } else {
                    cArray2[0] = 48;
                    n6 = 2;
                }
            }
            if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                cArray2[1] = 46;
                n5 = 2;
            } else {
                n5 = 1;
            }
            for (n4 = 0; n4 < n13 && n6 < cArray3.length; ++n4) {
                cArray2[n5] = cArray3[n6];
                ++n6;
                ++n5;
            }
            while (n5 < cArray2.length - n15) {
                cArray2[n5] = 48;
                ++n5;
            }
            cArray2[n5++] = c;
            cArray2[n5++] = n9 < 0 ? 45 : 43;
            if ((n9 = Math.abs(n9)) >= 100) {
                switch (n9 / 100) {
                    case 1: {
                        cArray2[n5] = 49;
                        break;
                    }
                    case 2: {
                        cArray2[n5] = 50;
                        break;
                    }
                    case 3: {
                        cArray2[n5] = 51;
                        break;
                    }
                    case 4: {
                        cArray2[n5] = 52;
                        break;
                    }
                    case 5: {
                        cArray2[n5] = 53;
                        break;
                    }
                    case 6: {
                        cArray2[n5] = 54;
                        break;
                    }
                    case 7: {
                        cArray2[n5] = 55;
                        break;
                    }
                    case 8: {
                        cArray2[n5] = 56;
                        break;
                    }
                    case 9: {
                        cArray2[n5] = 57;
                    }
                }
                ++n5;
            }
            switch (n9 % 100 / 10) {
                case 0: {
                    cArray2[n5] = 48;
                    break;
                }
                case 1: {
                    cArray2[n5] = 49;
                    break;
                }
                case 2: {
                    cArray2[n5] = 50;
                    break;
                }
                case 3: {
                    cArray2[n5] = 51;
                    break;
                }
                case 4: {
                    cArray2[n5] = 52;
                    break;
                }
                case 5: {
                    cArray2[n5] = 53;
                    break;
                }
                case 6: {
                    cArray2[n5] = 54;
                    break;
                }
                case 7: {
                    cArray2[n5] = 55;
                    break;
                }
                case 8: {
                    cArray2[n5] = 56;
                    break;
                }
                case 9: {
                    cArray2[n5] = 57;
                }
            }
            ++n5;
            switch (n9 % 10) {
                case 0: {
                    cArray2[n5] = 48;
                    break;
                }
                case 1: {
                    cArray2[n5] = 49;
                    break;
                }
                case 2: {
                    cArray2[n5] = 50;
                    break;
                }
                case 3: {
                    cArray2[n5] = 51;
                    break;
                }
                case 4: {
                    cArray2[n5] = 52;
                    break;
                }
                case 5: {
                    cArray2[n5] = 53;
                    break;
                }
                case 6: {
                    cArray2[n5] = 54;
                    break;
                }
                case 7: {
                    cArray2[n5] = 55;
                    break;
                }
                case 8: {
                    cArray2[n5] = 56;
                    break;
                }
                case 9: {
                    cArray2[n5] = 57;
                }
            }
            int n16 = 0;
            if (!this.leftJustify && this.leadingZeros) {
                n3 = 0;
                if (this.thousands) {
                    n2 = 0;
                    if (cArray2[0] == '+' || cArray2[0] == '-' || cArray2[0] == ' ') {
                        n2 = 1;
                    }
                    for (n = n2; n < cArray2.length && cArray2[n] != '.'; ++n) {
                    }
                    n3 = (n - n2) / 3;
                }
                if (this.fieldWidthSet) {
                    n16 = this.fieldWidth - cArray2.length;
                }
                if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                    --n16;
                }
                if ((n16 -= n3) < 0) {
                    n16 = 0;
                }
            }
            n6 = 0;
            if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                cArray = new char[cArray2.length + n16 + 1];
                ++n6;
            } else {
                cArray = new char[cArray2.length + n16];
            }
            if (!bl) {
                if (this.leadingSign) {
                    cArray[0] = 43;
                }
                if (this.leadingSpace) {
                    cArray[0] = 32;
                }
            } else {
                cArray[0] = 45;
            }
            for (n4 = 0; n4 < n16; ++n4) {
                cArray[n6] = 48;
                ++n6;
            }
            for (n5 = 0; n5 < cArray2.length && n6 < cArray.length; ++n5, ++n6) {
                cArray[n6] = cArray2[n5];
            }
            n3 = 0;
            if (cArray[0] == '+' || cArray[0] == '-' || cArray[0] == ' ') {
                n3 = 1;
            }
            for (n2 = n3; n2 < cArray.length && cArray[n2] != '.'; ++n2) {
            }
            n = n2 / 3;
            if (n2 < cArray.length) {
                cArray[n2] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] cArray4 = cArray;
            if (this.thousands && n > 0) {
                cArray4 = new char[cArray.length + n + n3];
                cArray4[0] = cArray[0];
                n4 = n3;
                for (n5 = n3; n5 < n2; ++n5) {
                    if (n5 > 0 && (n2 - n5) % 3 == 0) {
                        cArray4[n4] = PrintfFormat.this.dfs.getGroupingSeparator();
                        cArray4[n4 + 1] = cArray[n5];
                        n4 += 2;
                        continue;
                    }
                    cArray4[n4] = cArray[n5];
                    ++n4;
                }
                while (n5 < cArray.length) {
                    cArray4[n4] = cArray[n5];
                    ++n5;
                    ++n4;
                }
            }
            return cArray4;
        }

        private boolean checkForCarry(char[] cArray, int n) {
            boolean bl = false;
            if (n < cArray.length) {
                if (cArray[n] == '6' || cArray[n] == '7' || cArray[n] == '8' || cArray[n] == '9') {
                    bl = true;
                } else if (cArray[n] == '5') {
                    int n2;
                    for (n2 = n + 1; n2 < cArray.length && cArray[n2] == '0'; ++n2) {
                    }
                    boolean bl2 = bl = n2 < cArray.length;
                    if (!bl && n > 0) {
                        bl = cArray[n - 1] == '1' || cArray[n - 1] == '3' || cArray[n - 1] == '5' || cArray[n - 1] == '7' || cArray[n - 1] == '9';
                    }
                }
            }
            return bl;
        }

        private boolean startSymbolicCarry(char[] cArray, int n, int n2) {
            boolean bl = true;
            block12: for (int i = n; bl && i >= n2; --i) {
                bl = false;
                switch (cArray[i]) {
                    case '0': {
                        cArray[i] = 49;
                        continue block12;
                    }
                    case '1': {
                        cArray[i] = 50;
                        continue block12;
                    }
                    case '2': {
                        cArray[i] = 51;
                        continue block12;
                    }
                    case '3': {
                        cArray[i] = 52;
                        continue block12;
                    }
                    case '4': {
                        cArray[i] = 53;
                        continue block12;
                    }
                    case '5': {
                        cArray[i] = 54;
                        continue block12;
                    }
                    case '6': {
                        cArray[i] = 55;
                        continue block12;
                    }
                    case '7': {
                        cArray[i] = 56;
                        continue block12;
                    }
                    case '8': {
                        cArray[i] = 57;
                        continue block12;
                    }
                    case '9': {
                        cArray[i] = 48;
                        bl = true;
                    }
                }
            }
            return bl;
        }

        private String eFormatString(double d, char c) {
            char[] cArray;
            boolean bl = false;
            if (Double.isInfinite(d)) {
                cArray = d == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
                bl = true;
            } else if (Double.isNaN(d)) {
                cArray = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
                bl = true;
            } else {
                cArray = this.eFormatDigits(d, c);
            }
            char[] cArray2 = this.applyFloatPadding(cArray, false);
            return new String(cArray2);
        }

        private char[] applyFloatPadding(char[] cArray, boolean bl) {
            char[] cArray2;
            block8: {
                int n;
                block10: {
                    int n2;
                    block9: {
                        int n3;
                        cArray2 = cArray;
                        if (!this.fieldWidthSet) break block8;
                        if (!this.leftJustify) break block9;
                        int n4 = this.fieldWidth - cArray.length;
                        if (n4 <= 0) break block8;
                        cArray2 = new char[cArray.length + n4];
                        for (n3 = 0; n3 < cArray.length; ++n3) {
                            cArray2[n3] = cArray[n3];
                        }
                        int n5 = 0;
                        while (n5 < n4) {
                            cArray2[n3] = 32;
                            ++n5;
                            ++n3;
                        }
                        break block8;
                    }
                    if (this.leadingZeros && !bl) break block10;
                    int n6 = this.fieldWidth - cArray.length;
                    if (n6 <= 0) break block8;
                    cArray2 = new char[cArray.length + n6];
                    for (n2 = 0; n2 < n6; ++n2) {
                        cArray2[n2] = 32;
                    }
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray2[n2] = cArray[i];
                        ++n2;
                    }
                    break block8;
                }
                if (this.leadingZeros && (n = this.fieldWidth - cArray.length) > 0) {
                    cArray2 = new char[cArray.length + n];
                    int n7 = 0;
                    int n8 = 0;
                    if (cArray[0] == '-') {
                        cArray2[0] = 45;
                        ++n7;
                        ++n8;
                    }
                    for (int i = 0; i < n; ++i) {
                        cArray2[n7] = 48;
                        ++n7;
                    }
                    while (n8 < cArray.length) {
                        cArray2[n7] = cArray[n8];
                        ++n7;
                        ++n8;
                    }
                }
            }
            return cArray2;
        }

        private String printFFormat(double d) {
            return this.fFormatString(d);
        }

        private String printEFormat(double d) {
            if (this.conversionCharacter == 'e') {
                return this.eFormatString(d, 'e');
            }
            return this.eFormatString(d, 'E');
        }

        private String printGFormat(double d) {
            char[] cArray;
            int n = this.precision;
            boolean bl = false;
            if (Double.isInfinite(d)) {
                cArray = d == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
                bl = true;
            } else if (Double.isNaN(d)) {
                cArray = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
                bl = true;
            } else {
                String string;
                String string2;
                if (!this.precisionSet) {
                    this.precision = 6;
                }
                if (this.precision == 0) {
                    this.precision = 1;
                }
                int n2 = -1;
                if (this.conversionCharacter == 'g') {
                    string2 = this.eFormatString(d, 'e').trim();
                    n2 = string2.indexOf(101);
                } else {
                    string2 = this.eFormatString(d, 'E').trim();
                    n2 = string2.indexOf(69);
                }
                int n3 = n2 + 1;
                int n4 = 0;
                if (string2.charAt(n3) == '-') {
                    ++n3;
                    while (n3 < string2.length() && string2.charAt(n3) == '0') {
                        ++n3;
                    }
                    if (n3 < string2.length()) {
                        n4 = -Integer.parseInt(string2.substring(n3));
                    }
                } else {
                    if (string2.charAt(n3) == '+') {
                        ++n3;
                    }
                    while (n3 < string2.length() && string2.charAt(n3) == '0') {
                        ++n3;
                    }
                    if (n3 < string2.length()) {
                        n4 = Integer.parseInt(string2.substring(n3));
                    }
                }
                if (!this.alternateForm) {
                    String string3 = n4 >= -4 && n4 < this.precision ? this.fFormatString(d).trim() : string2.substring(0, n2);
                    for (n3 = string3.length() - 1; n3 >= 0 && string3.charAt(n3) == '0'; --n3) {
                    }
                    if (n3 >= 0 && string3.charAt(n3) == '.') {
                        --n3;
                    }
                    String string4 = n3 == -1 ? "0" : (!Character.isDigit(string3.charAt(n3)) ? string3.substring(0, n3 + 1) + "0" : string3.substring(0, n3 + 1));
                    string = n4 >= -4 && n4 < this.precision ? string4 : string4 + string2.substring(n2);
                } else {
                    string = n4 >= -4 && n4 < this.precision ? this.fFormatString(d).trim() : string2;
                }
                if (this.leadingSpace && d >= 0.0) {
                    string = " " + string;
                }
                cArray = string.toCharArray();
            }
            char[] cArray2 = this.applyFloatPadding(cArray, false);
            this.precision = n;
            return new String(cArray2);
        }

        private String printDFormat(short s) {
            return this.printDFormat(Short.toString(s));
        }

        private String printDFormat(long l) {
            return this.printDFormat(Long.toString(l));
        }

        private String printDFormat(int n) {
            return this.printDFormat(Integer.toString(n));
        }

        private String printDFormat(String string) {
            char[] cArray;
            block30: {
                int n;
                boolean bl;
                int n2;
                int n3;
                int n4;
                block33: {
                    int n5;
                    block31: {
                        block34: {
                            block32: {
                                block29: {
                                    int n6;
                                    n4 = 0;
                                    n5 = 0;
                                    int n7 = 0;
                                    n3 = 0;
                                    n2 = 0;
                                    boolean bl2 = bl = string.charAt(0) == '-';
                                    if (string.equals("0") && this.precisionSet && this.precision == 0) {
                                        string = "";
                                    }
                                    if (!bl) {
                                        if (this.precisionSet && string.length() < this.precision) {
                                            n4 = this.precision - string.length();
                                        }
                                    } else if (this.precisionSet && string.length() - 1 < this.precision) {
                                        n4 = this.precision - string.length() + 1;
                                    }
                                    if (n4 < 0) {
                                        n4 = 0;
                                    }
                                    if (this.fieldWidthSet) {
                                        n5 = this.fieldWidth - n4 - string.length();
                                        if (!bl && (this.leadingSign || this.leadingSpace)) {
                                            --n5;
                                        }
                                    }
                                    if (n5 < 0) {
                                        n5 = 0;
                                    }
                                    if (this.leadingSign) {
                                        ++n7;
                                    } else if (this.leadingSpace) {
                                        ++n7;
                                    }
                                    n7 += n5;
                                    n7 += n4;
                                    cArray = new char[n7 += string.length()];
                                    if (!this.leftJustify) break block29;
                                    if (bl) {
                                        cArray[n3++] = 45;
                                    } else if (this.leadingSign) {
                                        cArray[n3++] = 43;
                                    } else if (this.leadingSpace) {
                                        cArray[n3++] = 32;
                                    }
                                    char[] cArray2 = string.toCharArray();
                                    n2 = bl ? 1 : 0;
                                    for (n6 = 0; n6 < n4; ++n6) {
                                        cArray[n3] = 48;
                                        ++n3;
                                    }
                                    n6 = n2;
                                    while (n6 < cArray2.length) {
                                        cArray[n3] = cArray2[n6];
                                        ++n6;
                                        ++n3;
                                    }
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        cArray[n3] = 32;
                                        ++n3;
                                    }
                                    break block30;
                                }
                                if (this.leadingZeros) break block31;
                                for (n3 = 0; n3 < n5; ++n3) {
                                    cArray[n3] = 32;
                                }
                                if (!bl) break block32;
                                cArray[n3++] = 45;
                                break block33;
                            }
                            if (!this.leadingSign) break block34;
                            cArray[n3++] = 43;
                            break block33;
                        }
                        if (!this.leadingSpace) break block33;
                        cArray[n3++] = 32;
                        break block33;
                    }
                    if (bl) {
                        cArray[n3++] = 45;
                    } else if (this.leadingSign) {
                        cArray[n3++] = 43;
                    } else if (this.leadingSpace) {
                        cArray[n3++] = 32;
                    }
                    n = 0;
                    while (n < n5) {
                        cArray[n3] = 48;
                        ++n;
                        ++n3;
                    }
                }
                n = 0;
                while (n < n4) {
                    cArray[n3] = 48;
                    ++n;
                    ++n3;
                }
                char[] cArray3 = string.toCharArray();
                int n8 = n2 = bl ? 1 : 0;
                while (n8 < cArray3.length) {
                    cArray[n3] = cArray3[n8];
                    ++n8;
                    ++n3;
                }
            }
            return new String(cArray);
        }

        private String printXFormat(short s) {
            String string = null;
            if (s == Short.MIN_VALUE) {
                string = "8000";
            } else if (s < 0) {
                String string2;
                if (s == Short.MIN_VALUE) {
                    string2 = "0";
                } else {
                    string2 = Integer.toString(~(-s - 1) ^ Short.MIN_VALUE, 16);
                    if (string2.charAt(0) == 'F' || string2.charAt(0) == 'f') {
                        string2 = string2.substring(16, 32);
                    }
                }
                block0 : switch (string2.length()) {
                    case 1: {
                        string = "800" + string2;
                        break;
                    }
                    case 2: {
                        string = "80" + string2;
                        break;
                    }
                    case 3: {
                        string = "8" + string2;
                        break;
                    }
                    case 4: {
                        switch (string2.charAt(0)) {
                            case '1': {
                                string = "9" + string2.substring(1, 4);
                                break block0;
                            }
                            case '2': {
                                string = "a" + string2.substring(1, 4);
                                break block0;
                            }
                            case '3': {
                                string = "b" + string2.substring(1, 4);
                                break block0;
                            }
                            case '4': {
                                string = "c" + string2.substring(1, 4);
                                break block0;
                            }
                            case '5': {
                                string = "d" + string2.substring(1, 4);
                                break block0;
                            }
                            case '6': {
                                string = "e" + string2.substring(1, 4);
                                break block0;
                            }
                            case '7': {
                                string = "f" + string2.substring(1, 4);
                            }
                        }
                    }
                }
            } else {
                string = Integer.toString(s, 16);
            }
            return this.printXFormat(string);
        }

        private String printXFormat(long l) {
            String string = null;
            if (l == Long.MIN_VALUE) {
                string = "8000000000000000";
            } else if (l < 0L) {
                String string2 = Long.toString(-l - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 16);
                block0 : switch (string2.length()) {
                    case 1: {
                        string = "800000000000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "80000000000000" + string2;
                        break;
                    }
                    case 3: {
                        string = "8000000000000" + string2;
                        break;
                    }
                    case 4: {
                        string = "800000000000" + string2;
                        break;
                    }
                    case 5: {
                        string = "80000000000" + string2;
                        break;
                    }
                    case 6: {
                        string = "8000000000" + string2;
                        break;
                    }
                    case 7: {
                        string = "800000000" + string2;
                        break;
                    }
                    case 8: {
                        string = "80000000" + string2;
                        break;
                    }
                    case 9: {
                        string = "8000000" + string2;
                        break;
                    }
                    case 10: {
                        string = "800000" + string2;
                        break;
                    }
                    case 11: {
                        string = "80000" + string2;
                        break;
                    }
                    case 12: {
                        string = "8000" + string2;
                        break;
                    }
                    case 13: {
                        string = "800" + string2;
                        break;
                    }
                    case 14: {
                        string = "80" + string2;
                        break;
                    }
                    case 15: {
                        string = "8" + string2;
                        break;
                    }
                    case 16: {
                        switch (string2.charAt(0)) {
                            case '1': {
                                string = "9" + string2.substring(1, 16);
                                break block0;
                            }
                            case '2': {
                                string = "a" + string2.substring(1, 16);
                                break block0;
                            }
                            case '3': {
                                string = "b" + string2.substring(1, 16);
                                break block0;
                            }
                            case '4': {
                                string = "c" + string2.substring(1, 16);
                                break block0;
                            }
                            case '5': {
                                string = "d" + string2.substring(1, 16);
                                break block0;
                            }
                            case '6': {
                                string = "e" + string2.substring(1, 16);
                                break block0;
                            }
                            case '7': {
                                string = "f" + string2.substring(1, 16);
                            }
                        }
                    }
                }
            } else {
                string = Long.toString(l, 16);
            }
            return this.printXFormat(string);
        }

        private String printXFormat(int n) {
            String string = null;
            if (n == Integer.MIN_VALUE) {
                string = "80000000";
            } else if (n < 0) {
                String string2 = Integer.toString(~(-n - 1) ^ Integer.MIN_VALUE, 16);
                block0 : switch (string2.length()) {
                    case 1: {
                        string = "8000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "800000" + string2;
                        break;
                    }
                    case 3: {
                        string = "80000" + string2;
                        break;
                    }
                    case 4: {
                        string = "8000" + string2;
                        break;
                    }
                    case 5: {
                        string = "800" + string2;
                        break;
                    }
                    case 6: {
                        string = "80" + string2;
                        break;
                    }
                    case 7: {
                        string = "8" + string2;
                        break;
                    }
                    case 8: {
                        switch (string2.charAt(0)) {
                            case '1': {
                                string = "9" + string2.substring(1, 8);
                                break block0;
                            }
                            case '2': {
                                string = "a" + string2.substring(1, 8);
                                break block0;
                            }
                            case '3': {
                                string = "b" + string2.substring(1, 8);
                                break block0;
                            }
                            case '4': {
                                string = "c" + string2.substring(1, 8);
                                break block0;
                            }
                            case '5': {
                                string = "d" + string2.substring(1, 8);
                                break block0;
                            }
                            case '6': {
                                string = "e" + string2.substring(1, 8);
                                break block0;
                            }
                            case '7': {
                                string = "f" + string2.substring(1, 8);
                            }
                        }
                    }
                }
            } else {
                string = Integer.toString(n, 16);
            }
            return this.printXFormat(string);
        }

        private String printXFormat(String string) {
            Object object;
            int n = 0;
            int n2 = 0;
            if (string.equals("0") && this.precisionSet && this.precision == 0) {
                string = "";
            }
            if (this.precisionSet) {
                n = this.precision - string.length();
            }
            if (n < 0) {
                n = 0;
            }
            if (this.fieldWidthSet) {
                n2 = this.fieldWidth - n - string.length();
                if (this.alternateForm) {
                    n2 -= 2;
                }
            }
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = 0;
            if (this.alternateForm) {
                n3 += 2;
            }
            n3 += n;
            n3 += string.length();
            char[] cArray = new char[n3 += n2];
            int n4 = 0;
            if (this.leftJustify) {
                if (this.alternateForm) {
                    cArray[n4++] = 48;
                    cArray[n4++] = 120;
                }
                int n5 = 0;
                while (n5 < n) {
                    cArray[n4] = 48;
                    ++n5;
                    ++n4;
                }
                object = string.toCharArray();
                int n6 = 0;
                while (n6 < ((char[])object).length) {
                    cArray[n4] = object[n6];
                    ++n6;
                    ++n4;
                }
                n6 = 0;
                while (n6 < n2) {
                    cArray[n4] = 32;
                    ++n6;
                    ++n4;
                }
            } else {
                int n7;
                if (!this.leadingZeros) {
                    n7 = 0;
                    while (n7 < n2) {
                        cArray[n4] = 32;
                        ++n7;
                        ++n4;
                    }
                }
                if (this.alternateForm) {
                    cArray[n4++] = 48;
                    cArray[n4++] = 120;
                }
                if (this.leadingZeros) {
                    n7 = 0;
                    while (n7 < n2) {
                        cArray[n4] = 48;
                        ++n7;
                        ++n4;
                    }
                }
                n7 = 0;
                while (n7 < n) {
                    cArray[n4] = 48;
                    ++n7;
                    ++n4;
                }
                object = string.toCharArray();
                int n8 = 0;
                while (n8 < ((char[])object).length) {
                    cArray[n4] = object[n8];
                    ++n8;
                    ++n4;
                }
            }
            object = new String(cArray);
            if (this.conversionCharacter == 'X') {
                object = ((String)object).toUpperCase();
            }
            return object;
        }

        private String printOFormat(short s) {
            String string = null;
            if (s == Short.MIN_VALUE) {
                string = "100000";
            } else if (s < 0) {
                String string2 = Integer.toString(~(-s - 1) ^ Short.MIN_VALUE, 8);
                switch (string2.length()) {
                    case 1: {
                        string = "10000" + string2;
                        break;
                    }
                    case 2: {
                        string = "1000" + string2;
                        break;
                    }
                    case 3: {
                        string = "100" + string2;
                        break;
                    }
                    case 4: {
                        string = "10" + string2;
                        break;
                    }
                    case 5: {
                        string = "1" + string2;
                    }
                }
            } else {
                string = Integer.toString(s, 8);
            }
            return this.printOFormat(string);
        }

        private String printOFormat(long l) {
            String string = null;
            if (l == Long.MIN_VALUE) {
                string = "1000000000000000000000";
            } else if (l < 0L) {
                String string2 = Long.toString(-l - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 8);
                switch (string2.length()) {
                    case 1: {
                        string = "100000000000000000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "10000000000000000000" + string2;
                        break;
                    }
                    case 3: {
                        string = "1000000000000000000" + string2;
                        break;
                    }
                    case 4: {
                        string = "100000000000000000" + string2;
                        break;
                    }
                    case 5: {
                        string = "10000000000000000" + string2;
                        break;
                    }
                    case 6: {
                        string = "1000000000000000" + string2;
                        break;
                    }
                    case 7: {
                        string = "100000000000000" + string2;
                        break;
                    }
                    case 8: {
                        string = "10000000000000" + string2;
                        break;
                    }
                    case 9: {
                        string = "1000000000000" + string2;
                        break;
                    }
                    case 10: {
                        string = "100000000000" + string2;
                        break;
                    }
                    case 11: {
                        string = "10000000000" + string2;
                        break;
                    }
                    case 12: {
                        string = "1000000000" + string2;
                        break;
                    }
                    case 13: {
                        string = "100000000" + string2;
                        break;
                    }
                    case 14: {
                        string = "10000000" + string2;
                        break;
                    }
                    case 15: {
                        string = "1000000" + string2;
                        break;
                    }
                    case 16: {
                        string = "100000" + string2;
                        break;
                    }
                    case 17: {
                        string = "10000" + string2;
                        break;
                    }
                    case 18: {
                        string = "1000" + string2;
                        break;
                    }
                    case 19: {
                        string = "100" + string2;
                        break;
                    }
                    case 20: {
                        string = "10" + string2;
                        break;
                    }
                    case 21: {
                        string = "1" + string2;
                    }
                }
            } else {
                string = Long.toString(l, 8);
            }
            return this.printOFormat(string);
        }

        private String printOFormat(int n) {
            String string = null;
            if (n == Integer.MIN_VALUE) {
                string = "20000000000";
            } else if (n < 0) {
                String string2 = Integer.toString(~(-n - 1) ^ Integer.MIN_VALUE, 8);
                switch (string2.length()) {
                    case 1: {
                        string = "2000000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "200000000" + string2;
                        break;
                    }
                    case 3: {
                        string = "20000000" + string2;
                        break;
                    }
                    case 4: {
                        string = "2000000" + string2;
                        break;
                    }
                    case 5: {
                        string = "200000" + string2;
                        break;
                    }
                    case 6: {
                        string = "20000" + string2;
                        break;
                    }
                    case 7: {
                        string = "2000" + string2;
                        break;
                    }
                    case 8: {
                        string = "200" + string2;
                        break;
                    }
                    case 9: {
                        string = "20" + string2;
                        break;
                    }
                    case 10: {
                        string = "2" + string2;
                        break;
                    }
                    case 11: {
                        string = "3" + string2.substring(1);
                    }
                }
            } else {
                string = Integer.toString(n, 8);
            }
            return this.printOFormat(string);
        }

        private String printOFormat(String string) {
            int n = 0;
            int n2 = 0;
            if (string.equals("0") && this.precisionSet && this.precision == 0) {
                string = "";
            }
            if (this.precisionSet) {
                n = this.precision - string.length();
            }
            if (this.alternateForm) {
                ++n;
            }
            if (n < 0) {
                n = 0;
            }
            if (this.fieldWidthSet) {
                n2 = this.fieldWidth - n - string.length();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = n + string.length() + n2;
            char[] cArray = new char[n3];
            if (this.leftJustify) {
                int n4;
                for (n4 = 0; n4 < n; ++n4) {
                    cArray[n4] = 48;
                }
                char[] cArray2 = string.toCharArray();
                int n5 = 0;
                while (n5 < cArray2.length) {
                    cArray[n4] = cArray2[n5];
                    ++n5;
                    ++n4;
                }
                n5 = 0;
                while (n5 < n2) {
                    cArray[n4] = 32;
                    ++n5;
                    ++n4;
                }
            } else {
                int n6;
                if (this.leadingZeros) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        cArray[n6] = 48;
                    }
                } else {
                    for (n6 = 0; n6 < n2; ++n6) {
                        cArray[n6] = 32;
                    }
                }
                int n7 = 0;
                while (n7 < n) {
                    cArray[n6] = 48;
                    ++n7;
                    ++n6;
                }
                char[] cArray3 = string.toCharArray();
                int n8 = 0;
                while (n8 < cArray3.length) {
                    cArray[n6] = cArray3[n8];
                    ++n8;
                    ++n6;
                }
            }
            return new String(cArray);
        }

        private String printCFormat(char c) {
            int n = 1;
            int n2 = this.fieldWidth;
            if (!this.fieldWidthSet) {
                n2 = n;
            }
            char[] cArray = new char[n2];
            int n3 = 0;
            if (this.leftJustify) {
                cArray[0] = c;
                for (n3 = 1; n3 <= n2 - n; ++n3) {
                    cArray[n3] = 32;
                }
            } else {
                for (n3 = 0; n3 < n2 - n; ++n3) {
                    cArray[n3] = 32;
                }
                cArray[n3] = c;
            }
            return new String(cArray);
        }

        private String printSFormat(String string) {
            int n = string.length();
            int n2 = this.fieldWidth;
            if (this.precisionSet && n > this.precision) {
                n = this.precision;
            }
            if (!this.fieldWidthSet) {
                n2 = n;
            }
            int n3 = 0;
            if (n2 > n) {
                n3 += n2 - n;
            }
            n3 = n >= string.length() ? (n3 += string.length()) : (n3 += n);
            char[] cArray = new char[n3];
            int n4 = 0;
            if (this.leftJustify) {
                char[] cArray2;
                if (n >= string.length()) {
                    cArray2 = string.toCharArray();
                    for (n4 = 0; n4 < string.length(); ++n4) {
                        cArray[n4] = cArray2[n4];
                    }
                } else {
                    cArray2 = string.substring(0, n).toCharArray();
                    for (n4 = 0; n4 < n; ++n4) {
                        cArray[n4] = cArray2[n4];
                    }
                }
                int n5 = 0;
                while (n5 < n2 - n) {
                    cArray[n4] = 32;
                    ++n5;
                    ++n4;
                }
            } else {
                for (n4 = 0; n4 < n2 - n; ++n4) {
                    cArray[n4] = 32;
                }
                if (n >= string.length()) {
                    char[] cArray3 = string.toCharArray();
                    for (int i = 0; i < string.length(); ++i) {
                        cArray[n4] = cArray3[i];
                        ++n4;
                    }
                } else {
                    char[] cArray4 = string.substring(0, n).toCharArray();
                    for (int i = 0; i < n; ++i) {
                        cArray[n4] = cArray4[i];
                        ++n4;
                    }
                }
            }
            return new String(cArray);
        }

        private boolean setConversionCharacter() {
            char c;
            boolean bl = false;
            this.conversionCharacter = '\u0000';
            if (this.pos < this.fmt.length() && ((c = this.fmt.charAt(this.pos)) == 'i' || c == 'd' || c == 'f' || c == 'g' || c == 'G' || c == 'o' || c == 'x' || c == 'X' || c == 'e' || c == 'E' || c == 'c' || c == 's' || c == '%')) {
                this.conversionCharacter = c;
                ++this.pos;
                bl = true;
            }
            return bl;
        }

        private void setOptionalHL() {
            this.optionalh = false;
            this.optionall = false;
            this.optionalL = false;
            if (this.pos < this.fmt.length()) {
                char c = this.fmt.charAt(this.pos);
                if (c == 'h') {
                    this.optionalh = true;
                    ++this.pos;
                } else if (c == 'l') {
                    this.optionall = true;
                    ++this.pos;
                } else if (c == 'L') {
                    this.optionalL = true;
                    ++this.pos;
                }
            }
        }

        private void setPrecision() {
            int n = this.pos;
            this.precisionSet = false;
            if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '.') {
                char c;
                ++this.pos;
                if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '*') {
                    ++this.pos;
                    if (!this.setPrecisionArgPosition()) {
                        this.variablePrecision = true;
                        this.precisionSet = true;
                    }
                    return;
                }
                while (this.pos < this.fmt.length() && Character.isDigit(c = this.fmt.charAt(this.pos))) {
                    ++this.pos;
                }
                if (this.pos > n + 1) {
                    String string = this.fmt.substring(n + 1, this.pos);
                    this.precision = Integer.parseInt(string);
                    this.precisionSet = true;
                }
            }
        }

        private void setFieldWidth() {
            int n = this.pos;
            this.fieldWidth = 0;
            this.fieldWidthSet = false;
            if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '*') {
                ++this.pos;
                if (!this.setFieldWidthArgPosition()) {
                    this.variableFieldWidth = true;
                    this.fieldWidthSet = true;
                }
            } else {
                char c;
                while (this.pos < this.fmt.length() && Character.isDigit(c = this.fmt.charAt(this.pos))) {
                    ++this.pos;
                }
                if (n < this.pos && n < this.fmt.length()) {
                    String string = this.fmt.substring(n, this.pos);
                    this.fieldWidth = Integer.parseInt(string);
                    this.fieldWidthSet = true;
                }
            }
        }

        private void setArgPosition() {
            int n;
            for (n = this.pos; n < this.fmt.length() && Character.isDigit(this.fmt.charAt(n)); ++n) {
            }
            if (n > this.pos && n < this.fmt.length() && this.fmt.charAt(n) == '$') {
                this.positionalSpecification = true;
                this.argumentPosition = Integer.parseInt(this.fmt.substring(this.pos, n));
                this.pos = n + 1;
            }
        }

        private boolean setFieldWidthArgPosition() {
            int n;
            boolean bl = false;
            for (n = this.pos; n < this.fmt.length() && Character.isDigit(this.fmt.charAt(n)); ++n) {
            }
            if (n > this.pos && n < this.fmt.length() && this.fmt.charAt(n) == '$') {
                this.positionalFieldWidth = true;
                this.argumentPositionForFieldWidth = Integer.parseInt(this.fmt.substring(this.pos, n));
                this.pos = n + 1;
                bl = true;
            }
            return bl;
        }

        private boolean setPrecisionArgPosition() {
            int n;
            boolean bl = false;
            for (n = this.pos; n < this.fmt.length() && Character.isDigit(this.fmt.charAt(n)); ++n) {
            }
            if (n > this.pos && n < this.fmt.length() && this.fmt.charAt(n) == '$') {
                this.positionalPrecision = true;
                this.argumentPositionForPrecision = Integer.parseInt(this.fmt.substring(this.pos, n));
                this.pos = n + 1;
                bl = true;
            }
            return bl;
        }

        boolean isPositionalSpecification() {
            return this.positionalSpecification;
        }

        int getArgumentPosition() {
            return this.argumentPosition;
        }

        boolean isPositionalFieldWidth() {
            return this.positionalFieldWidth;
        }

        int getArgumentPositionForFieldWidth() {
            return this.argumentPositionForFieldWidth;
        }

        boolean isPositionalPrecision() {
            return this.positionalPrecision;
        }

        int getArgumentPositionForPrecision() {
            return this.argumentPositionForPrecision;
        }

        private void setFlagCharacters() {
            this.thousands = false;
            this.leftJustify = false;
            this.leadingSign = false;
            this.leadingSpace = false;
            this.alternateForm = false;
            this.leadingZeros = false;
            while (this.pos < this.fmt.length()) {
                char c = this.fmt.charAt(this.pos);
                if (c == '\'') {
                    this.thousands = true;
                } else if (c == '-') {
                    this.leftJustify = true;
                    this.leadingZeros = false;
                } else if (c == '+') {
                    this.leadingSign = true;
                    this.leadingSpace = false;
                } else if (c == ' ') {
                    if (!this.leadingSign) {
                        this.leadingSpace = true;
                    }
                } else if (c == '#') {
                    this.alternateForm = true;
                } else {
                    if (c != '0') break;
                    if (!this.leftJustify) {
                        this.leadingZeros = true;
                    }
                }
                ++this.pos;
            }
        }
    }
}

