/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.sftp;

import de.babtec.globals.bmx.BMXPackets;
import de.eibport.net.bmx.BMXConnection;
import de.eibport.net.bmx.BMXListenerAdapter;
import de.eibport.net.sftp.BMXKeyListener;
import de.eibport.net.sftp.KeyStorageInterface;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyStorageBMX
implements KeyStorageInterface {
    public static final boolean DEBUG = false;
    public static final int UID_ROOT = 0;
    public static final int UID_BT1 = 301;
    public static final int UID_BT2 = 302;
    public static final int UID_BT3 = 303;
    public static final int UID_BT4 = 304;
    private byte[] publicKey = null;
    private byte[] privateKey = null;
    private boolean privateAvailable = false;
    private boolean privateReceived = false;
    private boolean publicAvailable = false;
    private boolean publicReceived = false;
    private BMXKeyListener bmxKeyListener;
    private byte[] iv_idx = new byte[8];
    private byte[] key_idx = new byte[8];
    private BMXConnection con;
    private BMXListenerAdapter conListener;
    private int uid;
    private boolean skipResponseUid = false;

    public KeyStorageBMX(BMXConnection bMXConnection, int n) {
        this(bMXConnection, n, false);
    }

    public KeyStorageBMX(BMXConnection bMXConnection, int n, boolean bl) {
        this.con = bMXConnection;
        this.uid = n;
        this.skipResponseUid = bl;
    }

    @Override
    public String getUsername() {
        switch (this.uid) {
            case 0: {
                return "root";
            }
            case 301: {
                return "bt1";
            }
            case 302: {
                return "bt2";
            }
            case 303: {
                return "bt3";
            }
            case 304: {
                return "bt4";
            }
        }
        return null;
    }

    @Override
    public void init(BMXKeyListener bMXKeyListener, boolean bl, boolean bl2) {
        this.bmxKeyListener = bMXKeyListener;
        if (!this.con.isConnected()) {
            this.con.openSocket(true);
        }
        if (!this.con.isConnected()) {
            bMXKeyListener.keyRequestingFailed("Unable to establish a BMX connection");
        } else {
            this.conListener = new BMXListenerAdapter(){

                @Override
                public void getCrypto(byte[] byArray) {
                    KeyStorageBMX.this.receiveCrypto(byArray);
                }
            };
            this.con.addBMXListener(this.conListener);
            new Random().nextBytes(this.iv_idx);
            if (bl2) {
                this.con.sendPacket(BMXPackets.constructBMXCrypto(this.iv_idx, 1, this.uid));
            } else {
                this.privateReceived = true;
            }
            if (bl) {
                this.con.sendPacket(BMXPackets.constructBMXCrypto(this.iv_idx, 2, this.uid));
            } else {
                this.publicReceived = true;
            }
        }
    }

    private void finishRequest() {
        this.con.removeBMXListener(this.conListener);
    }

    private void receiveCrypto(byte[] byArray) {
        int n;
        int n2 = 4;
        int n3 = (byArray[n2 + 3] & 0xFF) << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF;
        int n4 = (byArray[(n2 += 4) + 3] & 0xFF) << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF;
        n2 += 4;
        if (!this.skipResponseUid) {
            n = (byArray[n2 + 3] & 0xFF) << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF;
            n2 += 4;
            if (this.uid != n) {
                System.out.println("user id is not matching: " + this.uid + "!= " + n);
                return;
            }
        }
        n = (byArray[n2 + 3] & 0xFF) << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF;
        n2 += 4;
        System.out.println("length: " + n);
        if (n <= 0) {
            if (n4 == 1) {
                this.privateReceived = true;
                this.bmxKeyListener.privateKeyReceived(false, "No key in eibPort");
            } else {
                this.publicReceived = true;
                this.bmxKeyListener.publicKeyReceived(false, "No key in eibPort");
            }
        } else {
            byte[] byArray2 = new byte[256];
            System.arraycopy(byArray, n2, byArray2, 0, 256);
            this.key_idx[0] = byArray2[234];
            this.key_idx[1] = byArray2[73];
            this.key_idx[2] = byArray2[184];
            this.key_idx[3] = byArray2[32];
            this.key_idx[4] = byArray2[86];
            this.key_idx[5] = byArray2[36];
            this.key_idx[6] = byArray2[252];
            this.key_idx[7] = byArray2[177];
            n2 += 256;
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray3, 0, n);
            try {
                Cipher cipher = Cipher.getInstance("Blowfish/CFB8/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(this.key_idx, "Blowfish");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv_idx);
                cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                if (n4 == 1) {
                    this.privateKey = cipher.doFinal(byArray3);
                    this.privateReceived = true;
                    this.privateAvailable = true;
                    this.bmxKeyListener.privateKeyReceived(true, null);
                } else {
                    this.publicKey = cipher.doFinal(byArray3);
                    this.publicReceived = true;
                    this.publicAvailable = true;
                    this.bmxKeyListener.publicKeyReceived(true, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.privateReceived && this.publicReceived) {
            this.finishRequest();
            this.bmxKeyListener.finishedReceivingKeys(this.privateAvailable, this.publicAvailable, this);
        }
    }

    @Override
    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean privateAvailable() {
        return this.privateAvailable;
    }

    @Override
    public boolean publicAvailable() {
        return this.publicAvailable;
    }
}

