/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.mcast.packets.v2;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.babtec.json.JsonUtils;
import de.eibport.net.mcast.packets.v2.EpDatagramBody;
import de.eibport.net.mcast.utils.MCastTools;

public class BodyJSON
extends EpDatagramBody {
    public static final int CURRENT_VERSION = 1;
    public static final int MSG_NO_ERROR = 0;
    public static final int MSG_INVALID_SSH_STRING = 1;
    public static final int MSG_UNABLE_TO_DECRYPT = 2;
    public static final int MSG_UNABLE_TO_PARSE_DATA = 3;
    public static final int MSG_INVALID_CONFIGURATION_VALUES = 4;
    public static final int MSG_CONFIG_WRITER_ERROR = 5;
    public static final String KEY_VERSION = "version";
    public static final String KEY_UNIQUE_PACKET_NO = "upn";
    public static final String KEY_COMMAND = "cmd";
    public static final String KEY_TYPE = "type";
    public static final String KEY_INVOKE_ID = "invokeId";
    public static final String KEY_SERNR = "sernr";
    public static final String KEY_DATA = "data";
    public static final String KEY_MSG_NO = "msg_no";
    public static final String KEY_MSG = "msg";
    public static final String CMD_GET_CONFIGURATION = "getConfiguration";
    public static final String CMD_SET_CONFIGURATION = "setConfiguration";
    public static final String TYPE_REQUEST = "request";
    public static final String TYPE_RESPONSE = "response";
    public static final String TYPE_MESSAGE = "message";
    private JsonObject data;

    public BodyJSON(byte[] byArray, int n, int n2) throws Exception {
        this.data = (JsonObject)new JsonParser().parse(new String(MCastTools.getBytes(byArray, n, n2 - n)));
    }

    private BodyJSON(String string, String string2, int n) {
        this.data = new JsonObject();
        this.data.addProperty(KEY_VERSION, 1);
        this.data.addProperty(KEY_UNIQUE_PACKET_NO, (short)(Math.random() * 32767.0));
        this.data.addProperty(KEY_COMMAND, string);
        this.data.addProperty(KEY_TYPE, string2);
        this.data.addProperty(KEY_INVOKE_ID, n);
    }

    @Override
    public String getDescription() {
        return null;
    }

    public int getVersion() {
        return JsonUtils.getInt(this.data, KEY_VERSION, -1);
    }

    public boolean checkVersion() {
        return 1 == this.getVersion();
    }

    public int getUniquePacketNo() {
        return JsonUtils.getInt(this.data, KEY_UNIQUE_PACKET_NO, this.getInvokeId());
    }

    public String getCommand() {
        return JsonUtils.getString(this.data, KEY_COMMAND, "");
    }

    public boolean checkCommand(String string) {
        return string.equals(this.getCommand());
    }

    public String getType() {
        return JsonUtils.getString(this.data, KEY_TYPE, "");
    }

    public boolean checkType(String string) {
        return string.equals(this.getType());
    }

    public int getInvokeId() {
        return JsonUtils.getInt(this.data, KEY_INVOKE_ID, -1);
    }

    public boolean checkInvokeId(int n) {
        return n == this.getInvokeId();
    }

    public JsonObject getJSON() {
        return this.data;
    }

    public static BodyJSON getConfigurationRequest(int n, int n2, JsonArray jsonArray) {
        BodyJSON bodyJSON = new BodyJSON(CMD_GET_CONFIGURATION, TYPE_REQUEST, n);
        bodyJSON.data.addProperty(KEY_SERNR, n2);
        bodyJSON.data.add(KEY_DATA, jsonArray);
        return bodyJSON;
    }

    public static BodyJSON getConfigurationResponse(int n, int n2, JsonObject jsonObject) {
        BodyJSON bodyJSON = new BodyJSON(CMD_GET_CONFIGURATION, TYPE_RESPONSE, n);
        bodyJSON.data.addProperty(KEY_SERNR, n2);
        bodyJSON.data.add(KEY_DATA, jsonObject);
        return bodyJSON;
    }

    public static BodyJSON setConfigurationRequest(int n, int n2, String string) {
        BodyJSON bodyJSON = new BodyJSON(CMD_SET_CONFIGURATION, TYPE_REQUEST, n);
        bodyJSON.data.addProperty(KEY_SERNR, n2);
        bodyJSON.data.addProperty(KEY_DATA, string);
        return bodyJSON;
    }

    public static BodyJSON setConfigurationMessage(int n, int n2, int n3, String string) {
        BodyJSON bodyJSON = new BodyJSON(CMD_SET_CONFIGURATION, TYPE_MESSAGE, n);
        bodyJSON.data.addProperty(KEY_SERNR, n2);
        bodyJSON.data.addProperty(KEY_MSG_NO, n3);
        bodyJSON.data.addProperty(KEY_MSG, string);
        return bodyJSON;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public byte[] getBytes() {
        return this.data.toString().getBytes();
    }

    @Override
    public int getLength() {
        return 0;
    }
}

