/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.mcast.packets.v1;

import java.net.DatagramPacket;
import java.net.InetAddress;

public class DatagramHeader {
    private int magic;
    private int version;
    private int command;
    private int flags;
    private byte[] macAddress = new byte[6];
    private InetAddress inetAddress;

    public DatagramHeader(DatagramPacket datagramPacket) {
        this.inetAddress = datagramPacket.getAddress();
        byte[] byArray = datagramPacket.getData();
        this.magic = byArray[0] & 0xFF;
        this.version = byArray[1] & 0xFF;
        this.command = ((byArray[3] & 0xFF) << 8) + (byArray[2] & 0xFF);
        this.flags = ((byArray[5] & 0xFF) << 8) + (byArray[4] & 0xFF);
        System.arraycopy(byArray, 6, this.macAddress, 0, 6);
    }

    public int getVersion() {
        return this.version;
    }

    public int getCommand() {
        return this.command;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public String getMacAddressAsString() {
        return DatagramHeader.dumpBytes(this.macAddress);
    }

    public static String dumpBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append("-");
            }
            String string = Integer.toHexString(256 + (byArray[i] & 0xFF)).substring(1);
            stringBuffer.append((string.length() < 2 ? "0" : "") + string);
        }
        return stringBuffer.toString();
    }
}

