/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.mplex;

import de.babtec.globals.bmx.BMXPackets;
import de.babtec.globals.bmx.BMXTelegram;
import de.babtec.globals.utils.ParserInterface;
import de.eibport.net.bmx.BMXAddressTable;
import de.eibport.net.bmx.BMXConnection;
import de.eibport.net.bmx.BMXConnectionHandler;
import de.eibport.net.bmx.BMXConnectionThread;
import java.io.IOException;
import java.net.Socket;

public abstract class MPlexClientConnection
extends BMXConnection {
    private BMXConnectionHandler serverHandler;

    public MPlexClientConnection(Socket socket, BMXConnectionHandler bMXConnectionHandler) throws IOException {
        super(null, 0, null, 0, null);
        this.serverHandler = bMXConnectionHandler;
        this.con = new BMXConnectionThread(this, socket);
    }

    protected abstract void connectionInterrupted();

    @Override
    public void parsePacket(byte[] byArray, int n) {
        int n2 = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        switch (n2) {
            case 0: {
                byte[] byArray2 = new byte[n - 9];
                System.arraycopy(byArray, 8, byArray2, 0, n - 9);
                switch (byArray[4]) {
                    case 0: {
                        System.out.println("TODO: Identification Name \"" + new String(byArray2) + "\"");
                        break;
                    }
                    case 1: {
                        System.out.println("TODO: Identification Version");
                        break;
                    }
                    case 2: {
                        System.out.println("TODO: Identification Protocol");
                        break;
                    }
                    case 3: {
                        System.out.println("TODO: Identification Protocol Version");
                    }
                }
                break;
            }
            case 1: {
                System.out.println("Client is now listening for telegram events...");
                this.online = true;
                break;
            }
            case 2: {
                System.out.println("Client is not listening for telegram events anymore...");
                this.online = false;
                break;
            }
            case 4: {
                System.out.println("got telegram from client");
                BMXTelegram bMXTelegram = new BMXTelegram(byArray);
                System.out.println(bMXTelegram.getStatusFunction());
                if (bMXTelegram.getStatusFunction() == 0 || bMXTelegram.getStatusFunction() == 3) {
                    System.out.println("interne Frage oder interne / externe Frage");
                    BMXTelegram bMXTelegram2 = this.addressTable.getTelegramForAddress(bMXTelegram.getAddress());
                    if (bMXTelegram2 != null) {
                        this.serverHandler.sendPacket(BMXPackets.constructTelegram(bMXTelegram2));
                        break;
                    }
                    if (bMXTelegram.getStatusFunction() == 0) {
                        System.out.println("Kein Telegramm f\u00fcr interne Frage.");
                        break;
                    }
                    System.out.println("Kein Telegramm f\u00fcr interne / externe Frage. Behandle Frage als Extern.");
                }
                System.out.println("forwarding telegram...");
                this.serverHandler.sendPacket(byArray);
                break;
            }
            case 6: {
                byte[] byArray3;
                System.out.println("get Tele Tabelle");
                BMXAddressTable bMXAddressTable = this.serverHandler.getBMXConnection().getAddressTable();
                if (bMXAddressTable == null) {
                    System.out.println("Addresstable = null");
                    break;
                }
                for (BMXTelegram bMXTelegram : bMXAddressTable.getCompleteTable()) {
                    byArray3 = BMXPackets.constructTelegram(bMXTelegram);
                    byArray3[2] = 6;
                    this.sendPacket(byArray3);
                }
                byArray3 = BMXPackets.constructTelegram(0, 0, 0, new byte[16]);
                byArray3[2] = 6;
                this.sendPacket(byArray3);
                System.out.println("Returned " + bMXAddressTable.getCompleteTable().length + " Telegrams");
                break;
            }
            default: {
                System.out.println("Unknown command: " + n2);
            }
        }
    }

    @Override
    public void socketConnectionInterrupted() {
        System.out.println("Connection Interrupted... destroying client socket");
        this.connectionInterrupted();
    }

    @Override
    public void setEnOceanOnline(boolean bl) {
        System.err.println("It is not allowed to call setEnOceanOnline on a MPlexClientConnecton.");
    }

    @Override
    public void setEnOceanParser(ParserInterface parserInterface) {
        System.err.println("It is not allowed to call setEnOceanParser on a MPlexClientConnecton.");
    }

    @Override
    public void setUDPMonitorParser(ParserInterface parserInterface) {
        System.err.println("It is not allowed to call setUDPMonitorParser on a MPlexClientConnecton.");
    }

    public void setServerHandler(BMXConnectionHandler bMXConnectionHandler) {
        System.err.println("It is not allowed to call setServerHandler on a MPlexClientConnecton.");
    }

    @Override
    public boolean setOnline(boolean bl) {
        System.err.println("It is not allowed to call setOnline on a MPlexClientConnecton.");
        return false;
    }
}

