/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.mplex;

import de.babtec.globals.bmx.BMXTelegram;
import de.eibport.net.bmx.BMXConnection;
import de.eibport.net.bmx.BMXConnectionHandler;
import de.eibport.net.bmx.BMXListenerAdapter;
import de.eibport.net.bmx.mplex.MPlexClientConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

public class BMXMultiplexer {
    private Thread serverThread;
    private ArrayList<MPlexClientConnection> clients = new ArrayList();
    private BMXConnectionHandler handler;

    public BMXMultiplexer(String string, int n, final int n2) {
        BMXConnection bMXConnection = new BMXConnection(string, n, "MPlex", 0, ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parsePacket(byte[] byArray, int n) {
                int n2 = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
                switch (n2) {
                    case 4: {
                        BMXTelegram bMXTelegram = new BMXTelegram(byArray);
                        if (this.addressTable != null) {
                            this.addressTable.insertTelegram(bMXTelegram);
                        }
                        ArrayList arrayList = BMXMultiplexer.this.clients;
                        synchronized (arrayList) {
                            for (MPlexClientConnection mPlexClientConnection : BMXMultiplexer.this.clients) {
                                mPlexClientConnection.sendPacket(byArray);
                            }
                            break;
                        }
                    }
                    default: {
                        super.parsePacket(byArray, n);
                    }
                }
            }
        };
        this.handler = new BMXConnectionHandler(bMXConnection, 5000);
        this.handler.setConnectionStatus(this, 2, true);
        this.handler.getBMXConnection().addBMXListener(new BMXListenerAdapter(){

            @Override
            public void addressTableCompleted() {
                System.out.println("addresstable complete... starting server thread.");
                try {
                    BMXMultiplexer.this.serverThread = new ServerThread(n2);
                    BMXMultiplexer.this.serverThread.start();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewClient(Socket socket) throws IOException {
        try {
            MPlexClientConnection mPlexClientConnection = new MPlexClientConnection(socket, this.handler){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void connectionInterrupted() {
                    System.out.println("Connection Interrupted... destroying client socket");
                    ArrayList arrayList = BMXMultiplexer.this.clients;
                    synchronized (arrayList) {
                        BMXMultiplexer.this.clients.remove(this);
                        System.out.println("Connected Clients: " + BMXMultiplexer.this.clients.size());
                    }
                }
            };
            ArrayList<MPlexClientConnection> arrayList = this.clients;
            synchronized (arrayList) {
                this.clients.add(mPlexClientConnection);
                System.out.println("Connected Clients: " + this.clients.size());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        new BMXMultiplexer("127.0.0.1", 1735, 1835);
    }

    class ServerThread
    extends Thread {
        ServerSocket server;

        public ServerThread(int n) throws IOException {
            this.server = new ServerSocket(n);
        }

        @Override
        public void run() {
            try {
                Socket socket;
                while ((socket = this.server.accept()) != null) {
                    BMXMultiplexer.this.handleNewClient(socket);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

