/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.eis.calculators;

import de.eibport.net.bmx.eis.EISGenerator;
import de.eibport.net.bmx.eis.calculators.AbstractEISCalculator;

public class EIS9Calculator
extends AbstractEISCalculator {
    @Override
    public byte[] getBytesForValue(double d) {
        return this.getBytesForValue(new Double(d));
    }

    @Override
    public byte[] getBytesForValue(Object object) {
        if (!(object instanceof Double)) {
            throw new IllegalArgumentException("Value must be a Double-Object for EIS 9");
        }
        return EISGenerator.eis9ToByte((Double)object);
    }

    @Override
    public Object getValueForBytes(byte[] byArray) {
        return new Double(EISGenerator.byteToEis9(byArray));
    }

    @Override
    public String getStringForValue(Object object) {
        if (!(object instanceof Double)) {
            throw new IllegalArgumentException("Value must be a Integer-Object for EIS 9");
        }
        return ((Double)object).toString();
    }

    @Override
    public Object getValueForString(String string) {
        return new Double(string);
    }
}

