/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.eis;

public class EISGenerator {
    public static byte[] eis5ToByte(double d) {
        byte[] byArray = new byte[2];
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        String string = "";
        if (d < 0.0) {
            bl = true;
            d *= -1.0;
        }
        if (bl) {
            while (d > 20.48 && n2 < 16) {
                d /= 2.0;
                ++n2;
            }
        } else {
            while (d > 20.47 && n2 < 16) {
                d /= 2.0;
                ++n2;
            }
        }
        if (n2 > 15) {
            if (bl) {
                byArray[0] = -8;
                byArray[1] = 0;
            } else {
                byArray[0] = 127;
                byArray[1] = -1;
            }
        } else if (bl) {
            n = (~((int)(d * 100.0)) & 0x7FF) + 1;
            string = 1 + EISGenerator.toBitString(n2, 4) + EISGenerator.toBitString(n, 11);
            byArray[0] = (byte)Integer.parseInt(string.substring(0, 8), 2);
            byArray[1] = (byte)Integer.parseInt(string.substring(8), 2);
        } else {
            n = (int)(d * 100.0);
            string = 0 + EISGenerator.toBitString(n2, 4) + EISGenerator.toBitString(n, 11);
            byArray[0] = (byte)Integer.parseInt(string.substring(0, 8), 2);
            byArray[1] = (byte)Integer.parseInt(string.substring(8), 2);
        }
        return byArray;
    }

    public static double byteToEis5(byte[] byArray) {
        double d = 0.0;
        String string = "";
        string = EISGenerator.toBitString(byArray[0] & 0xFF) + EISGenerator.toBitString(byArray[1] & 0xFF);
        int n = Integer.parseInt("" + string.charAt(0), 2);
        int n2 = Integer.parseInt(string.substring(1, 5), 2);
        int n3 = Integer.parseInt(string.substring(5, 16), 2);
        if (n == 1) {
            n3 = (~n3 & 0x7FF) + 1;
        }
        d = 0.01 * (double)n3 * Math.pow(2.0, n2);
        if (n == 1) {
            d *= -1.0;
        }
        return d;
    }

    public static byte[] eis6ToByte(int n, boolean bl) throws IllegalArgumentException {
        if (n < 0 && bl) {
            n = 0;
        }
        if (n < 0 && !bl) {
            throw new IllegalArgumentException("EIS6 cannot be < 0");
        }
        if (n > 100 && bl) {
            n = 100;
        }
        if (n > 100 && !bl) {
            throw new IllegalArgumentException("EIS6 cannot be > 100");
        }
        n = (int)Math.round((double)n * 2.55);
        return new byte[]{(byte)n};
    }

    public static int byteToEis6(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        n = (int)Math.round((double)n / 2.55);
        return n;
    }

    public static byte[] eis10ToByte(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 65535) {
            n = 65535;
        }
        return new byte[]{(byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
    }

    public static int byteToEis10(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public static byte[] eis11ToByte(int n) {
        return new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
    }

    public static int byteToEis11(byte[] byArray) {
        return byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
    }

    public static byte[] eis14ToByte(int n, boolean bl) throws IllegalArgumentException {
        if (n < 0 && bl) {
            n = 0;
        }
        if (n < 0 && !bl) {
            throw new IllegalArgumentException("EIS 14u cannot be < 0");
        }
        if (n > 255 && bl) {
            n = 255;
        }
        if (n > 255 && !bl) {
            throw new IllegalArgumentException("EIS 14u cannot be > 255");
        }
        return new byte[]{(byte)n};
    }

    public static int byteToEis14(byte[] byArray) {
        return byArray[0] & 0xFF;
    }

    public static byte[] eis14sToByte(int n, boolean bl) throws IllegalArgumentException {
        if (n < -128 && bl) {
            n = -128;
        }
        if (n < -128 && !bl) {
            throw new IllegalArgumentException("EIS 14s cannot be < -128");
        }
        if (n > 127 && bl) {
            n = 127;
        }
        if (n > 127 && !bl) {
            throw new IllegalArgumentException("EIS 14s cannot be > 127");
        }
        return new byte[]{(byte)n};
    }

    public static int byteToEis14s(byte[] byArray) {
        return byArray[0];
    }

    public static byte[] eis9ToByte(double d) {
        return EISGenerator.eis11ToByte(Float.floatToIntBits((float)d));
    }

    public static double byteToEis9(byte[] byArray) {
        float f = Float.intBitsToFloat(EISGenerator.byteToEis11(byArray));
        return f;
    }

    public static String toBitString(int n) {
        char[] cArray = new char[8];
        int n2 = 1;
        for (int i = 0; i < 8; ++i) {
            cArray[7 - i] = (n & n2) != 0 ? 49 : 48;
            n2 <<= 1;
        }
        return new String(cArray);
    }

    public static String toBitString(int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            cArray[n2 - 1 - i] = (n & n3) != 0 ? 49 : 48;
            n3 <<= 1;
        }
        return new String(cArray);
    }
}

