/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx;

import de.babtec.globals.bmx.BMXTelegram;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.eibport.net.bmx.BMXConnection;
import de.eibport.net.bmx.BMXListenerAdapter;
import de.eibport.net.bmx.jobs.BMXJobContainer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;

public class BMXConnectionHandler {
    public static final int STATUS_OFFLINE = 0;
    public static final int STATUS_CONNECTED = 1;
    public static final int STATUS_ONLINE = 2;
    public static final int ERRORCODE_NONE = 0;
    private BMXConnection con;
    private int status = 0;
    private BMXJobContainer jobContainer;
    private HashMap<Object, Integer> objectStatusMap = new HashMap();
    private ArrayList<EIBAddressObject2> addressObjects = new ArrayList();
    private EIBAddressObject2[] addressObjectArray = new EIBAddressObject2[0];

    public BMXConnectionHandler(BMXConnection bMXConnection, int n) {
        this.con = bMXConnection;
        bMXConnection.addBMXListener(new BMXListenerAdapter(){

            @Override
            public void getTelegram(BMXTelegram bMXTelegram) {
                try {
                    for (EIBAddressObject2 eIBAddressObject2 : BMXConnectionHandler.this.addressObjectArray) {
                        eIBAddressObject2.newTelegram(bMXTelegram);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    System.out.println("AddressObjects changed");
                }
            }
        });
    }

    public BMXJobContainer getBMXJobContainer() {
        if (this.jobContainer == null) {
            this.jobContainer = new BMXJobContainer(this);
        }
        return this.jobContainer;
    }

    public BMXConnection getBMXConnection() {
        return this.con;
    }

    public void dispose() {
        System.out.println("disposing BMX connection");
        this.setConnectionState(false, true);
    }

    public int setConnectionStatus(Object object, int n, boolean bl) {
        if (n == 0) {
            this.objectStatusMap.remove(object);
        } else {
            this.objectStatusMap.put(object, n);
        }
        int n2 = 0;
        for (int n3 : this.objectStatusMap.values()) {
            n2 = Math.max(n2, n3);
        }
        if (n2 == this.status) {
            return 0;
        }
        switch (n2) {
            case 0: {
                switch (this.status) {
                    case 2: {
                        this.setConnectionOnline(false);
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    case 1: {
                        this.setConnectionState(false, bl);
                    }
                }
                break;
            }
            case 1: {
                if (this.status == 2) {
                    this.setConnectionOnline(false);
                }
                if (this.status != 0) break;
                this.setConnectionState(true, bl);
                break;
            }
            case 2: {
                switch (this.status) {
                    case 0: {
                        this.setConnectionState(true, bl);
                    }
                    case 1: {
                        this.setConnectionOnline(true);
                    }
                }
            }
        }
        return 0;
    }

    private boolean setConnectionState(boolean bl, boolean bl2) {
        if (bl) {
            boolean bl3 = this.con.openSocket(bl2);
            if (bl3) {
                this.getBMXJobContainer().init();
                this.status = 1;
            }
            return bl3;
        }
        boolean bl4 = this.con.closeSocket();
        if (bl4) {
            this.status = 0;
        }
        return bl4;
    }

    private boolean setConnectionOnline(boolean bl) {
        boolean bl2 = this.con.setOnline(bl);
        if (bl2) {
            if (bl) {
                this.con.enableAdressTable();
            }
            this.status = bl ? 2 : 1;
        }
        return bl2;
    }

    public void addAddressObjectAsListener(EIBAddressObject2 eIBAddressObject2) {
        if (!this.addressObjects.contains(eIBAddressObject2)) {
            this.addressObjects.add(eIBAddressObject2);
            this.addressObjectArray = this.addressObjects.toArray(new EIBAddressObject2[this.addressObjects.size()]);
            this.setLatestTelegram(eIBAddressObject2);
        }
    }

    public void setLatestTelegram(EIBAddressObject2 eIBAddressObject2) {
        for (int i = 0; i < eIBAddressObject2.getAddressCount(); ++i) {
            eIBAddressObject2.newTelegram(this.getBMXConnection().getTelegramForAddress(eIBAddressObject2.getAddress(i).getIntAddress()));
        }
    }

    public void removeAddressObjectAsListener(EIBAddressObject2 eIBAddressObject2) {
        this.addressObjects.remove(eIBAddressObject2);
        this.addressObjectArray = this.addressObjects.toArray(new EIBAddressObject2[this.addressObjects.size()]);
    }

    public void sendPacket(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.con.sendPacket(byArray);
    }

    public void initialize(EIBAddressObject2 eIBAddressObject2) {
        byte[] byArray = eIBAddressObject2.getInitializationPackage();
        if (byArray != null) {
            this.sendPacket(byArray);
        } else {
            System.out.println("Failed to initialize EIBAddressObject2 (Adress is missing or wrong formatted)!");
        }
    }

    public void closeConnection() {
        if (this.con.isConnected()) {
            this.con.setOnline(false);
            this.con.closeSocket();
        }
    }
}

