/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.login.model;

import de.babtec.globals.HashUtils;
import de.eibport.login.PasswordCheck;
import org.jdom.Element;

public class EpSystemUser {
    private Element user;
    private boolean pwHasBeenChanged = false;
    private char[] loggedInPassword = null;
    private String loginId;

    public EpSystemUser(Element element) {
        this.user = element;
    }

    public char[] getLoggedInPassword() {
        return this.loggedInPassword;
    }

    public void setLoggedInPassword(char[] cArray) {
        this.loggedInPassword = cArray;
    }

    public void setLoginId(String string) {
        this.loginId = string;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public boolean changePassword() {
        try {
            return this.user.getAttribute("changepw").getBooleanValue();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setChangePassword(boolean bl) {
        this.user.setAttribute("changepw", Boolean.toString(bl));
    }

    public String getDescription() {
        return this.user.getAttributeValue("name");
    }

    public void setDescription(String string) {
        this.user.setAttribute("name", string);
    }

    public String getUsername() {
        return this.user.getAttributeValue("username");
    }

    public boolean hasAccess(String string) {
        if (this.getUsername().equals("admin")) {
            return true;
        }
        String[] stringArray = string.split("\\|");
        Element element = this.user;
        for (int i = 0; i < stringArray.length; ++i) {
            element = element.getChild(stringArray[i]);
        }
        try {
            return element.getAttribute("access").getBooleanValue();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setAccess(String string, boolean bl) {
        if (this.getUsername().equals("admin")) {
            return;
        }
        String[] stringArray = string.split("\\[\\|\\]");
        Element element = this.user;
        for (int i = 0; i < stringArray.length; ++i) {
            if (element.getChild(stringArray[i]) == null) {
                element.addContent(new Element(stringArray[i]));
            }
            element = element.getChild(stringArray[i]);
        }
        element.setAttribute("access", Boolean.toString(bl));
    }

    public int getLevel(String string) {
        if (this.getUsername().equals("admin")) {
            return 100;
        }
        String[] stringArray = string.split("\\[\\|\\]");
        Element element = this.user;
        for (int n = 0; n < stringArray.length && element != null; element = element.getChild(stringArray[n]), ++n) {
        }
        try {
            return element.getAttribute("level").getIntValue();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setLevel(String string, int n) {
        if (this.getUsername().equals("admin")) {
            return;
        }
        String[] stringArray = string.split("\\[\\|\\]");
        Element element = this.user;
        for (int i = 0; i < stringArray.length; ++i) {
            if (element.getChild(stringArray[i]) == null) {
                element.addContent(new Element(stringArray[i]));
            }
            element = element.getChild(stringArray[i]);
        }
        element.setAttribute("level", Integer.toString(n));
        element.setAttribute("access", Boolean.toString(n > 0));
    }

    public double getPwScore() {
        if (this.user.getAttribute("pwscore") == null) {
            return 0.0;
        }
        return Double.parseDouble(this.user.getAttributeValue("pwscore"));
    }

    public void setPassword(char[] cArray) {
        this.user.setAttribute("changepw", "false");
        double d = PasswordCheck.check(new String(cArray));
        this.user.setAttribute("pwscore", Double.toString((double)Math.round(d * 100.0) / 100.0));
        this.user.setAttribute("pwsec", HashUtils.doHash(this.getUsername(), cArray));
    }

    public boolean matchLogin(String string, char[] cArray) {
        if (this.user.getAttribute("pwsec") == null) {
            return this.user.getAttributeValue("password").equals(new String(cArray));
        }
        return this.user.getAttributeValue("pwsec").equals(HashUtils.doHash(string, cArray));
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean isVisible() {
        try {
            return this.user.getAttribute("visible").getBooleanValue();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setVisible(boolean bl) {
        this.user.setAttribute("visible", Boolean.toString(bl));
    }

    public Element getElement() {
        return this.user;
    }

    public void setPwHasBeenChanged(boolean bl) {
        this.pwHasBeenChanged = bl;
    }

    public boolean getPwHasBeenChanged() {
        return this.pwHasBeenChanged;
    }
}

