/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.about;

import de.babtec.globals.gsm.GSMStatus;
import de.eibport.components.JButtonBar;
import de.eibport.net.HostInformation;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GSMStatusBox
extends JPanel {
    public static String LABEL_NAME = "Name";
    public static String LABEL_FIRMWARE = "Firmware Version";
    public static String LABEL_SERIALNR = "Serial Number";
    public static String LABEL_GSM_STATUS = "GSM Status";
    private GridBagConstraints gbc;
    private HostInformation hostInfo;
    private JLabel modem = new JLabel();
    private JLabel state = new JLabel();
    private JLabel pinState = new JLabel();
    private JLabel imei = new JLabel();
    private JLabel imsi = new JLabel();
    private JLabel provider = new JLabel();
    private JLabel service = new JLabel();
    private JLabel number = new JLabel();
    private JLabel signal = new JLabel();

    public GSMStatusBox(HostInformation hostInformation) {
        this.hostInfo = hostInformation;
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.gbc.gridwidth = 2;
        ImageIcon imageIcon = new ImageIcon(this.getClass().getClassLoader().getResource("de/eibport/components/about/AboutEibPort.png"));
        this.add((Component)new JLabel(imageIcon, 0), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.add(LABEL_NAME, hostInformation.getEpName());
        this.add(LABEL_FIRMWARE, hostInformation.getFwVersion());
        this.add(LABEL_SERIALNR, hostInformation.getSernr());
        if (!GSMStatus.INITIATED) {
            this.add(LABEL_GSM_STATUS, "GSM status not initiated.");
            return;
        }
        if (!GSMStatus.GSM_AVAILABLE) {
            this.add(LABEL_GSM_STATUS, "No GSM modem installed.");
            return;
        }
        this.add(new JLabel("Modem"), this.modem);
        this.add(new JLabel("State"), this.state);
        this.add(new JLabel("PIN State"), this.pinState);
        this.add(new JLabel("IMEI"), this.imei);
        this.add(new JLabel("IMSI"), this.imsi);
        this.add(new JLabel("Provider"), this.provider);
        this.add(new JLabel("Service"), this.service);
        this.add(new JLabel("Number"), this.number);
        this.add(new JLabel("Signal"), this.signal);
        this.startRefreshStatus();
    }

    private void startRefreshStatus() {
        new Thread(){

            @Override
            public void run() {
                while (GSMStatusBox.this.isVisible()) {
                    try {
                        GSMStatus.refresh(GSMStatusBox.this.hostInfo.getBaseURL());
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GSMStatusBox.this.refreshStatus();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        Thread.sleep(20000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }.start();
    }

    private void refreshStatus() {
        this.modem.setText(this.normalizeName("model"));
        this.state.setText(this.normalizeName("state"));
        this.pinState.setText(this.normalizeName("pin_state"));
        this.imei.setText(this.normalizeName("imei"));
        this.imsi.setText(this.normalizeName("imsi"));
        this.provider.setText(this.normalizeName("spn"));
        this.service.setText(this.normalizeName("gcap"));
        this.number.setText(this.normalizeName("cnum"));
        this.signal.setText(this.normalizeName("att_level") + " (" + this.normalizeName("rssi") + ")");
    }

    private String normalizeName(String string) {
        String string2 = GSMStatus.STATUS.get(string);
        if (string2 == null) {
            return "-";
        }
        if ("state".equals(string)) {
            try {
                int n = Integer.parseInt(string2);
                string2 = (new String[]{"UNKNOWN", "MODEM_FOUND", "REQUEST_IMSI", "WAIT_CALL_READY", "REQUEST_CSCA", "SET_CSCA", "REQUEST_CNUM", "INIT_DONE", "CLEAR_ALL_SMS", "MODEM_READY", "SEND_SMS"})[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ("pin_state".equals(string) && "'SIM PIN'".equals(string2)) {
            string2 = "Waiting for PIN";
        }
        if ("spn".equals(string) && string2.endsWith("(0)")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        if ("cnum".equals(string) && string2.equals("'(null)' (0)")) {
            string2 = "-";
        }
        if ("cnum".equals(string) && string2.endsWith("(145)")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        if (string2.startsWith("'") && string2.endsWith("'")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    public static void adoptLocalization(Messages messages) {
        LABEL_NAME = messages.getString("global.about.ep.name");
        LABEL_FIRMWARE = messages.getString("global.about.ep.firmware");
        LABEL_SERIALNR = messages.getString("global.about.ep.serialnr");
    }

    private void add(String string, String string2) {
        this.add(new JLabel(string), new JLabel(string2));
    }

    private void add(JLabel jLabel, JLabel jLabel2) {
        this.gbc.insets = new Insets(5, 5, 5, 0);
        this.gbc.gridx = 0;
        jLabel.setHorizontalAlignment(2);
        jLabel.setForeground(Color.BLACK);
        this.add((Component)jLabel, this.gbc);
        this.gbc.insets = new Insets(5, 20, 5, 5);
        this.gbc.gridx = 1;
        jLabel2.setHorizontalAlignment(2);
        jLabel2.setForeground(Color.BLACK);
        this.add((Component)jLabel2, this.gbc);
        ++this.gbc.gridy;
    }

    public static void showDialog(Frame frame, HostInformation hostInformation) {
        final JDialog jDialog = new JDialog(frame, "About GSM", true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)new GSMStatusBox(hostInformation), "Center");
        AbstractAction abstractAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        };
        JButtonBar jButtonBar = new JButtonBar();
        jButtonBar.setRightButtons(abstractAction);
        jDialog.getContentPane().add((Component)jButtonBar, "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(frame);
        jDialog.setVisible(true);
    }
}

