/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JOptionPane;

public class WindowUtils {
    public static Frame getFrameForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return WindowUtils.getFrameForComponent(component.getParent());
    }

    public static Window getWindowForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return WindowUtils.getWindowForComponent(component.getParent());
    }

    public static Dialog getDialogForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return null;
        }
        if (component instanceof Dialog) {
            return (Dialog)component;
        }
        return WindowUtils.getDialogForComponent(component.getParent());
    }

    public static void centerOnScreen(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width / 2 - dimension2.width / 2;
        int n2 = dimension.height / 2 - dimension2.height / 2;
        if (n < 0) {
            n = 0;
        }
        if (n > dimension3.width) {
            n = dimension3.width;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > dimension3.height) {
            n2 = dimension3.height;
        }
        component.setLocation(n, n2);
    }

    public static void centerComponent(Component component, Component component2) {
        Point point = component2.getLocation();
        Dimension dimension = component2.getSize();
        Dimension dimension2 = component.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width / 2 - dimension2.width / 2 + point.x;
        int n2 = dimension.height / 2 - dimension2.height / 2 + point.y;
        if (n < 0) {
            n = 0;
        }
        if (n > dimension3.width) {
            n = dimension3.width;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > dimension3.height) {
            n2 = dimension3.height;
        }
        component.setLocation(n, n2);
    }
}

