/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class PreviewComponent
extends JLabel {
    private Image image = null;
    private int maxWidth;
    private int maxHeight;
    private int width;
    private int height;

    public PreviewComponent(Dimension dimension) {
        this.maxWidth = dimension.width - 4;
        this.maxHeight = dimension.height - 4;
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setOpaque(true);
    }

    public void setImage(File file) {
        if (file != null) {
            ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
            this.image = imageIcon.getImage();
            this.width = imageIcon.getIconWidth();
            this.height = imageIcon.getIconHeight();
        } else {
            this.image = null;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.image != null) {
            double d;
            if (this.width > this.height) {
                if (this.width > this.maxWidth) {
                    d = (double)this.width / (double)this.maxWidth;
                    this.width = (int)((double)this.width / d);
                    this.height = (int)((double)this.height / d);
                }
            } else if (this.height > this.maxHeight) {
                d = (double)this.height / (double)this.maxHeight;
                this.width = (int)((double)this.width / d);
                this.height = (int)((double)this.height / d);
            }
            int n = (this.maxWidth - this.width) / 2 + 2;
            int n2 = (this.maxHeight - this.height) / 2 + 2;
            graphics.drawImage(this.image, n, n2, this.width, this.height, this);
        }
    }
}

