/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class JButtonBar
extends JPanel {
    public static final String KEY_BTN_TYPE = "btnType";
    public static final int BTN_TYPE_DEFAULT = 0;
    public static final int BTN_TYPE_TOGGLE = 1;
    public static int BUTTON_WIDTH = 120;
    private JPanel buttonsLeft;
    private JPanel buttonsRight;
    private int btnWidth = BUTTON_WIDTH;

    public JButtonBar(int n) {
        this();
        this.btnWidth = n;
    }

    public JButtonBar() {
        this.setBorder(new Border(){
            int insets = 3;

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(2 + this.insets, this.insets, this.insets, this.insets);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                int n5 = component.getWidth();
                Color color = component.getBackground();
                graphics.setColor(color.darker().darker());
                graphics.drawLine(0, 0, n5, 0);
                graphics.setColor(color.brighter().brighter());
                graphics.drawLine(0, 1, n5, 1);
            }
        });
        this.buttonsLeft = new JPanel(new GridLayout(1, 0, 10, 5));
        this.buttonsRight = new JPanel(new GridLayout(1, 0, 10, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonsLeft, "West");
        this.add((Component)this.buttonsRight, "East");
    }

    public void setLeftButtons(Object ... objectArray) {
        this.buttonsLeft.removeAll();
        Component component = null;
        for (Object object : objectArray) {
            if (object instanceof Action) {
                Action action = (Action)object;
                int n = 0;
                if (action.getValue(KEY_BTN_TYPE) != null) {
                    n = (Integer)action.getValue(KEY_BTN_TYPE);
                }
                switch (n) {
                    case 1: {
                        component = new JToggleButton(action);
                        break;
                    }
                    default: {
                        component = new JButton(action);
                        break;
                    }
                }
            } else if (object instanceof Component) {
                component = (Component)object;
            }
            if (component == null) continue;
            component.setPreferredSize(new Dimension(this.btnWidth, component.getPreferredSize().height));
            this.buttonsLeft.add(component);
        }
    }

    public void setRightButtons(Object ... objectArray) {
        this.buttonsRight.removeAll();
        Component component = null;
        for (Object object : objectArray) {
            if (object instanceof Action) {
                Action action = (Action)object;
                int n = 0;
                if (action.getValue(KEY_BTN_TYPE) != null) {
                    n = (Integer)action.getValue(KEY_BTN_TYPE);
                }
                switch (n) {
                    case 1: {
                        component = new JToggleButton(action);
                        break;
                    }
                    default: {
                        component = new JButton(action);
                        break;
                    }
                }
            } else if (object instanceof Component) {
                component = (Component)object;
            }
            if (component == null) continue;
            component.setPreferredSize(new Dimension(this.btnWidth, component.getPreferredSize().height));
            this.buttonsRight.add(component);
        }
    }
}

