/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool.discovery;

import de.babtec.updatetool.Ep3UpdateController;
import de.babtec.updatetool.discovery.DeviceListener;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.event.EventListenerList;

public class Device {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_EIBPORT_V2_1 = 2;
    public static final int TYPE_EIBPORT_V3 = 3;
    private EventListenerList updateListener = new EventListenerList();
    private long lastBeaconTime;
    private long ignoreTime;
    private EpDatagram lastDatagram;
    private int reachable;
    private boolean rescueMode;
    private boolean active = false;
    private int overwriteSshPort = -1;
    private int sernr;
    private int type = 0;
    private String rescueVersion = null;
    boolean updatePresent = false;

    public Device(EpDatagram epDatagram) {
        this.rescueMode = epDatagram.isInRescueMode();
        this.reachable = epDatagram.isReachable();
        this.sernr = epDatagram.getBody().getPropertyInteger("bSernr");
        System.out.println(this.sernr + ": got new device...");
        if (Integer.toString(this.sernr).endsWith("30")) {
            this.type = 3;
        } else if (Integer.toString(this.sernr).endsWith("11")) {
            this.type = 2;
        }
        this.setNewDatagram(epDatagram);
        this.checkYabusrc();
    }

    private void checkYabusrc() {
        if (this.type != 3) {
            return;
        }
        if (this.reachable != 1) {
            return;
        }
        this.overwriteSshPort = 36;
        try {
            String string;
            URL uRL = this.getURL("/yabusrc");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.matches("^\\s*ssh_port\\s*=\\s*\"\\d+\"\\s*$")) continue;
                String string2 = string.split("=")[1];
                string2 = string2.trim().replaceAll("\"", "");
                this.overwriteSshPort = Integer.parseInt(string2);
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getSshPort() {
        if (this.overwriteSshPort == -1) {
            return this.lastDatagram.getBody().getPropertyShort("bPortSsh") & 0xFFFF;
        }
        return this.overwriteSshPort;
    }

    public void addDeviceListener(DeviceListener deviceListener) {
        this.updateListener.add(DeviceListener.class, deviceListener);
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.updateListener.remove(DeviceListener.class, deviceListener);
    }

    public void setRescueVersion(String string) {
        this.rescueVersion = string;
    }

    public String getRescueVersion() {
        return this.rescueVersion;
    }

    public int getType() {
        return this.type;
    }

    public void setNewDatagram(EpDatagram epDatagram) {
        this.lastDatagram = epDatagram;
        this.lastBeaconTime = System.currentTimeMillis();
        if (!this.active && this.type == 3 && System.currentTimeMillis() > this.ignoreTime) {
            this.updatePresent = Ep3UpdateController.isUpdatePresent(this);
        }
        this.active = true;
        if (this.rescueMode != epDatagram.isInRescueMode()) {
            this.rescueMode = epDatagram.isInRescueMode();
            for (DeviceListener deviceListener : (DeviceListener[])this.updateListener.getListeners(DeviceListener.class)) {
                deviceListener.deviceUpdated(this, !epDatagram.isInRescueMode());
            }
        }
        epDatagram.testReachable(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Device.this.reachable != Device.this.lastDatagram.isReachable()) {
                    Device.this.reachable = Device.this.lastDatagram.isReachable();
                    for (DeviceListener deviceListener : (DeviceListener[])Device.this.updateListener.getListeners(DeviceListener.class)) {
                        deviceListener.deviceUpdated(Device.this, false);
                    }
                    Device.this.checkYabusrc();
                }
            }
        });
        for (DeviceListener deviceListener : (DeviceListener[])this.updateListener.getListeners(DeviceListener.class)) {
            deviceListener.receivedNewBeacon(epDatagram);
        }
    }

    public void setIgnoreSeconds(int n, boolean bl) {
        this.ignoreTime = System.currentTimeMillis() + (long)(n * 1000);
        this.updatePresent = true;
        for (DeviceListener deviceListener : (DeviceListener[])this.updateListener.getListeners(DeviceListener.class)) {
            deviceListener.deviceUpdated(this, false);
        }
    }

    public void testTimeout(int n) {
        boolean bl;
        boolean bl2 = bl = System.currentTimeMillis() > this.ignoreTime && System.currentTimeMillis() - this.lastBeaconTime < (long)(n * 1000);
        if (bl != this.active) {
            this.active = bl;
            if (!this.active) {
                this.updatePresent = false;
            }
            for (DeviceListener deviceListener : (DeviceListener[])this.updateListener.getListeners(DeviceListener.class)) {
                deviceListener.deviceUpdated(this, false);
            }
        }
    }

    public EpDatagram getLastDatagram() {
        return this.lastDatagram;
    }

    public int isReachable() {
        return this.reachable;
    }

    public boolean isInRescueMode() {
        return this.rescueMode;
    }

    public boolean isUpdatePresent() {
        return this.updatePresent;
    }

    public boolean isActive() {
        return this.active;
    }

    public URL getURL(String string) throws MalformedURLException {
        String string2 = this.lastDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        int n = this.lastDatagram.getBody().getPropertyShort("bPortHttp") & 0xFFFF;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return new URL("http://" + string2 + ":" + n + string);
    }

    public String toString() {
        return this.lastDatagram.toString();
    }
}

