/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool;

import de.babtec.updatetool.Ep2PreparationPanel;
import de.babtec.updatetool.Ep2UpdateController;
import de.babtec.updatetool.Ep2UpdatePanel;
import de.babtec.updatetool.Ep3UpdateController;
import de.babtec.updatetool.Ep3UpdatePanel;
import de.babtec.updatetool.UpdateTool;
import de.babtec.updatetool.discovery.Device;
import de.babtec.updatetool.discovery.DiscoveryPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.SocketException;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class UpdateToolPanel
extends JPanel {
    public static final String EMPTY = "empty";
    public static final String CONNECTING = "connecting";
    public static final String EP2_PREPARATION = "ep2_prep";
    public static final String EP2_UPDATE = "ep2_update";
    public static final String EP3_PREPARATION = "ep3_prep";
    public static final String EP3_UPDATE = "ep3_update";
    private Ep2UpdateController eP2controller;
    private Ep3UpdateController eP3controller;
    private DiscoveryPanel discovery;
    private Ep2PreparationPanel ep2Preparation;
    private Ep2UpdatePanel ep2Update;
    private Ep3UpdatePanel ep3Update;
    private JPanel right;
    private CardLayout cards;
    private JTextPane help;
    Thread prepareDeviceThread = null;

    public UpdateToolPanel(JTextPane jTextPane) {
        this.help = jTextPane;
        this.setLayout(new GridLayout(1, 2));
        try {
            this.eP2controller = new Ep2UpdateController();
            this.eP3controller = new Ep3UpdateController();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            return;
        }
        this.discovery = new DiscoveryPanel(this, this.eP2controller);
        this.add(this.discovery);
        this.right = new JPanel();
        this.add(this.right);
        this.cards = new CardLayout();
        this.right.setLayout(this.cards);
        this.ep2Preparation = new Ep2PreparationPanel(this.eP2controller);
        this.ep2Update = new Ep2UpdatePanel(this.eP2controller);
        this.ep3Update = new Ep3UpdatePanel(this.eP3controller);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdateToolPanel.connecting"), 0), "Center");
        this.right.add((Component)new JPanel(), EMPTY);
        this.right.add((Component)jPanel, CONNECTING);
        this.right.add((Component)this.ep2Preparation, EP2_PREPARATION);
        this.right.add((Component)this.ep2Update, EP2_UPDATE);
        this.right.add((Component)this.ep3Update, EP3_UPDATE);
        this.deviceSelected(null);
    }

    private void prepareDevice(final Device device, final Runnable runnable) {
        if (this.prepareDeviceThread != null) {
            this.prepareDeviceThread.interrupt();
        }
        this.prepareDeviceThread = new Thread(){

            @Override
            public void run() {
                device.setRescueVersion(UpdateToolPanel.this.eP2controller.getRescueVersion(device));
                if (!this.isInterrupted() && this.equals(UpdateToolPanel.this.prepareDeviceThread)) {
                    EventQueue.invokeLater(runnable);
                }
                UpdateToolPanel.this.prepareDeviceThread = null;
            }
        };
        this.prepareDeviceThread.start();
    }

    public void deviceSelected(final Device device) {
        this.ep2Preparation.setDevice(null);
        this.ep2Update.setDevice(null);
        if (device == null) {
            this.showHelp("");
            this.cards.show(this.right, EMPTY);
            return;
        }
        switch (device.getType()) {
            case 2: {
                if (device.isReachable() != 1) {
                    this.showHelp("");
                    this.cards.show(this.right, EMPTY);
                    break;
                }
                this.showHelp("ep2_");
                this.cards.show(this.right, CONNECTING);
                this.prepareDevice(device, new Runnable(){

                    @Override
                    public void run() {
                        if (device.isInRescueMode()) {
                            UpdateToolPanel.this.ep2Update.setDevice(device);
                            UpdateToolPanel.this.cards.show(UpdateToolPanel.this.right, UpdateToolPanel.EP2_UPDATE);
                        } else {
                            UpdateToolPanel.this.ep2Preparation.setDevice(device);
                            UpdateToolPanel.this.cards.show(UpdateToolPanel.this.right, UpdateToolPanel.EP2_PREPARATION);
                        }
                    }
                });
                break;
            }
            case 3: {
                if (device.isReachable() == 0 || device.isReachable() == 2 && !device.equals(this.ep3Update.getDevice())) {
                    this.showHelp("");
                    this.cards.show(this.right, EMPTY);
                    break;
                }
                this.showHelp("ep3_");
                this.ep3Update.setDevice(device);
                this.cards.show(this.right, EP3_UPDATE);
            }
        }
    }

    public void showHelp(String string) {
        try {
            if (Locale.getDefault().getISO3Language().equals(Locale.GERMAN.getISO3Language())) {
                this.help.setPage(this.getClass().getResource("help/" + string + "help_de.html"));
            } else {
                this.help.setPage(this.getClass().getResource("help/" + string + "help.html"));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

