/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool;

import de.babtec.bootstrap.BootstrapInfo;
import de.babtec.matrix.Utils;
import de.babtec.updatetool.Ep2UpdateController;
import de.babtec.updatetool.UpdateListenerAdapter;
import de.babtec.updatetool.UpdateTool;
import de.babtec.updatetool.discovery.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class Ep2UpdatePanel
extends JPanel {
    private Ep2UpdateController controller;
    private Device device;
    private JTextField inputPath;
    private JTextField inputType;
    private JTextField inputVersion;
    private JCheckBox inputUseDefaultIp;
    private JTextArea outputStatus;
    private JProgressBar progress;
    private JButton choosePath;
    private JButton btnSubmit;

    public Ep2UpdatePanel(Ep2UpdateController ep2UpdateController) {
        this.controller = ep2UpdateController;
        this.setBorder(BorderFactory.createTitledBorder(UpdateTool.messages.getString("UpdatePanel.title")));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.file")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets.right = 0;
        this.inputPath = new JTextField();
        jPanel.add((Component)this.inputPath, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 10;
        this.choosePath = new JButton("...");
        this.choosePath.setPreferredSize(new Dimension(this.choosePath.getPreferredSize().width, this.inputPath.getPreferredSize().height));
        this.choosePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Ep2UpdatePanel.this.chooseFile();
            }
        });
        jPanel.add((Component)this.choosePath, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets.left = 10;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.type")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputType = new JTextField();
        this.inputType.setEditable(false);
        jPanel.add((Component)this.inputType, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.version")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputVersion = new JTextField();
        this.inputVersion.setEditable(false);
        jPanel.add((Component)this.inputVersion, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.use_default_ip")), gridBagConstraints);
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.gridwidth = 2;
        this.inputUseDefaultIp = new JCheckBox();
        jPanel.add((Component)this.inputUseDefaultIp, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.bottom = 7;
        this.btnSubmit = new JButton(UpdateTool.messages.getString("UpdatePanel.btn_start"));
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Ep2UpdatePanel.this.startUpdate();
            }
        });
        jPanel.add((Component)this.btnSubmit, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)new JLabel(UpdateTool.messages.getString("UpdatePanel.status")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.bottom = 2;
        this.outputStatus = new JTextArea();
        this.outputStatus.setEditable(false);
        jPanel.add((Component)new JScrollPane(this.outputStatus), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 0;
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        jPanel.add((Component)this.progress, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.controller.addUpdateListener(new UpdateListenerAdapter(){

            @Override
            public void updateUploadStarted(final long l) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ep2UpdatePanel.this.progress.setMaximum((int)l);
                    }
                });
            }

            @Override
            public void updateUploadProgress(final long l, long l2) {
                System.out.println("uploaded " + l + "/" + l2);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ep2UpdatePanel.this.progress.setValue((int)l);
                    }
                });
            }

            @Override
            public void updateUploadFinished() {
                Ep2UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.upload_finished"));
            }

            @Override
            public void updateConnecting() {
                Ep2UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.connecting"));
            }

            @Override
            public void updateTransferring() {
                Ep2UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.uploading"));
            }

            @Override
            public void updateRebooting() {
                Ep2UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.installing"));
            }

            @Override
            public void updateError(String string) {
                Ep2UpdatePanel.this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.error") + string);
                Ep2UpdatePanel.this.inputPath.setEnabled(true);
                Ep2UpdatePanel.this.btnSubmit.setEnabled(true);
                Ep2UpdatePanel.this.choosePath.setEnabled(true);
            }
        });
    }

    private void appendStatusMessage(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ep2UpdatePanel.this.outputStatus.append(string + "\n");
            }
        });
    }

    private void chooseFile() {
        File file = new File(this.inputPath.getText());
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return UpdateTool.messages.getString("UpdatePanel.file_description");
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".bin");
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.inputPath.setText(string);
            this.checkFile(string);
        }
    }

    private void checkFile(String string) {
        this.btnSubmit.setEnabled(false);
        this.inputType.setText("");
        this.inputVersion.setText("");
        this.outputStatus.setText("");
        if (string.length() == 0) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.select_firmware"));
            this.btnSubmit.setEnabled(false);
            return;
        }
        int n = this.controller.compareMD5Checksum(string);
        switch (n) {
            case 1: {
                JOptionPane.showMessageDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.success"), UpdateTool.messages.getString("UpdatePanel.title"), 1);
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.fw_file_not_found"), UpdateTool.messages.getString("UpdatePanel.title"), 0);
                return;
            }
            case 5: {
                if (JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.chksum_unable_to_generate"), UpdateTool.messages.getString("UpdatePanel.title"), 0, 2) == 0) break;
                return;
            }
            case 3: {
                if (JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.chksum_file_not_found"), UpdateTool.messages.getString("UpdatePanel.title"), 0, 2) == 0) break;
                return;
            }
            case 2: {
                if (JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.md5.chksum_error"), UpdateTool.messages.getString("UpdatePanel.title"), 0, 0) == 0) break;
                return;
            }
        }
        String string2 = this.controller.getTypeAndVersion(string);
        if (string2 == null) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.invalid_file"));
            return;
        }
        String string3 = "type=\"(.*?)\".*?version=\"(.*?)\"";
        Pattern pattern = Pattern.compile(string3, 40);
        Matcher matcher = pattern.matcher(string2);
        if (!matcher.matches()) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.invalid_firmware"));
            return;
        }
        String string4 = matcher.group(1);
        String string5 = matcher.group(2);
        this.inputType.setText(string4);
        this.inputVersion.setText(string5);
        int n2 = this.device.getLastDatagram().getBody().getPropertyInteger("bSernr");
        String string6 = new DecimalFormat("BT0000000000").format(n2);
        if (Utils.isEibPortSernr(string6) && string6.endsWith("11") && !"ep2".equals(string4)) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.no_ep2_firmware"));
            return;
        }
        if (Utils.isIpcSernr(string6) && string6.endsWith("11") && !"ipc".equals(string4)) {
            this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.no_ipc_firmware"));
            return;
        }
        this.btnSubmit.setEnabled(true);
        this.appendStatusMessage(UpdateTool.messages.getString("UpdatePanel.status.ready"));
    }

    private void startUpdate() {
        int n = JOptionPane.showConfirmDialog(this, UpdateTool.messages.getString("UpdatePanel.confirm_backup_done"), "Firmware Update", 0);
        if (n == 1) {
            return;
        }
        this.outputStatus.setText("");
        this.inputPath.setEnabled(false);
        this.inputUseDefaultIp.setEnabled(false);
        this.choosePath.setEnabled(false);
        this.btnSubmit.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                final int n = Ep2UpdatePanel.this.controller.startUpdate(Ep2UpdatePanel.this.device, Ep2UpdatePanel.this.inputPath.getText(), Ep2UpdatePanel.this.inputUseDefaultIp.isSelected());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ep2UpdatePanel.this.updateFinished(n);
                    }
                });
            }
        }.start();
    }

    private void updateFinished(int n) {
        String string = "Unknown error";
        int n2 = 1;
        switch (n) {
            case 13: {
                short s = this.device.getLastDatagram().getBody().getPropertyShort("bPortSsh");
                string = UpdateTool.messages.getString("UpdatePanel.message.wrong_string").replace("%ssh_port%", Integer.toString(s));
                n2 = 0;
                break;
            }
            case 14: {
                string = UpdateTool.messages.getString("UpdatePanel.message.file_not_found").replace("%path%", this.inputPath.getText());
                n2 = 0;
                break;
            }
            case 11: {
                string = UpdateTool.messages.getString("UpdatePanel.message.success");
                n2 = 1;
            }
        }
        JOptionPane.showMessageDialog(this, string, UpdateTool.messages.getString("UpdatePanel.title"), n2);
    }

    public void setDevice(Device device) {
        if (device != null && this.device != null && this.device.equals(device)) {
            return;
        }
        this.device = device;
        boolean bl = device != null && device.isActive();
        this.choosePath.setEnabled(bl);
        this.inputPath.setEnabled(bl);
        boolean bl2 = true;
        if (bl) {
            try {
                bl2 = BootstrapInfo.compareToVersion(1, 1, device.getRescueVersion()) >= 0;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.inputUseDefaultIp.setEnabled(bl && bl2);
        this.inputUseDefaultIp.setSelected(true);
        this.btnSubmit.setEnabled(bl);
        this.progress.setValue(0);
        if (device != null) {
            this.checkFile(this.inputPath.getText());
        }
    }
}

