/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype.eis;

import de.babtec.globals.knx.datatype.DataType;
import java.nio.charset.Charset;

public class DT_Eis15
extends DataType<String> {
    public static final String DEFAULT_CODEPAGE = "CP1250";
    public static final int MAX_DATA_LENGTH = 15;
    public static Charset CODEPAGE = Charset.forName("CP1250");

    public DT_Eis15() {
        super(10000150, "EIS 15 (14 Byte Text)");
    }

    @Override
    public Double getDoubleValue(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    @Override
    public String getDataValue(Double d) {
        return d.toString();
    }

    @Override
    public boolean getMinEnabled() {
        return false;
    }

    @Override
    public boolean getMaxEnabled() {
        return false;
    }

    @Override
    public boolean getFormatEnabled() {
        return false;
    }

    @Override
    public String getMaxValue() {
        return "";
    }

    @Override
    public String getMinValue() {
        return "";
    }

    @Override
    public String getValueInRange(String string, double d, double d2) {
        return string.substring(0, Math.min(string.length(), 16));
    }

    @Override
    public String getValueInThisRange(String string, double d, double d2) {
        int n = string.length();
        while ((double)n < d) {
            string = string + " ";
            ++n;
        }
        return string.substring(0, (int)Math.min((double)string.length(), Math.min(d2, 16.0)));
    }

    @Override
    public boolean isInRange(String string, double d, double d2) {
        return string.length() <= 16;
    }

    @Override
    public boolean isInThisRange(String string, double d, double d2) {
        return (double)string.length() >= d && (double)string.length() <= d2;
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(String string) {
        byte[] byArray = new byte[Math.min(string.length(), 15)];
        byte[] byArray2 = string.getBytes(CODEPAGE);
        System.arraycopy(byArray2, 0, byArray, 0, Math.min(byArray2.length, byArray.length));
        return byArray;
    }

    @Override
    public byte[] getData(String string, double d, double d2) {
        return this.getData(string);
    }

    @Override
    public String getValue(byte[] byArray) {
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        return new String(byArray, 0, n, CODEPAGE);
    }

    @Override
    public String getValue(byte[] byArray, double d, double d2) {
        return this.getValue(byArray);
    }

    @Override
    public String getValueAsString(String string) {
        return string;
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%s";
    }

    @Override
    public String formatValue(String string, String string2) {
        return string;
    }

    @Override
    public String parseValue(String string) throws Exception {
        return string;
    }

    @Override
    public String parseValue(String string, String string2) throws Exception {
        return string;
    }

    @Override
    public int getBmxDataWidth() {
        return 15;
    }

    @Override
    public byte getBmxIndex() {
        return 12;
    }
}

