/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.knx.datatype.dpt;

import de.babtec.globals.knx.datatype.DataType;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DT_NonDpt_64
extends DataType<Long> {
    public static final long MIN_VALUE = Long.MIN_VALUE;
    public static final long MAX_VALUE = Long.MAX_VALUE;

    public DT_NonDpt_64() {
        super(600640001, "NON DPT 64 (8 Byte)");
    }

    @Override
    public Double getDoubleValue(Long l) {
        return l.doubleValue();
    }

    @Override
    public Long getDataValue(Double d) {
        return d.longValue();
    }

    @Override
    public Long getMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public Long getMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public Long getValueInRange(Long l, double d, double d2) {
        return super.getValueInRange(l, d, d2, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public boolean isInRange(Long l, double d, double d2) {
        return super.isInRange(l, d, d2, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public Long getValueInThisRange(Long l, double d, double d2) {
        int n = (int)(-9.223372036854776E18 < d ? d : -9.223372036854776E18);
        int n2 = (int)(9.223372036854776E18 > d2 ? d2 : 9.223372036854776E18);
        return l < (long)n ? (long)n : (l > (long)n2 ? (long)n2 : l);
    }

    @Override
    public boolean isInThisRange(Long l, double d, double d2) {
        return (double)l.longValue() >= Math.max(-9.223372036854776E18, d) && (double)l.longValue() <= Math.min(9.223372036854776E18, d2);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Long l) {
        return new byte[]{(byte)((l & 0xFF00000000000000L) >> 56), (byte)((l & 0xFF000000000000L) >> 48), (byte)((l & 0xFF0000000000L) >> 40), (byte)((l & 0xFF00000000L) >> 32), (byte)((l & 0xFF000000L) >> 24), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF00L) >> 8), (byte)(l & 0xFFL)};
    }

    @Override
    public byte[] getData(Long l, double d, double d2) {
        return this.getData((long)(((double)l.longValue() - d2) / d));
    }

    @Override
    public Long getValue(byte[] byArray) {
        long l = (long)byArray[7] & 0xFFL | ((long)byArray[6] & 0xFFL) << 8 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[0] & 0xFFL) << 56;
        return l;
    }

    @Override
    public Long getValue(byte[] byArray, double d, double d2) {
        return Double.valueOf((double)this.getValue(byArray).longValue() * d + d2).longValue();
    }

    @Override
    public String getValueAsString(Long l) {
        return l.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%ld";
    }

    @Override
    public String formatValue(Long l, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(l);
    }

    @Override
    public Long parseValue(String string) throws Exception {
        return Long.parseLong(string);
    }

    @Override
    public Long parseValue(String string, String string2) throws Exception {
        try {
            if (string2 != null) {
                return new DecimalFormat(string2).parse(string).longValue();
            }
        }
        catch (ParseException parseException) {
            return Long.parseLong(string);
        }
        return null;
    }

    @Override
    public int getBmxDataWidth() {
        return 12;
    }

    @Override
    public byte getBmxIndex() {
        return 0;
    }
}

