/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.babtec.globals.HexUtils;
import de.babtec.globals.jobdata.BMXBasicJobData;
import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.LibID;
import de.babtec.globals.jobdata.jobs.astrotimer.BMXAstroTimerModel;
import de.babtec.globals.jobdata.jobs.astrotimer.OutputPointInTime;
import de.babtec.globals.jobdata.jobs.astrotimer.PointInTime;
import de.babtec.globals.jobdata.jobs.dalimonitor.BMXDaliMonitor;
import de.babtec.globals.jobdata.jobs.logic.BMXLogicModel;
import de.babtec.globals.jobdata.jobs.scene.BMXScene;
import de.babtec.globals.jobdata.jobs.usender.Bfrule;
import de.babtec.globals.jobdata.jobs.usender.USenderModel;
import de.babtec.globals.jobdata.jobs.weektimer.BMXWeekTimer;
import de.babtec.globals.jobdata.jobs.weektimer.WeekTimerEvent;
import de.babtec.globals.jobdata.jobs.yeartimer.BMXYearTimer;
import de.babtec.globals.jobdata.json.JsonWrapper;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.knx.datatype.DataType;
import de.babtec.json.JsonUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class BMXJsonJobFactory {
    private static ArrayList<JsonWrapper> jsonWrappers = new ArrayList();
    private static Gson gson = new Gson();

    public static JsonObject libIdToJson(LibID libID) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("main", libID.getMain());
        jsonObject.addProperty("id", libID.getID());
        jsonObject.addProperty("version", libID.getVersion());
        return jsonObject;
    }

    public static LibID jsonToLibId(JsonObject jsonObject) {
        return new LibID(JsonUtils.getInt(jsonObject, "main", 0), JsonUtils.getInt(jsonObject, "id", 0), JsonUtils.getInt(jsonObject, "version", 0));
    }

    private static void addObj(JsonObject jsonObject, String string, EIBAddressObject2 eIBAddressObject2) {
        jsonObject.add(string, gson.toJsonTree(eIBAddressObject2 == null ? new int[]{} : eIBAddressObject2.getAddressObjectAsInteger()));
    }

    private static EIBAddressObject2 getObj(JsonObject jsonObject, String string) {
        try {
            return new EIBAddressObject2(gson.fromJson((JsonElement)jsonObject.getAsJsonArray(string), int[].class));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static JsonObject getJobListAsJsonObject(BMXBasicJobData[] bMXBasicJobDataArray) {
        if (bMXBasicJobDataArray == null) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("error", 1);
            jsonObject.addProperty("message", "got null as job list");
            return jsonObject;
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("job_list", jsonArray);
        for (int i = 0; i < bMXBasicJobDataArray.length; ++i) {
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.add("libID", BMXJsonJobFactory.libIdToJson(bMXBasicJobDataArray[i].getLibID()));
            jsonObject2.addProperty("name", bMXBasicJobDataArray[i].getName());
            jsonArray.add(jsonObject2);
        }
        return jsonObject;
    }

    public static JsonObject toJsonObject(BMXJobData bMXJobData) {
        if (bMXJobData == null) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("error", 1);
            jsonObject.addProperty("message", "got null as job data");
            return jsonObject;
        }
        for (JsonWrapper jsonWrapper : jsonWrappers) {
            if (!jsonWrapper.getLibID().equalsLibID(bMXJobData.getLibID())) continue;
            return jsonWrapper.getJsonObject(bMXJobData);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("error", 1);
        jsonObject.addProperty("message", "no wrapper for this type of job");
        return jsonObject;
    }

    public static BMXJobData updateJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
        LibID libID = BMXJsonJobFactory.jsonToLibId(jsonObject.getAsJsonObject("libID"));
        for (JsonWrapper jsonWrapper : jsonWrappers) {
            if (!jsonWrapper.getLibID().equalsLibID(libID)) continue;
            return jsonWrapper.getJobData(jsonObject, bMXJobData);
        }
        return null;
    }

    static {
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_WEEKTIMER){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                BMXWeekTimer bMXWeekTimer = new BMXWeekTimer(bMXJobData);
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonObject2 = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_WEEKTIMER);
                jsonObject2.addProperty("type", "WEEKTIMER");
                jsonObject.add("libID", jsonObject2);
                jsonObject.addProperty("name", bMXWeekTimer.getName());
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("initOnStart", bMXWeekTimer.isInitOnStart());
                jsonObject3.addProperty("initOnMod", bMXWeekTimer.isInitOnModification());
                jsonObject3.addProperty("preventOverride", bMXWeekTimer.isPreventOverride());
                jsonObject3.addProperty("handleTimeLapse", bMXWeekTimer.isHandleTimeLapse());
                JsonArray jsonArray = new JsonArray();
                for (WeekTimerEvent weekTimerEvent : bMXWeekTimer.getEvents()) {
                    JsonObject jsonObject4 = new JsonObject();
                    jsonObject4.addProperty("day", weekTimerEvent.getDay());
                    jsonObject4.addProperty("minute", weekTimerEvent.getMinute());
                    jsonObject4.addProperty("action", weekTimerEvent.getAction());
                    jsonArray.add(jsonObject4);
                }
                jsonObject3.add("events", jsonArray);
                jsonObject.add("parameter", jsonObject3);
                JsonObject jsonObject5 = new JsonObject();
                BMXJsonJobFactory.addObj(jsonObject5, "enable", bMXWeekTimer.getObjEnable());
                BMXJsonJobFactory.addObj(jsonObject5, "output", bMXWeekTimer.getObjOutput());
                jsonObject.add("comobj", jsonObject5);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                BMXWeekTimer bMXWeekTimer = new BMXWeekTimer();
                bMXWeekTimer.setName(JsonUtils.getString(jsonObject, "name", ""));
                JsonObject jsonObject2 = jsonObject.getAsJsonObject("parameter");
                bMXWeekTimer.setInitOnStart(JsonUtils.getBool(jsonObject2, "initOnStart", false));
                bMXWeekTimer.setInitOnModification(JsonUtils.getBool(jsonObject2, "initOnMod", false));
                bMXWeekTimer.setPreventOverride(JsonUtils.getBool(jsonObject2, "preventOverride", false));
                bMXWeekTimer.setHandleTimeLapse(JsonUtils.getBool(jsonObject2, "handleTimeLapse", false));
                JsonArray jsonArray = jsonObject2.getAsJsonArray("events");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject3 = jsonArray.get(i).getAsJsonObject();
                    bMXWeekTimer.addEvent(new WeekTimerEvent(JsonUtils.getInt(jsonObject3, "day", 0), JsonUtils.getInt(jsonObject3, "minute", 0), JsonUtils.getInt(jsonObject3, "action", 0)));
                }
                JsonObject jsonObject4 = jsonObject.getAsJsonObject("comobj");
                bMXWeekTimer.setObjEnable(BMXJsonJobFactory.getObj(jsonObject4, "enable"));
                bMXWeekTimer.setObjOutput(BMXJsonJobFactory.getObj(jsonObject4, "output"));
                return bMXWeekTimer.getJobData();
            }
        });
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_YEARTIMER){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                BMXYearTimer bMXYearTimer = new BMXYearTimer(bMXJobData);
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonObject2 = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_YEARTIMER);
                jsonObject2.addProperty("type", "YEARTIMER");
                jsonObject.add("libID", jsonObject2);
                jsonObject.addProperty("name", bMXYearTimer.getName());
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("initOnStart", bMXYearTimer.isInitOnStart());
                jsonObject3.addProperty("binary", bMXYearTimer.isBinary());
                jsonObject3.addProperty("preventOverride", bMXYearTimer.isPreventOverride());
                jsonObject3.addProperty("handleTimeLapse", bMXYearTimer.isHandleTimeLapse());
                jsonObject3.addProperty("data", HexUtils.bytesToHex(bMXYearTimer.getData()));
                jsonObject.add("parameter", jsonObject3);
                JsonObject jsonObject4 = new JsonObject();
                BMXJsonJobFactory.addObj(jsonObject4, "enable", bMXYearTimer.getObjEnable());
                BMXJsonJobFactory.addObj(jsonObject4, "output", bMXYearTimer.getObjOutput());
                jsonObject.add("comobj", jsonObject4);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                BMXYearTimer bMXYearTimer = new BMXYearTimer();
                bMXYearTimer.setName(JsonUtils.getString(jsonObject, "name", ""));
                JsonObject jsonObject2 = jsonObject.getAsJsonObject("parameter");
                bMXYearTimer.setInitOnStart(JsonUtils.getBool(jsonObject2, "initOnStart", false));
                bMXYearTimer.setBinary(JsonUtils.getBool(jsonObject2, "binary", true));
                bMXYearTimer.setPreventOverride(JsonUtils.getBool(jsonObject2, "preventOverride", false));
                bMXYearTimer.setHandleTimeLapse(JsonUtils.getBool(jsonObject2, "handleTimeLapse", false));
                bMXYearTimer.setData(HexUtils.hexToBytes(JsonUtils.getString(jsonObject2, "data", "")));
                JsonObject jsonObject3 = jsonObject.getAsJsonObject("comobj");
                bMXYearTimer.setObjEnable(BMXJsonJobFactory.getObj(jsonObject3, "enable"));
                bMXYearTimer.setObjOutput(BMXJsonJobFactory.getObj(jsonObject3, "output"));
                return bMXYearTimer.getJobData();
            }
        });
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_SCENE){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                BMXScene bMXScene = new BMXScene(bMXJobData);
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonObject2 = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_SCENE);
                jsonObject2.addProperty("type", "SCENE");
                jsonObject.add("libID", jsonObject2);
                jsonObject.addProperty("name", bMXScene.getName());
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("startValue", bMXScene.getStartValue());
                jsonObject3.addProperty("saveValue", bMXScene.getSaveValue());
                jsonObject3.addProperty("stoppable", bMXScene.isStoppable());
                jsonObject3.addProperty("delay", bMXScene.getDelay());
                jsonObject.add("parameter", jsonObject3);
                JsonArray jsonArray = new JsonArray();
                for (int i = 0; i < bMXScene.getOutputCount(); ++i) {
                    JsonObject jsonObject4 = new JsonObject();
                    BMXJsonJobFactory.addObj(jsonObject4, "comobj", bMXScene.getOutputGA(i));
                    jsonObject4.addProperty("datatype", bMXScene.getOutputDataType(i).getTypeIndex());
                    double d = bMXScene.getOutputValue(i);
                    if (Double.isNaN(d)) {
                        jsonObject4.addProperty("value", "NaN");
                    } else {
                        jsonObject4.addProperty("value", d);
                    }
                    jsonArray.add(jsonObject4);
                }
                jsonObject.add("outputs", jsonArray);
                JsonObject jsonObject5 = new JsonObject();
                BMXJsonJobFactory.addObj(jsonObject5, "enable", bMXScene.getObjEnable());
                BMXJsonJobFactory.addObj(jsonObject5, "start", bMXScene.getObjStart());
                BMXJsonJobFactory.addObj(jsonObject5, "save", bMXScene.getObjSave());
                jsonObject.add("comobj", jsonObject5);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                BMXScene bMXScene = new BMXScene();
                bMXScene.setName(JsonUtils.getString(jsonObject, "name", ""));
                JsonObject jsonObject2 = jsonObject.getAsJsonObject("parameter");
                bMXScene.setStartValue(JsonUtils.getInt(jsonObject2, "startValue", 1));
                bMXScene.setSaveValue(JsonUtils.getInt(jsonObject2, "saveValue", 1));
                bMXScene.setStoppable(JsonUtils.getBool(jsonObject2, "stoppable", false));
                bMXScene.setDelay(JsonUtils.getInt(jsonObject2, "delay", 1));
                JsonObject jsonObject3 = jsonObject.getAsJsonObject("comobj");
                bMXScene.setObjEnable(BMXJsonJobFactory.getObj(jsonObject3, "enable"));
                bMXScene.setObjStart(BMXJsonJobFactory.getObj(jsonObject3, "start"));
                bMXScene.setObjSave(BMXJsonJobFactory.getObj(jsonObject3, "save"));
                JsonArray jsonArray = jsonObject.getAsJsonArray("outputs");
                bMXScene.setOutputCount(jsonArray.size());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject4 = jsonArray.get(i).getAsJsonObject();
                    bMXScene.setOutputGA(i, BMXJsonJobFactory.getObj(jsonObject4, "comobj"));
                    bMXScene.setOutputDataType(i, DataType.getDataType(JsonUtils.getInt(jsonObject4, "datatype", 10000010)));
                    bMXScene.setOutputValue(i, JsonUtils.getDouble(jsonObject4, "value", 0.0));
                }
                return bMXScene.getJobData();
            }
        });
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_DALI_MONITOR){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                BMXDaliMonitor bMXDaliMonitor = new BMXDaliMonitor(bMXJobData);
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonObject2 = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_DALI_MONITOR);
                jsonObject2.addProperty("type", "DALI_MONITOR");
                jsonObject.add("libID", jsonObject2);
                jsonObject.addProperty("name", bMXDaliMonitor.getName());
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("delayStatusFeedback", bMXDaliMonitor.getDelayStatusFeedback());
                jsonObject3.addProperty("requestInterval", bMXDaliMonitor.getRequestInterval());
                jsonObject3.addProperty("outAvailable", HexUtils.bytesToHex(HexUtils.getBytes((Long)bMXDaliMonitor.getOutAvailable(), 8)));
                jsonObject3.add("outTitle", new Gson().toJsonTree(bMXDaliMonitor.getOutTitles(), (Type)((Object)String[].class)));
                jsonObject.add("parameter", jsonObject3);
                JsonObject jsonObject4 = new JsonObject();
                BMXJsonJobFactory.addObj(jsonObject4, "enable", bMXDaliMonitor.getObjEnable());
                BMXJsonJobFactory.addObj(jsonObject4, "checkAll", bMXDaliMonitor.getObjStartCheckAll());
                BMXJsonJobFactory.addObj(jsonObject4, "checkOne", bMXDaliMonitor.getObjStartCheckOne());
                BMXJsonJobFactory.addObj(jsonObject4, "currentCheckIndex", bMXDaliMonitor.getObjCurrentCheckIndex());
                BMXJsonJobFactory.addObj(jsonObject4, "responseBallast", bMXDaliMonitor.getObjResponseBallast());
                BMXJsonJobFactory.addObj(jsonObject4, "responseLamp", bMXDaliMonitor.getObjResponseLamp());
                BMXJsonJobFactory.addObj(jsonObject4, "stateBallast", bMXDaliMonitor.getObjStateBallast());
                BMXJsonJobFactory.addObj(jsonObject4, "stateLamp", bMXDaliMonitor.getObjStateLamp());
                BMXJsonJobFactory.addObj(jsonObject4, "defectOut", bMXDaliMonitor.getObjDefectOut());
                jsonObject.add("comobj", jsonObject4);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                System.err.println("Job DaliMonitor is not supported to be changed via servlet.");
                return null;
            }
        });
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_LOGIC){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                BMXLogicModel bMXLogicModel = new BMXLogicModel(bMXJobData);
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonObject2 = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_LOGIC);
                jsonObject2.addProperty("type", "LOGIC");
                jsonObject.add("libID", jsonObject2);
                jsonObject.addProperty("name", bMXLogicModel.getName());
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("operation", bMXLogicModel.getOperation());
                jsonObject3.addProperty("send", bMXLogicModel.getSend());
                jsonObject3.addProperty("filter", bMXLogicModel.getFilter());
                jsonObject.add("parameter", jsonObject3);
                JsonObject jsonObject4 = new JsonObject();
                BMXJsonJobFactory.addObj(jsonObject4, "enable", bMXLogicModel.getObjectEnable());
                BMXJsonJobFactory.addObj(jsonObject4, "output", bMXLogicModel.getObjectOutput());
                JsonArray jsonArray = new JsonArray();
                for (EIBAddressObject2 eIBAddressObject2 : bMXLogicModel.getInputs()) {
                    jsonArray.add(gson.toJsonTree(eIBAddressObject2 == null ? new int[]{} : eIBAddressObject2.getAddressObjectAsInteger()));
                }
                jsonObject4.add("inputs", jsonArray);
                jsonObject.add("comobj", jsonObject4);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                System.err.println("Job Logic is not supported to be changed via servlet.");
                return null;
            }
        });
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_SBCONTROLLER){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonObject2 = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_SBCONTROLLER);
                jsonObject2.addProperty("type", "SBCONTROLLER");
                jsonObject.add("libID", jsonObject2);
                jsonObject.addProperty("name", bMXJobData.getName());
                JsonObject jsonObject3 = new JsonObject();
                String string = new String(bMXJobData.getParam(), 3, 16).trim();
                jsonObject3.addProperty("xpl_name", string);
                jsonObject.add("parameter", jsonObject3);
                JsonObject jsonObject4 = new JsonObject();
                BMXJsonJobFactory.addObj(jsonObject4, "enable", bMXJobData.getEIBAddressObject2(0));
                BMXJsonJobFactory.addObj(jsonObject4, "play_pause", bMXJobData.getEIBAddressObject2(9));
                BMXJsonJobFactory.addObj(jsonObject4, "volume_step", bMXJobData.getEIBAddressObject2(4));
                BMXJsonJobFactory.addObj(jsonObject4, "volume_dim", bMXJobData.getEIBAddressObject2(3));
                BMXJsonJobFactory.addObj(jsonObject4, "volume_abs", bMXJobData.getEIBAddressObject2(12));
                BMXJsonJobFactory.addObj(jsonObject4, "volume_fb", bMXJobData.getEIBAddressObject2(11));
                BMXJsonJobFactory.addObj(jsonObject4, "mute", bMXJobData.getEIBAddressObject2(10));
                BMXJsonJobFactory.addObj(jsonObject4, "pl_skip", bMXJobData.getEIBAddressObject2(1));
                BMXJsonJobFactory.addObj(jsonObject4, "track_skip", bMXJobData.getEIBAddressObject2(2));
                BMXJsonJobFactory.addObj(jsonObject4, "info_title", bMXJobData.getEIBAddressObject2(23));
                BMXJsonJobFactory.addObj(jsonObject4, "info_album", bMXJobData.getEIBAddressObject2(24));
                BMXJsonJobFactory.addObj(jsonObject4, "info_artist", bMXJobData.getEIBAddressObject2(25));
                BMXJsonJobFactory.addObj(jsonObject4, "info_playlist", bMXJobData.getEIBAddressObject2(18));
                BMXJsonJobFactory.addObj(jsonObject4, "pl_select_0", bMXJobData.getEIBAddressObject2(19));
                BMXJsonJobFactory.addObj(jsonObject4, "pl_select_1", bMXJobData.getEIBAddressObject2(20));
                BMXJsonJobFactory.addObj(jsonObject4, "pl_select_2", bMXJobData.getEIBAddressObject2(21));
                BMXJsonJobFactory.addObj(jsonObject4, "pl_select_3", bMXJobData.getEIBAddressObject2(22));
                BMXJsonJobFactory.addObj(jsonObject4, "pl_select_scroll", bMXJobData.getEIBAddressObject2(5));
                BMXJsonJobFactory.addObj(jsonObject4, "pl_select_index", bMXJobData.getEIBAddressObject2(6));
                jsonObject.add("comobj", jsonObject4);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                System.err.println("Job SBController is not supported to be changed via servlet.");
                return null;
            }
        });
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_ASTROTIMER){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                Object object;
                BMXAstroTimerModel bMXAstroTimerModel = new BMXAstroTimerModel(bMXJobData);
                boolean[] blArray = new boolean[8];
                for (int i = 0; i < bMXAstroTimerModel.getOutputCount(); ++i) {
                    object = bMXAstroTimerModel.getOutput(i);
                    if (((OutputPointInTime)object).getPit_weekdays() != -1) {
                        blArray[((OutputPointInTime)object).getPit_weekdays()] = true;
                    }
                    if (((OutputPointInTime)object).getPit_saturday() != -1) {
                        blArray[((OutputPointInTime)object).getPit_saturday()] = true;
                    }
                    if (((OutputPointInTime)object).getPit_sunday() != -1) {
                        blArray[((OutputPointInTime)object).getPit_sunday()] = true;
                    }
                    if (((OutputPointInTime)object).getPit_extra1() != -1) {
                        blArray[((OutputPointInTime)object).getPit_extra1()] = true;
                    }
                    if (((OutputPointInTime)object).getPit_extra2() != -1) {
                        blArray[((OutputPointInTime)object).getPit_extra2()] = true;
                    }
                    if (((OutputPointInTime)object).getPit_extra3() == -1) continue;
                    blArray[((OutputPointInTime)object).getPit_extra3()] = true;
                }
                JsonObject jsonObject = new JsonObject();
                object = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_ASTROTIMER);
                ((JsonObject)object).addProperty("type", "ASTRO_TIMER");
                jsonObject.add("libID", (JsonElement)object);
                jsonObject.addProperty("name", bMXJobData.getName());
                JsonObject jsonObject2 = new JsonObject();
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("simple", bMXAstroTimerModel.getConfigurationSimple());
                jsonObject2.add("flags", jsonObject3);
                jsonObject2.addProperty("latitude", Float.valueOf(bMXAstroTimerModel.getLatitude()));
                jsonObject2.addProperty("longitude", Float.valueOf(bMXAstroTimerModel.getLongitude()));
                jsonObject2.addProperty("timezone", bMXAstroTimerModel.getTimezone());
                JsonArray jsonArray = new JsonArray();
                for (int i = 0; i < bMXAstroTimerModel.getPointInTime().length; ++i) {
                    PointInTime pointInTime = bMXAstroTimerModel.getPointInTime()[i];
                    JsonObject jsonObject4 = new JsonObject();
                    jsonObject4.addProperty("index", i);
                    jsonObject4.addProperty("used", blArray[i]);
                    jsonObject4.addProperty("description", pointInTime.getDescription());
                    jsonObject4.addProperty("source", pointInTime.getSrc());
                    jsonObject4.addProperty("height", pointInTime.getHeight());
                    jsonObject4.addProperty("earliestActive", pointInTime.isEarliestActive());
                    jsonObject4.addProperty("earliestHour", pointInTime.getEarliest_hour());
                    jsonObject4.addProperty("earliestMinute", pointInTime.getEarliest_min());
                    jsonObject4.addProperty("latestActive", pointInTime.isLatestActive());
                    jsonObject4.addProperty("latestHour", pointInTime.getLatest_hour());
                    jsonObject4.addProperty("latestMinute", pointInTime.getLatest_min());
                    jsonObject4.addProperty("offsetRandom", pointInTime.getRandom_offset());
                    jsonObject4.addProperty("offsetStatic", pointInTime.getStatic_offset());
                    jsonArray.add(jsonObject4);
                }
                jsonObject2.add("pointInTime", jsonArray);
                jsonObject.add("parameter", jsonObject2);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                BMXAstroTimerModel bMXAstroTimerModel = new BMXAstroTimerModel(bMXJobData);
                JsonObject jsonObject2 = jsonObject.getAsJsonObject("parameter");
                JsonObject jsonObject3 = jsonObject2.getAsJsonObject("flags");
                JsonArray jsonArray = jsonObject2.getAsJsonArray("pointInTime");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject4 = jsonArray.get(i).getAsJsonObject();
                    int n = jsonObject4.get("index").getAsInt();
                    PointInTime pointInTime = bMXAstroTimerModel.getPointInTime()[n];
                    pointInTime.setHeight(jsonObject4.get("height").getAsShort());
                    pointInTime.setEarliestActive(jsonObject4.get("earliestActive").getAsBoolean());
                    pointInTime.setEarliest_hour(jsonObject4.get("earliestHour").getAsByte());
                    pointInTime.setEarliest_min(jsonObject4.get("earliestMinute").getAsByte());
                    pointInTime.setLatestActive(jsonObject4.get("latestActive").getAsBoolean());
                    pointInTime.setLatest_hour(jsonObject4.get("latestHour").getAsByte());
                    pointInTime.setLatest_min(jsonObject4.get("latestMinute").getAsByte());
                    pointInTime.setRandom_offset(jsonObject4.get("offsetRandom").getAsInt());
                    pointInTime.setStatic_offset(jsonObject4.get("offsetStatic").getAsShort());
                }
                return bMXAstroTimerModel.getJobData();
            }
        });
        jsonWrappers.add(new JsonWrapper(BMXJobList.LIBID_USENDER){

            @Override
            public JsonObject getJsonObject(BMXJobData bMXJobData) {
                USenderModel uSenderModel = new USenderModel(bMXJobData);
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonObject2 = BMXJsonJobFactory.libIdToJson(BMXJobList.LIBID_USENDER);
                jsonObject2.addProperty("type", "USENDER");
                jsonObject.add("libID", jsonObject2);
                jsonObject.addProperty("name", uSenderModel.getName());
                JsonObject jsonObject3 = new JsonObject();
                jsonObject3.addProperty("resolveAlways", uSenderModel.isResolveAlways());
                jsonObject3.addProperty("resolveHost", uSenderModel.isResolveHost());
                jsonObject3.addProperty("allowLoopbacks", uSenderModel.isAllowLoopbacks());
                jsonObject3.addProperty("host", uSenderModel.getHost());
                jsonObject3.addProperty("port", uSenderModel.getPort());
                jsonObject3.addProperty("systemId", uSenderModel.getTargetSystemId());
                JsonArray jsonArray = new JsonArray();
                for (int i = 0; i < 10; ++i) {
                    Bfrule bfrule = uSenderModel.getBfrule(i);
                    JsonObject jsonObject4 = new JsonObject();
                    jsonObject4.addProperty("recv", bfrule.getPresentation("recv"));
                    jsonObject4.addProperty("repl", bfrule.getPresentation("repl"));
                    jsonArray.add(jsonObject4);
                }
                jsonObject3.add("rules", jsonArray);
                jsonObject.add("parameter", jsonObject3);
                JsonObject jsonObject5 = new JsonObject();
                BMXJsonJobFactory.addObj(jsonObject5, "enable", uSenderModel.getObjEnable());
                jsonObject.add("comobj", jsonObject5);
                return jsonObject;
            }

            @Override
            public BMXJobData getJobData(JsonObject jsonObject, BMXJobData bMXJobData) {
                USenderModel uSenderModel = new USenderModel();
                uSenderModel.setName(jsonObject.get("name").getAsString());
                JsonObject jsonObject2 = jsonObject.get("parameter").getAsJsonObject();
                uSenderModel.setHost(jsonObject2.get("host").getAsString());
                uSenderModel.setPort(jsonObject2.get("port").getAsInt());
                uSenderModel.setTargetSystemId(jsonObject2.get("systemId").getAsInt());
                uSenderModel.setResolveHost(jsonObject2.get("resolveHost").getAsBoolean());
                uSenderModel.setResolveAlways(jsonObject2.get("resolveAlways").getAsBoolean());
                uSenderModel.setAllowLoopbacks(jsonObject2.get("allowLoopbacks").getAsBoolean());
                JsonArray jsonArray = jsonObject2.get("rules").getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject3 = jsonArray.get(i).getAsJsonObject();
                    try {
                        uSenderModel.getBfrule(i).parsePresentation(jsonObject3.get("recv").getAsString(), jsonObject3.get("repl").getAsString());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return uSenderModel.getJobData();
            }
        });
    }
}

