/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.urecv;

import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class URecvMatchModel {
    private int eis;
    private byte flags;
    private byte matchmode;
    private byte eis1val;
    private byte sub;
    private byte scroll_mode = 0;
    private byte scroll_speed = 0;
    private int scroll_nr = 0;
    private byte bytevalue;
    private int shortvalue;
    private long intvalue;
    private float floatvalue;

    public Integer getEis() {
        return new Integer(this.eis);
    }

    public void setEis(int n) {
        this.eis = n;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte by) {
        this.flags = by;
        this.eis = (byte)(this.flags & 0x1F);
        this.matchmode = (byte)((~this.flags & 0x80) >> 7);
        this.eis1val = (byte)((this.flags & 0x60) >> 5);
    }

    public void setFlags(byte by, byte by2, byte by3) {
        this.flags = (byte)(by | by2 << 5);
        this.flags = (byte)(this.flags | by3 << 7);
        this.eis = by;
        this.matchmode = by3;
        this.eis1val = by2;
    }

    public byte getMatchMode() {
        return this.matchmode;
    }

    public byte getEis1Val() {
        return this.eis1val;
    }

    public byte getSub() {
        return this.sub;
    }

    public void setSub(byte by) {
        this.sub = by;
    }

    public byte getScroll_Mode() {
        return this.scroll_mode;
    }

    public void setScroll_Mode(byte by) {
        this.scroll_mode = by;
    }

    public byte getScroll_Speed() {
        return this.scroll_speed;
    }

    public void setScroll_Speed(byte by) {
        this.scroll_speed = by;
    }

    public int getScroll_Nr() {
        return this.scroll_nr;
    }

    public void setScroll_Nr(int n) {
        this.scroll_nr = n;
    }

    public byte getByteValue() {
        return this.bytevalue;
    }

    public byte[] getShortValue() {
        return ByteConv.short2byte(this.shortvalue);
    }

    public byte[] getIntValue() {
        return ByteConv.long2byte64(this.intvalue);
    }

    public byte[] getFloatValue() {
        return ByteConv.float2byte(this.floatvalue);
    }

    public void setByteValue(byte by) {
        this.bytevalue = by;
    }

    public void setShortValue(int n) {
        this.shortvalue = n;
    }

    public void setIntValue(long l) {
        this.intvalue = l;
    }

    public void setFloatValue(float f) {
        this.floatvalue = f;
    }

    public int setBMXJobData(byte[] byArray, int n) {
        int n2 = n;
        this.setFlags(byArray[n2++]);
        this.setSub(byArray[n2++]);
        this.setScroll_Mode(byArray[n2++]);
        this.setScroll_Speed(byArray[n2++]);
        this.setScroll_Nr(ByteConv.byte2short(byArray, n2));
        n2 += 2;
        switch (this.eis) {
            case 0: 
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.setByteValue(byArray[n2]);
                break;
            }
            case 4: 
            case 8: {
                this.setFloatValue(ByteConv.byte2float(byArray, n2));
                break;
            }
            case 6: {
                this.setShortValue(ByteConv.byte2short(byArray, n2));
                break;
            }
            case 7: {
                this.setIntValue(new Long(ByteConv.byte2reallong(byArray, n2)));
            }
        }
        return (n2 += 4) - n;
    }

    public void getJobData(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            int n = 3;
            byteArrayOutputStream.write(this.getFlags());
            byteArrayOutputStream.write(this.getSub());
            byteArrayOutputStream.write(this.getScroll_Mode());
            byteArrayOutputStream.write(this.getScroll_Speed());
            byteArrayOutputStream.write(ByteConv.short2byte(this.getScroll_Nr()));
            switch (this.eis) {
                case 0: 
                case 1: 
                case 3: {
                    n = 4;
                    byteArrayOutputStream.write(new byte[n]);
                    break;
                }
                case 2: 
                case 5: {
                    n = 3;
                    byteArrayOutputStream.write(this.getByteValue());
                    byteArrayOutputStream.write(new byte[n]);
                    break;
                }
                case 4: 
                case 8: {
                    byteArrayOutputStream.write(this.getFloatValue());
                    break;
                }
                case 6: {
                    byteArrayOutputStream.write(this.getShortValue());
                    n = 2;
                    byteArrayOutputStream.write(new byte[n]);
                    break;
                }
                case 7: {
                    byte[] byArray = new byte[4];
                    System.arraycopy(this.getIntValue(), 0, byArray, 0, 4);
                    byteArrayOutputStream.write(byArray);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

