/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.urecv;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.urecv.URecvBinaryPatternModel;
import de.babtec.globals.jobdata.jobs.urecv.URecvMatchModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public class BMXURecvModel
extends BMXJobModel {
    public static final int JOBS_URECV_MAX_MATCHES = 16;
    public static final int JOBS_URECV_MAX_PATTERN_LEN = 800;
    public static final int JOBS_URECV_STD_PORT = 1742;
    public static final byte JOBS_URECV_PRESEN_UNIVERSAL_PCRE = 4;
    public static final byte JOBS_URECV_PRESEN_UNIVERSAL_BINARY = 5;
    public static final int PCRE_CASELESS = 1;
    public static final int PCRE_MULTILINE = 2;
    public static final int PCRE_DOTALL = 4;
    public static final int PCRE_EXTENDED = 8;
    public static final int PCRE_ANCHORED = 16;
    public static final int PCRE_DOLLAR_ENDONLY = 32;
    public static final int PCRE_EXTRA = 64;
    public static final int PCRE_NOTBOL = 128;
    public static final int PCRE_NOTEOL = 256;
    public static final int PCRE_UNGREEDY = 512;
    public static final int PCRE_NOTEMPTY = 1024;
    public static final int PCRE_UTF8 = 2048;
    public static final int PCRE_NO_AUTO_CAPTURE = 4096;
    public static final int PCRE_NO_UTF8_CHECK = 8192;
    public static final int PCRE_AUTO_CALLOUT = 16384;
    public static final int PCRE_PARTIAL_SOFT = 32768;
    public static final int PCRE_PARTIAL = 32768;
    public static final int PCRE_DFA_SHORTEST = 65536;
    public static final int PCRE_DFA_RESTART = 131072;
    public static final int PCRE_FIRSTLINE = 262144;
    public static final int PCRE_DUPNAMES = 524288;
    public static final int PCRE_NEWLINE_CR = 0x100000;
    public static final int PCRE_NEWLINE_LF = 0x200000;
    public static final int PCRE_NEWLINE_CRLF = 0x300000;
    public static final int PCRE_NEWLINE_ANY = 0x400000;
    public static final int PCRE_NEWLINE_ANYCRLF = 0x500000;
    public static final int PCRE_BSR_ANYCRLF = 0x800000;
    public static final int PCRE_BSR_UNICODE = 0x1000000;
    public static final int PCRE_JAVASCRIPT_COMPAT = 0x2000000;
    public static final int PCRE_NO_START_OPTIMIZE = 0x4000000;
    public static final int PCRE_NO_START_OPTIMISE = 0x4000000;
    public static final int PCRE_PARTIAL_HARD = 0x8000000;
    public static final int PCRE_NOTEMPTY_ATSTART = 0x10000000;
    public static final int PCRE_UCP = 0x20000000;
    private byte flags;
    private byte presentation;
    private int port;
    private String pattern;
    private int compile_flags;
    private int exec_flags;
    private byte match_count;
    private URecvMatchModel[] match = new URecvMatchModel[16];
    private URecvBinaryPatternModel[] binary_pattern = new URecvBinaryPatternModel[16];
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2[] objOutput = new EIBAddressObject2[16];

    public BMXURecvModel(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXURecvModel() {
        for (int i = 0; i < 16; ++i) {
            this.match[i] = new URecvMatchModel();
            this.binary_pattern[i] = new URecvBinaryPatternModel();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        byte[] byArray2 = new byte[800];
        int n2 = 0;
        this.flags = byArray[n2++];
        this.presentation = byArray[n2++];
        this.port = ByteConv.byte2short(byArray, n2);
        n2 += 2;
        if (this.presentation == 4) {
            System.arraycopy(byArray, n2, byArray2, 0, 800);
            n2 += 800;
        }
        if (this.presentation == 5) {
            for (n = 0; n < 16; ++n) {
                n2 += this.binary_pattern[n].setBMXJobData(byArray, n2);
            }
            n2 += 704;
        }
        this.compile_flags = ByteConv.byte2long(byArray, n2);
        this.exec_flags = ByteConv.byte2long(byArray, n2 += 4);
        n2 += 4;
        this.match_count = byArray[n2++];
        for (n = 0; n < 16; ++n) {
            n2 += this.match[n].setBMXJobData(byArray, n2);
        }
        n2 += 8;
        this.pattern = this.getCompileFlag(2048) ? new String(byArray2, Charset.forName("UTF-8")) : new String(byArray2, Charset.forName("ISO-8859-1"));
        this.pattern = this.pattern.replaceAll("\u0000.*", "");
        n = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n++);
        for (int i = 0; i < 16; ++i) {
            this.objOutput[i] = bMXJobData.getEIBAddressObject2(n++);
        }
    }

    @Override
    public BMXJobData getJobData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byteArrayOutputStream.write(this.flags);
            byteArrayOutputStream.write(this.presentation);
            byteArrayOutputStream.write(ByteConv.short2byte(this.port));
            if (this.presentation == 4) {
                try {
                    byte[] byArray = ByteConv.string2byteFixedLen(this.pattern, 800, this.getCompileFlag(2048));
                    byteArrayOutputStream.write(byArray);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
            }
            if (this.presentation == 5) {
                int n2;
                for (n2 = 0; n2 < 16; ++n2) {
                    this.binary_pattern[n2].getJobData(byteArrayOutputStream);
                }
                n2 = 704;
                byteArrayOutputStream.write(new byte[n2]);
            }
            byteArrayOutputStream.write(ByteConv.long2byte(this.compile_flags));
            byteArrayOutputStream.write(ByteConv.long2byte(this.exec_flags));
            byteArrayOutputStream.write(this.match_count);
            for (n = 0; n < 16; ++n) {
                this.match[n].getJobData(byteArrayOutputStream);
            }
            n = 8;
            byteArrayOutputStream.write(new byte[n]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_URECV, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        for (int i = 0; i < 16; ++i) {
            bMXJobData.addEIBAddressObject2(this.objOutput[i]);
        }
        return bMXJobData;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public boolean getCompileFlag(int n) {
        return (this.compile_flags & n) != 0;
    }

    public void setCompileFlag(int n, boolean bl) {
        this.compile_flags = bl ? (this.compile_flags |= n) : (this.compile_flags &= ~n);
    }

    public boolean getExecFlag(int n) {
        return (this.exec_flags & n) != 0;
    }

    public void setExecFlag(int n, boolean bl) {
        this.exec_flags = bl ? (this.exec_flags |= n) : (this.exec_flags &= ~n);
    }

    public URecvMatchModel[] getMatches() {
        return this.match;
    }

    public ArrayList<URecvBinaryPatternModel> getBinaryPatterns() {
        return new ArrayList<URecvBinaryPatternModel>(Arrays.asList(this.binary_pattern));
    }

    public void setMatch(URecvMatchModel[] uRecvMatchModelArray) {
        this.match = uRecvMatchModelArray;
    }

    public byte getMatchCount() {
        return this.match_count;
    }

    public void setMatchCount(byte by) {
        this.match_count = by;
    }

    public byte getPresentation() {
        return this.presentation;
    }

    public void setPresentation(byte by) {
        this.presentation = by;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setPattern(ArrayList<URecvBinaryPatternModel> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < 16; ++i) {
            this.binary_pattern[i] = i >= n ? new URecvBinaryPatternModel() : arrayList.get(i);
        }
    }

    public long getCompile_flags() {
        return this.compile_flags;
    }

    public void setCompile_flags(int n) {
        this.compile_flags = n;
    }

    public long getExec_flags() {
        return this.exec_flags;
    }

    public void setExec_flags(int n) {
        this.exec_flags = n;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objOutput = eIBAddressObject2Array;
    }
}

