/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.smsrecv;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.jobdata.jobs.smsrecv.BMXSmsReceiverPattern;
import de.babtec.globals.jobdata.jobs.smssnd.BMXGSMPhone;
import de.babtec.globals.knx.address.EIBAddressObject2;
import java.io.ByteArrayOutputStream;

public class BMXSmsReceiverModel
extends BMXJobModel {
    public static final int JOBS_SMSR_VERSION = 1;
    public static final int JOBS_SMSR_RESERVED_BYTES_IN_V1 = 256;
    public static final int JOBS_SMSR_RESERVED_EOS_IN_V1 = 4;
    public static final int JOBS_SMSR_MAX_PHONES = 8;
    public static final int JOBS_SMSR_MAX_PATTERNS = 16;
    public static final int JOBS_SMSR_FLAG_ACCEPT_ALL_PHONES = 1;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2[] objPattern = new EIBAddressObject2[16];
    private EIBAddressObject2[] objPhoneEnable = new EIBAddressObject2[8];
    private EIBAddressObject2[] objReserved = new EIBAddressObject2[4];
    private int version;
    private int flags;
    private BMXGSMPhone[] phones = new BMXGSMPhone[8];
    private BMXSmsReceiverPattern[] pattern = new BMXSmsReceiverPattern[16];

    public BMXSmsReceiverModel(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXSmsReceiverModel() {
        int n;
        for (n = 0; n < this.phones.length; ++n) {
            this.phones[n] = new BMXGSMPhone();
        }
        for (n = 0; n < this.pattern.length; ++n) {
            this.pattern[n] = new BMXSmsReceiverPattern();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.version = byArray[n2++] & 0xFF;
        this.flags = byArray[n2++] & 0xFF;
        for (n = 0; n < this.phones.length; ++n) {
            n2 += this.phones[n].setBMXJobData(byArray, n2);
        }
        for (n = 0; n < this.pattern.length; ++n) {
            n2 += this.pattern[n].setBMXJobData(byArray, n2);
        }
        n2 = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n2++);
        for (n = 0; n < 16; ++n) {
            this.objPattern[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        for (n = 0; n < 8; ++n) {
            this.objPhoneEnable[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        for (n = 0; n < 4; ++n) {
            this.objReserved[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        for (n2 = 0; n2 < this.phones.length; ++n2) {
            if (!this.phones[n2].getFlag(4)) continue;
            bl = false;
            break;
        }
        this.setFlag(1, bl);
        try {
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(this.flags);
            n2 = byteArrayOutputStream.size();
            for (n = 0; n < this.phones.length; ++n) {
                this.phones[n].getJobData(byteArrayOutputStream);
            }
            n2 = byteArrayOutputStream.size();
            for (n = 0; n < this.pattern.length; ++n) {
                this.pattern[n].getJobData(byteArrayOutputStream);
            }
            byteArrayOutputStream.write(new byte[256]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_SMS_RECEIVER, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        for (n = 0; n < 16; ++n) {
            bMXJobData.addEIBAddressObject2(this.objPattern[n]);
        }
        for (n = 0; n < 8; ++n) {
            bMXJobData.addEIBAddressObject2(this.objPhoneEnable[n]);
        }
        for (n = 0; n < 4; ++n) {
            bMXJobData.addEIBAddressObject2(this.objReserved[n]);
        }
        return bMXJobData;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        this.flags &= ~n;
        if (bl) {
            this.flags |= n;
        }
    }

    public BMXGSMPhone getPhones(int n) {
        return this.phones[n];
    }

    public void setPhones(int n, BMXGSMPhone bMXGSMPhone) {
        this.phones[n] = bMXGSMPhone;
    }

    public BMXSmsReceiverPattern getPattern(int n) {
        return this.pattern[n];
    }

    public void setPattern(int n, BMXSmsReceiverPattern bMXSmsReceiverPattern) {
        this.pattern[n] = bMXSmsReceiverPattern;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjPattern(int n) {
        return this.objPattern[n];
    }

    public void setObjPattern(int n, EIBAddressObject2 eIBAddressObject2) {
        this.objPattern[n] = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjPhones(int n) {
        return this.objPhoneEnable[n];
    }

    public void setObjPhones(int n, EIBAddressObject2 eIBAddressObject2) {
        this.objPhoneEnable[n] = eIBAddressObject2;
    }
}

