/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs.pulsecounter;

import de.babtec.globals.jobdata.BMXJobData;
import de.babtec.globals.jobdata.BMXJobList;
import de.babtec.globals.jobdata.jobs.BMXJobModel;
import de.babtec.globals.knx.address.EIBAddressObject2;
import de.babtec.globals.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXPulseCounter
extends BMXJobModel {
    public static final int JOBS_PCOUNTER_ACTUAL_VERSION = 1;
    public static final int JOBS_PCOUNTER_VERSION1_JOB_RESERVED = 128;
    public static final int JOBS_PCOUNTER_VERSION1_EOS_RESERVED = 8;
    public static final int JOBS_PCOUNTER_OBMAX = 14;
    public static final int JOBS_PCOUNTER_FLAGS_ALLOW_SET_MAIN = 1;
    public static final int JOBS_COUNTER_FLAGS_ALL = 1;
    public static final int JOBS_PCOUNTER_TRIGGER_MAIN_PERIODIC = 1;
    public static final int JOBS_PCOUNTER_TRIGGER_TRIP_PERIODIC = 2;
    public static final int JOBS_PCOUNTER_TRIGGER_MAIN_CHANGE = 4;
    public static final int JOBS_PCOUNTER_TRIGGER_TRIP_CHANGE = 8;
    public static final int JOBS_PCOUNTER_INPUT_INTERNAL = 0;
    public static final int JOBS_PCOUNTER_INPUT_S0_1 = 1;
    public static final int JOBS_PCOUNTER_INPUT_S0_2 = 2;
    public static final int JOBS_PCOUNTER_INPUT_S0_3 = 3;
    public static final int JOBS_PCOUNTER_INPUT_S0_4 = 4;
    public static final int JOBS_PCOUNTER_INPUT_POT = 5;
    private int version = 1;
    private int flags;
    private int trigger;
    private int inputSelect;
    private int prescaler;
    private int tripPreset;
    private int mainEis;
    private int tripEis;
    private int mainValueEis;
    private int tripValueEis;
    private int mainInterval;
    private int tripInterval;
    private float mainValueFactor;
    private float mainValueOffset;
    private float tripValueFactor;
    private float tripValueOffset;
    private int watchdogInterval;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objReqCnt;
    private EIBAddressObject2 objMainCnt;
    private EIBAddressObject2 objTripCnt;
    private EIBAddressObject2 objMainValue;
    private EIBAddressObject2 objTripValue;
    private EIBAddressObject2 objMainOvfl;
    private EIBAddressObject2 objTripOvfl;
    private EIBAddressObject2 objTripDirection;
    private EIBAddressObject2 objTripReset;
    private EIBAddressObject2 objTripStop;
    private EIBAddressObject2 objWatchdog;
    private EIBAddressObject2 objPulseInput;
    private EIBAddressObject2 objMainSet;

    public BMXPulseCounter(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXPulseCounter() {
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n = 0;
        this.version = byArray[n++] & 0xFF;
        this.flags = byArray[n++] & 0xFF;
        this.trigger = byArray[n++] & 0xFF;
        this.inputSelect = ByteConv.byte2short(byArray, n);
        this.prescaler = ByteConv.byte2short(byArray, n += 2);
        this.tripPreset = ByteConv.byte2long(byArray, n += 2);
        n += 4;
        this.mainEis = byArray[n++] & 0xFF;
        this.tripEis = byArray[n++] & 0xFF;
        this.mainValueEis = byArray[n++] & 0xFF;
        this.tripValueEis = byArray[n++] & 0xFF;
        this.mainInterval = ByteConv.byte2short(byArray, n);
        this.tripInterval = ByteConv.byte2short(byArray, n += 2);
        this.mainValueFactor = ByteConv.byte2float(byArray, n += 2);
        this.mainValueOffset = ByteConv.byte2float(byArray, n += 4);
        this.tripValueFactor = ByteConv.byte2float(byArray, n += 4);
        this.tripValueOffset = ByteConv.byte2float(byArray, n += 4);
        this.watchdogInterval = ByteConv.byte2short(byArray, n += 4);
        n += 2;
        n += 128;
        int n2 = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n2++);
        this.objReqCnt = bMXJobData.getEIBAddressObject2(n2++);
        this.objMainCnt = bMXJobData.getEIBAddressObject2(n2++);
        this.objTripCnt = bMXJobData.getEIBAddressObject2(n2++);
        this.objMainValue = bMXJobData.getEIBAddressObject2(n2++);
        this.objTripValue = bMXJobData.getEIBAddressObject2(n2++);
        this.objMainOvfl = bMXJobData.getEIBAddressObject2(n2++);
        this.objTripOvfl = bMXJobData.getEIBAddressObject2(n2++);
        this.objTripDirection = bMXJobData.getEIBAddressObject2(n2++);
        this.objTripReset = bMXJobData.getEIBAddressObject2(n2++);
        this.objTripStop = bMXJobData.getEIBAddressObject2(n2++);
        this.objWatchdog = bMXJobData.getEIBAddressObject2(n2++);
        this.objPulseInput = bMXJobData.getEIBAddressObject2(n2++);
        this.objMainSet = bMXJobData.getEIBAddressObject2(n2++);
    }

    @Override
    public BMXJobData getJobData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(this.flags);
            byteArrayOutputStream.write(this.trigger);
            byteArrayOutputStream.write(ByteConv.short2byte(this.inputSelect));
            byteArrayOutputStream.write(ByteConv.short2byte(this.prescaler));
            byteArrayOutputStream.write(ByteConv.long2byte(this.tripPreset));
            byteArrayOutputStream.write(this.mainEis);
            byteArrayOutputStream.write(this.tripEis);
            byteArrayOutputStream.write(this.mainValueEis);
            byteArrayOutputStream.write(this.tripValueEis);
            byteArrayOutputStream.write(ByteConv.short2byte(this.mainInterval));
            byteArrayOutputStream.write(ByteConv.short2byte(this.tripInterval));
            byteArrayOutputStream.write(ByteConv.float2byte(this.mainValueFactor));
            byteArrayOutputStream.write(ByteConv.float2byte(this.mainValueOffset));
            byteArrayOutputStream.write(ByteConv.float2byte(this.tripValueFactor));
            byteArrayOutputStream.write(ByteConv.float2byte(this.tripValueOffset));
            byteArrayOutputStream.write(ByteConv.short2byte(this.watchdogInterval));
            byteArrayOutputStream.write(new byte[128]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_PULSE_COUNTER, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objReqCnt);
        bMXJobData.addEIBAddressObject2(this.objMainCnt);
        bMXJobData.addEIBAddressObject2(this.objTripCnt);
        bMXJobData.addEIBAddressObject2(this.objMainValue);
        bMXJobData.addEIBAddressObject2(this.objTripValue);
        bMXJobData.addEIBAddressObject2(this.objMainOvfl);
        bMXJobData.addEIBAddressObject2(this.objTripOvfl);
        bMXJobData.addEIBAddressObject2(this.objTripDirection);
        bMXJobData.addEIBAddressObject2(this.objTripReset);
        bMXJobData.addEIBAddressObject2(this.objTripStop);
        bMXJobData.addEIBAddressObject2(this.objWatchdog);
        bMXJobData.addEIBAddressObject2(this.objPulseInput);
        bMXJobData.addEIBAddressObject2(this.objMainSet);
        for (int i = 0; i < 8; ++i) {
            bMXJobData.addEIBAddressObject2(new EIBAddressObject2(""));
        }
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        return string2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public void setFlag(int n, boolean bl) {
        this.flags = bl ? this.flags | n : this.flags & ~n;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) > 0;
    }

    public void setTrigger(int n, boolean bl) {
        this.trigger = bl ? this.trigger | n : this.trigger & ~n;
    }

    public boolean getTrigger(int n) {
        return (this.trigger & n) > 0;
    }

    public int getInputSelect() {
        return this.inputSelect;
    }

    public void setInputSelect(int n) {
        this.inputSelect = n;
    }

    public int getPrescaler() {
        return this.prescaler;
    }

    public void setPrescaler(int n) {
        this.prescaler = n;
    }

    public int getTripPreset() {
        return this.tripPreset;
    }

    public void setTripPreset(int n) {
        this.tripPreset = n;
    }

    public int getMainEis() {
        return this.mainEis;
    }

    public void setMainEis(int n) {
        this.mainEis = n;
    }

    public int getTripEis() {
        return this.tripEis;
    }

    public void setTripEis(int n) {
        this.tripEis = n;
    }

    public int getMainValueEis() {
        return this.mainValueEis;
    }

    public void setMainValueEis(int n) {
        this.mainValueEis = n;
    }

    public int getTripValueEis() {
        return this.tripValueEis;
    }

    public void setTripValueEis(int n) {
        this.tripValueEis = n;
    }

    public int getMainInterval() {
        return this.mainInterval;
    }

    public void setMainInterval(int n) {
        this.mainInterval = n;
    }

    public int getTripInterval() {
        return this.tripInterval;
    }

    public void setTripInterval(int n) {
        this.tripInterval = n;
    }

    public float getMainValueFactor() {
        return this.mainValueFactor;
    }

    public void setMainValueFactor(float f) {
        this.mainValueFactor = f;
    }

    public float getMainValueOffset() {
        return this.mainValueOffset;
    }

    public void setMainValueOffset(float f) {
        this.mainValueOffset = f;
    }

    public float getTripValueFactor() {
        return this.tripValueFactor;
    }

    public void setTripValueFactor(float f) {
        this.tripValueFactor = f;
    }

    public float getTripValueOffset() {
        return this.tripValueOffset;
    }

    public void setTripValueOffset(float f) {
        this.tripValueOffset = f;
    }

    public int getWatchdogInterval() {
        return this.watchdogInterval;
    }

    public void setWatchdogInterval(int n) {
        this.watchdogInterval = n;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjReqCnt() {
        return this.objReqCnt;
    }

    public void setObjReqCnt(EIBAddressObject2 eIBAddressObject2) {
        this.objReqCnt = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjMainCnt() {
        return this.objMainCnt;
    }

    public void setObjMainCnt(EIBAddressObject2 eIBAddressObject2) {
        this.objMainCnt = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTripCnt() {
        return this.objTripCnt;
    }

    public void setObjTripCnt(EIBAddressObject2 eIBAddressObject2) {
        this.objTripCnt = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjMainValue() {
        return this.objMainValue;
    }

    public void setObjMainValue(EIBAddressObject2 eIBAddressObject2) {
        this.objMainValue = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTripValue() {
        return this.objTripValue;
    }

    public void setObjTripValue(EIBAddressObject2 eIBAddressObject2) {
        this.objTripValue = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjMainOvfl() {
        return this.objMainOvfl;
    }

    public void setObjMainOvfl(EIBAddressObject2 eIBAddressObject2) {
        this.objMainOvfl = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTripOvfl() {
        return this.objTripOvfl;
    }

    public void setObjTripOvfl(EIBAddressObject2 eIBAddressObject2) {
        this.objTripOvfl = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTripDirection() {
        return this.objTripDirection;
    }

    public void setObjTripDirection(EIBAddressObject2 eIBAddressObject2) {
        this.objTripDirection = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTripReset() {
        return this.objTripReset;
    }

    public void setObjTripReset(EIBAddressObject2 eIBAddressObject2) {
        this.objTripReset = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTripStop() {
        return this.objTripStop;
    }

    public void setObjTripStop(EIBAddressObject2 eIBAddressObject2) {
        this.objTripStop = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjWatchdog() {
        return this.objWatchdog;
    }

    public void setObjWatchdog(EIBAddressObject2 eIBAddressObject2) {
        this.objWatchdog = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjPulseInput() {
        return this.objPulseInput;
    }

    public void setObjPulseInput(EIBAddressObject2 eIBAddressObject2) {
        this.objPulseInput = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjMainSet() {
        return this.objMainSet;
    }

    public void setObjMainSet(EIBAddressObject2 eIBAddressObject2) {
        this.objMainSet = eIBAddressObject2;
    }
}

