/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.jobs;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import de.babtec.globals.jobdata.LibID;
import de.babtec.globals.jobdata.jobs.LegacyJobModel;
import de.babtec.globals.jobdata.jobs.ServletJobModel;
import java.util.HashMap;
import java.util.UUID;

public class GenericJobPackage {
    private String name;
    private int magic;
    private int version = 1;
    private int last_modified;
    private String uuid;
    private JsonElement legacy;
    private JsonElement config;
    private HashMap<String, String> meta;

    public GenericJobPackage(int n, ServletJobModel servletJobModel) {
        this.magic = n;
        this.setConfiguration(servletJobModel);
        this.updateUUID();
    }

    public void updateUUID() {
        this.uuid = UUID.randomUUID().toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getMagic() {
        return this.magic;
    }

    public LibID getLibID() {
        return new LibID(this.magic);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getLast_modified() {
        return this.last_modified;
    }

    public void setLastModified(int n) {
        this.last_modified = n;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public HashMap<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(HashMap<String, String> hashMap) {
        this.meta = hashMap;
    }

    public LegacyJobModel getLegacyModel() {
        return new Gson().fromJson(this.legacy, LegacyJobModel.class);
    }

    public void setLegacyModel(LegacyJobModel legacyJobModel) {
        this.legacy = new Gson().toJsonTree(legacyJobModel);
    }

    public <T extends ServletJobModel> T getConfiguration(Class<T> clazz) {
        return (T)((ServletJobModel)new Gson().fromJson(this.config, clazz));
    }

    public void setConfiguration(ServletJobModel servletJobModel) {
        this.config = new Gson().toJsonTree(servletJobModel, servletJobModel.getClass());
    }

    public static String serialize(GenericJobPackage genericJobPackage) {
        return new Gson().toJson(genericJobPackage);
    }

    public static GenericJobPackage deserialize(String string) {
        return new Gson().fromJson(string, GenericJobPackage.class);
    }

    public static GenericJobPackage copy(GenericJobPackage genericJobPackage) {
        GenericJobPackage genericJobPackage2 = GenericJobPackage.deserialize(GenericJobPackage.serialize(genericJobPackage));
        genericJobPackage2.updateUUID();
        return genericJobPackage2;
    }
}

