/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata.extra;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.babtec.globals.jobdata.LibID;
import de.babtec.globals.jobdata.extra.JobExtraInfo;
import de.babtec.json.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;

public class JobExtraInfoContainer {
    public static final boolean USE_JOB_EXTRA_INFO = false;
    private int latestId = 0;
    private HashMap<Integer, JobExtraInfo> jobExtraInfoMap = new HashMap();
    private ArrayList<JobExtraInfo> jobExtraInfoTemp = new ArrayList();
    private static JobExtraInfoContainer INSTANCE = null;

    public void load(InputStream inputStream) {
        this.jobExtraInfoMap.clear();
        this.jobExtraInfoTemp.clear();
        JsonObject jsonObject = (JsonObject)new JsonParser().parse(new InputStreamReader(inputStream));
        int n = JsonUtils.getInt(jsonObject, "version", -1);
        if (n == -1) {
            // empty if block
        }
        this.latestId = JsonUtils.getInt(jsonObject, "maxId", 5);
        JsonArray jsonArray = jsonObject.getAsJsonArray("jobs");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject2 = jsonArray.get(i).getAsJsonObject();
            int[] nArray = JsonUtils.getIntArray(jsonObject2.getAsJsonArray("libId"));
            JobExtraInfo jobExtraInfo = new JobExtraInfo(JsonUtils.getInt(jsonObject2, "id", -1), new LibID(nArray[0], nArray[1], nArray[2]), JsonUtils.getString(jsonObject2, "name", ""));
            if (jobExtraInfo.getId() == -1) continue;
            jobExtraInfo.setComment(JsonUtils.getString(jsonObject2, "comment", ""));
            this.jobExtraInfoMap.put(jobExtraInfo.getId(), jobExtraInfo);
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        Object object;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", 1);
        jsonObject.addProperty("maxId", this.latestId);
        JsonArray jsonArray = new JsonArray();
        for (JobExtraInfo object22 : this.jobExtraInfoMap.values()) {
            object = new JsonObject();
            ((JsonObject)object).addProperty("id", object22.getId());
            int[] nArray = new int[]{object22.getLibId().getMain(), object22.getLibId().getID(), object22.getLibId().getVersion()};
            JsonUtils.addProperty((JsonObject)object, "libId", nArray, new int[]{0, 0, 0});
            ((JsonObject)object).addProperty("bmxJobName", object22.getBmxJobName());
            ((JsonObject)object).addProperty("name", object22.getName());
            ((JsonObject)object).addProperty("comment", object22.getComment());
            jsonArray.add((JsonElement)object);
        }
        jsonObject.add("jobs", jsonArray);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String string = gson.toJson(jsonObject);
        object = new OutputStreamWriter(outputStream);
        ((Writer)object).write(string);
        ((OutputStreamWriter)object).close();
    }

    private JobExtraInfo getTempInfo(LibID libID, String string) {
        for (JobExtraInfo object : this.jobExtraInfoTemp) {
            if (!object.getLibId().equalsAll(libID) || !string.equals(object.getName())) continue;
            return object;
        }
        JobExtraInfo jobExtraInfo = new JobExtraInfo(++this.latestId, libID, string);
        this.jobExtraInfoTemp.add(jobExtraInfo);
        System.out.println("=============");
        System.out.println("ADDED NEW TEMPORARY EXTRA INFO....");
        for (JobExtraInfo jobExtraInfo2 : this.jobExtraInfoTemp) {
            System.out.println(jobExtraInfo2.getBmxJobName() + " :: " + jobExtraInfo2.getId() + " : " + jobExtraInfo2.getName());
        }
        return jobExtraInfo;
    }

    public JobExtraInfo getJobExtraInfo(LibID libID, String string, boolean bl) {
        int n = this.nameToInt(string);
        System.out.println("NAME TO INT: " + n + " (" + string + ")");
        if (n == -1 || !this.jobExtraInfoMap.containsKey(n)) {
            System.out.println("did not find...");
            JobExtraInfo jobExtraInfo = this.getTempInfo(libID, string);
            if (bl) {
                this.jobExtraInfoTemp.remove(jobExtraInfo);
                this.jobExtraInfoMap.put(jobExtraInfo.getId(), jobExtraInfo);
                System.out.println("=============");
                System.out.println("ADDED NEW EXTRA INFO....");
                for (JobExtraInfo jobExtraInfo2 : this.jobExtraInfoMap.values()) {
                    System.out.println(jobExtraInfo2.getBmxJobName() + " :: " + jobExtraInfo2.getId() + " : " + jobExtraInfo2.getName());
                }
            }
            return jobExtraInfo;
        }
        return this.jobExtraInfoMap.get(n);
    }

    public void removeJobExtraInfo(LibID libID, String string) {
        JobExtraInfo jobExtraInfo = this.getJobExtraInfo(libID, string, false);
        this.jobExtraInfoMap.remove(jobExtraInfo.getId());
        this.jobExtraInfoTemp.remove(jobExtraInfo);
    }

    private int nameToInt(String string) {
        if (string.length() != 15) {
            return -1;
        }
        if (!(string = string.substring(10)).matches("[0-9a-f]{5}")) {
            return -1;
        }
        return Integer.parseInt(string, 16);
    }

    public static String intToName(String string, int n) {
        if (string.length() < 10) {
            string = string + "..........".substring(string.length());
        }
        if (string.length() > 10) {
            string = string.substring(0, 10);
        }
        String string2 = Integer.toHexString(n);
        string2 = "00000".substring(string2.length()) + string2;
        return string + string2;
    }

    public static final JobExtraInfoContainer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JobExtraInfoContainer();
        }
        return INSTANCE;
    }
}

