/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.jobdata;

import de.babtec.globals.jobdata.LibID;
import de.babtec.globals.jobdata.extra.JobExtraInfo;
import de.babtec.globals.jobdata.extra.JobExtraInfoContainer;
import de.babtec.globals.utils.ByteConv;
import java.io.UnsupportedEncodingException;

public class BMXBasicJobData
implements Comparable<BMXBasicJobData> {
    protected LibID libID;
    private String name;
    protected boolean nameIsUTF8 = false;
    private JobExtraInfo extraInfo = null;

    public BMXBasicJobData(byte[] byArray) {
        if (byArray.length < 6) {
            this.libID = null;
            return;
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 2, byArray2, 0, 4);
        this.libID = new LibID(byArray2);
        int n = 0;
        byte[] byArray3 = new byte[16];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 6; i < Math.min(22, byArray.length); ++i) {
            if (byArray[i] == 0) continue;
            byArray3[n++] = byArray[i];
            stringBuffer.append((char)(byArray[i] & 0xFF));
        }
        this.nameIsUTF8 = ByteConv.isUTF8(byArray3);
        try {
            this.setName(new String(byArray3, 0, n, this.nameIsUTF8 ? "UTF-8" : "ISO-8859-15"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.setName(new String(byArray3, 0, n));
        }
    }

    public BMXBasicJobData(LibID libID, String string, boolean bl) {
        this.libID = libID;
        this.name = string;
        this.nameIsUTF8 = bl;
    }

    public JobExtraInfo getJobExtraInfo(boolean bl) {
        if (this.extraInfo == null) {
            this.extraInfo = JobExtraInfoContainer.getInstance().getJobExtraInfo(this.getLibID(), this.getName(), bl);
            if (bl) {
                this.setName(this.extraInfo.getBmxJobName());
            }
        }
        return this.extraInfo;
    }

    public boolean equals(Object object) {
        if (object instanceof BMXBasicJobData) {
            return this.equals((BMXBasicJobData)object);
        }
        return false;
    }

    public boolean equals(BMXBasicJobData bMXBasicJobData) {
        return this.equalsLibID(bMXBasicJobData.getLibID()) && bMXBasicJobData.getName().equals(this.getName());
    }

    public boolean equalsLibID(LibID libID) {
        return this.libID.equalsLibID(libID);
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameBytes() {
        try {
            return this.name.getBytes(this.nameIsUTF8 ? "UTF-8" : "ISO-8859-15");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return this.name.getBytes();
        }
    }

    public boolean getNameIsUTF8() {
        return this.nameIsUTF8;
    }

    public LibID getLibID() {
        return this.libID;
    }

    public boolean equalsLibID(BMXBasicJobData bMXBasicJobData) {
        return this.libID.equalsLibID(bMXBasicJobData.getLibID()) && this.name.equals(bMXBasicJobData.name);
    }

    @Override
    public int compareTo(BMXBasicJobData bMXBasicJobData) {
        return this.toString().compareTo(bMXBasicJobData.toString());
    }
}

