/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.deprecated.eibaddress;

import de.babtec.globals.bmx.BMXNetInterface;
import de.babtec.globals.bmx.BMXTelegram;
import de.babtec.globals.deprecated.eibaddress.IllegalAddressException;
import de.babtec.globals.deprecated.eibaddress.NewTelegramListener;
import de.babtec.globals.knx.address.EIBAddressObject2;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class EIBAddressObject {
    private ArrayList<Integer> addresses = new ArrayList();
    private String addressString;
    private BMXTelegram lastTelegram;
    private ArrayList<NewTelegramListener> telegramListener = new ArrayList();
    private BMXNetInterface telegramDeliverer;

    public EIBAddressObject(String string, BMXNetInterface bMXNetInterface, NewTelegramListener newTelegramListener) throws IllegalAddressException {
        if (!EIBAddressObject2.isValidAddressObjectString(string)) {
            throw new IllegalAddressException(string + " is an invalid EIB Communication Object!");
        }
        this.addressString = string;
        this.addresses = EIBAddressObject.stringToIntAddress(string);
        this.telegramDeliverer = bMXNetInterface;
        if (newTelegramListener != null) {
            this.telegramListener.add(newTelegramListener);
        }
    }

    public void addTelegramListener(NewTelegramListener newTelegramListener) {
        if (newTelegramListener != null) {
            this.telegramListener.add(newTelegramListener);
        }
    }

    public void removeTelegramListener(NewTelegramListener newTelegramListener) {
        this.telegramListener.remove(newTelegramListener);
    }

    public String toString() {
        return this.addressString;
    }

    public int getSendAddress() {
        return this.addresses.get(0);
    }

    public int[] getArray() {
        int[] nArray = new int[5];
        for (int i = 0; i < this.addresses.size() && i < nArray.length; ++i) {
            nArray[i] = this.addresses.get(i);
        }
        return nArray;
    }

    public void getTelegram(BMXTelegram bMXTelegram, boolean bl) {
        if (bMXTelegram != null) {
            for (int n : this.addresses) {
                if (bMXTelegram.getAddress() != n || this.lastTelegram != null && !(this.lastTelegram.getDate() < bMXTelegram.getDate())) continue;
                this.lastTelegram = bMXTelegram;
                int n2 = bMXTelegram.getStatusFunction();
                if (n2 != 1 && n2 != 2 && n2 != 5 && n2 != 6 || !bl) continue;
                for (NewTelegramListener newTelegramListener : this.telegramListener) {
                    newTelegramListener.newTelegramDataReceived(this.lastTelegram, this);
                }
            }
        }
    }

    public BMXTelegram getLastTelegram() {
        for (Integer n : this.addresses) {
            this.getTelegram(this.telegramDeliverer.getTelegramForAddress(n), false);
        }
        return this.lastTelegram;
    }

    public static ArrayList<Integer> stringToIntAddress(String string) throws IllegalAddressException {
        boolean bl = Pattern.matches("\\A(\\d{1,2}\\/\\d{1,4}(\\((\\d{1,2}\\/\\d{1,4},){0,3}\\d{1,2}\\/\\d{1,4}\\)){0,1}){0,1}\\Z", string);
        boolean bl2 = Pattern.matches("\\A\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}(\\((\\d{1,2}\\/\\d{1,2}\\/\\d{1,3},){0,3}\\d{1,2}\\/\\d{1,2}\\/\\d{1,3}\\)){0,1}\\Z", string);
        if (!bl && !bl2) {
            throw new IllegalAddressException("The address is invalid!");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string.endsWith(")")) {
            string = string.replace('(', ',');
            string = string.substring(0, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "/");
            if (bl) {
                arrayList.add(new Integer((Integer.parseInt(stringTokenizer2.nextToken()) & 0xFF) << 11 | Integer.parseInt(stringTokenizer2.nextToken()) & 0x7FF));
                continue;
            }
            arrayList.add(new Integer((Integer.parseInt(stringTokenizer2.nextToken()) & 0x1F) << 11 | (Integer.parseInt(stringTokenizer2.nextToken()) & 7) << 8 | Integer.parseInt(stringTokenizer2.nextToken()) & 0xFF));
        }
        return arrayList;
    }
}

