/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals.bmx;

import java.math.BigDecimal;
import java.util.GregorianCalendar;

public class BMXTelegram {
    public static final int TYPE_INT_FRAGE = 0;
    public static final int TYPE_INT_ANTWORT = 1;
    public static final int TYPE_INT_SCHALT = 2;
    public static final int TYPE_INT_EX_FRAGE = 3;
    public static final int TYPE_EXT_FRAGE = 4;
    public static final int TYPE_EXT_ANTWORT = 5;
    public static final int TYPE_EXT_SCHALT = 6;
    public static final int TYPE_EXT_FEHLER = 7;
    public static final int BT_TYPE_NONE = 0;
    public static final int BT_TYPE_STANDARD = 1;
    public static final int BT_TYPE_ENHANCED1 = 2;
    public static final int BT_TYPE_ENHANCED2 = 3;
    public static final int BT_SRC_TYPE_NONE = 0;
    public static final int BT_SRC_TYPE_BMX_TCP = 1;
    public static final int BT_SRC_TYPE_BMX_FC = 2;
    public static final int BT_SRC_TYPE_EIB = 3;
    public static final int BT_SRC_TYPE_FIFO = 4;
    public static final int BT_SRC_TYPE_JOB = 5;
    public static final int BT_SRC_TYPE_OUTQ = 6;
    public static final int BT_SRC_TYPE_LIB_IP = 7;
    public static final int BT_SRC_TYPE_NET_IP = 8;
    public static final int BT_SRC_TYPE_BMX_UDP = 9;
    public static final int BT_SRC_TYPE_CGI = 10;
    public static final int BT_SRC_TYPE_XPL = 11;
    public static final int BT_SRC_TYPE_ABB_IP = 12;
    public static final int BT_SRC_TYPE_RAP = 13;
    public static final int BT_SRC_TYPE_ENOCEAN = 14;
    public static final int BT_SRC_TYPE_OEM4 = 15;
    public static final String[] BT_SRC_TYPES = new String[]{"<none>", "BMX_TCP", "BMX_FC", "EIB", "FIFO", "JOB", "OUTQ", "LIB/IP", "KNXnet/IP routing", "BMX_UDP", "CGI", "xPL", "(pre) KNXnet/IP routing", "RAP", "enOcean", "OEM4"};
    public static final String[] BT_PRIO_TYPES = new String[]{"System functions", "High operational", "Alarm functions", "Low operational"};
    private static final String[] TYPES = new String[]{"Int_Frage", "Int_Antwort", "Int_Schalt", "Int_ExFrage", "Ext_Frage", "Ext_Antwort", "Ext_Schalt", "Ext_Fehler"};
    private int bt_type;
    private int adress;
    private int id;
    private double date;
    private int status;
    private boolean dir_extern;
    private int type;
    private int size;
    private byte[] value = new byte[16];
    private int src_addr;
    private int priority;
    private int rcnt;
    private boolean repeatition;
    private int src_type;
    private long timeInMs = -1L;
    public TelegramStatus telegramStatus = null;

    public BMXTelegram(byte[] byArray) {
        this(byArray, false);
        if (this.getStatusFunction() == 1 || this.getStatusFunction() == 5) {
            this.status |= 0x4000;
        }
    }

    public BMXTelegram(byte[] byArray, boolean bl) {
        this.adress = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
        this.id = byArray[6] & 0xFF | (byArray[7] & 0xFF) << 8;
        this.status = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8;
        if (bl) {
            this.status |= 0x4000;
        }
        this.dir_extern = (this.status & 0x80) == 128;
        this.type = (this.status & 0x70) >> 4;
        this.size = this.status & 0xF;
        long l = (long)(byArray[8] & 0xFF) | (long)(byArray[9] & 0xFF) << 8 | (long)(byArray[10] & 0xFF) << 16 | (long)(byArray[11] & 0xFF) << 24 | (long)(byArray[12] & 0xFF) << 32 | (long)(byArray[13] & 0xFF) << 40 | (long)(byArray[14] & 0xFF) << 48 | (long)(byArray[15] & 0xFF) << 56;
        this.date = Double.longBitsToDouble(l);
        System.arraycopy(byArray, 18, this.value, 0, 16);
        if (byArray.length >= 38) {
            this.bt_type = 2;
            this.src_addr = byArray[34] & 0xFF | (byArray[35] & 0xFF) << 8;
            this.repeatition = (byArray[36] >> 1 & 1) != 1;
            this.priority = byArray[36] >> 2 & 3;
            this.rcnt = byArray[36] >> 4 & 7;
            this.src_type = byArray[37];
        } else {
            this.bt_type = 1;
            this.src_addr = 0;
            this.priority = 0;
            this.repeatition = false;
            this.rcnt = 0;
            this.src_type = 0;
        }
    }

    public int getBTtype() {
        return this.bt_type;
    }

    public boolean isEnhanced() {
        return this.bt_type != 0 && this.bt_type != 1;
    }

    public int getPhysAdr() {
        return this.src_addr;
    }

    public String getPhysAdrRepresentation(boolean bl) {
        if (bl && this.src_type != 3 && this.src_type != 9 && this.src_type != 8 && this.src_type != 12 && (this.src_type != 2 || this.src_addr == 0)) {
            return "";
        }
        int n = this.src_addr >> 12 & 0xF;
        int n2 = this.src_addr >> 8 & 0xF;
        int n3 = this.src_addr >> 0 & 0xFF;
        return "" + n + "." + n2 + "." + n3;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPriorityRepresentation(boolean bl) {
        if (bl && this.src_type != 3) {
            return "";
        }
        return BT_PRIO_TYPES[this.priority];
    }

    public boolean isRepeatition() {
        return this.repeatition;
    }

    public int getRcnt() {
        return this.rcnt;
    }

    public int getSrcType() {
        return this.src_type;
    }

    public String getSrcTypeRepresentation(boolean bl) {
        if (this.src_type == 0 && bl) {
            return "";
        }
        if (this.src_type >= 0 && this.src_type < BT_SRC_TYPES.length) {
            return BT_SRC_TYPES[this.src_type];
        }
        return "<unknown>";
    }

    public int getAddress() {
        return this.adress;
    }

    public int getId() {
        return this.id;
    }

    public double getDate() {
        return this.date;
    }

    public long getTimestamp() {
        if (this.timeInMs == -1L) {
            this.timeInMs = BMXTelegram.toMilliseconds(this.date);
        }
        return this.timeInMs;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean getStatusTrace() {
        return (this.status & 0x4000) == 16384;
    }

    public boolean getStatusSrcEib() {
        return (this.status & 0x80) == 128;
    }

    public int getStatusFunction() {
        return (this.status & 0x70) >> 4;
    }

    public int getStatusDatasize() {
        return this.status & 0xF;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return TYPES[this.getType()];
    }

    public String getCompleteTypeString() {
        return (this.isExtern() ? "extern " : "intern ") + this.getTypeString();
    }

    public boolean isExtern() {
        return this.dir_extern;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getValue() {
        return this.value;
    }

    public static long toMilliseconds(double d) {
        long l = 0L;
        BigDecimal bigDecimal = new BigDecimal(d);
        long l2 = bigDecimal.longValue();
        BigDecimal bigDecimal2 = bigDecimal.subtract(new BigDecimal("" + l2));
        long l3 = -2209165200000L + l2 * 86400000L;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l3);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        l3 = gregorianCalendar.getTimeInMillis();
        long l4 = (long)(8.64E7 * bigDecimal2.doubleValue());
        l = l3 + l4;
        return l;
    }

    public static double toDouble(long l) {
        long l2 = new GregorianCalendar().get(16);
        double d = 0.0;
        d = (double)(l + 2209165200000L + l2) / 8.64E7;
        return d;
    }

    public class TelegramStatus {
        public int adr;
        public long timestamp;
        public int bmxLen;
        public String hexData;

        public int getAdr() {
            return this.adr;
        }

        public void setAdr(int n) {
            this.adr = n;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public int getBmxLen() {
            return this.bmxLen;
        }

        public void setBmxLen(int n) {
            this.bmxLen = n;
        }

        public String getHexData() {
            return this.hexData;
        }

        public void setHexData(String string) {
            this.hexData = string;
        }
    }
}

