/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swingset3.utilities;

import com.sun.swingset3.utilities.ArrowIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class CollapsiblePanel
extends JPanel {
    private JPanel panel;
    private JComponent child;
    private JCheckBox expandCheckBox;
    private Orientation orientation = Orientation.VERTICAL;
    private Dimension childPrefSize;
    private boolean expanded = true;

    public CollapsiblePanel(JComponent jComponent) {
        this(jComponent, Orientation.VERTICAL);
    }

    public CollapsiblePanel(JComponent jComponent, Orientation orientation) {
        this.orientation = orientation;
        this.child = jComponent;
        this.setLayout(new BorderLayout());
        this.panel = new JPanel(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.panel.add((Component)jComponent, "Center");
    }

    public CollapsiblePanel(JComponent jComponent, String string, String string2) {
        this(jComponent, Orientation.VERTICAL, string, string2);
    }

    public CollapsiblePanel(JComponent jComponent, String string) {
        this(jComponent, Orientation.VERTICAL, string, null);
    }

    public CollapsiblePanel(JComponent jComponent, Orientation orientation, String string, String string2) {
        this(jComponent, orientation);
        this.add(this.createCollapseControl(string, string2), orientation == Orientation.HORIZONTAL ? "West" : "North");
    }

    public JComponent getChild() {
        return this.child;
    }

    protected Component createCollapseControl(String string, String string2) {
        Box box = Box.createHorizontalBox();
        this.expandCheckBox = new JCheckBox(string);
        this.expandCheckBox.setBorder(new EmptyBorder(0, 4, 0, 0));
        this.expandCheckBox.setToolTipText(string2);
        this.expandCheckBox.setHorizontalTextPosition(4);
        this.expandCheckBox.setSelectedIcon(new ArrowIcon(5));
        this.expandCheckBox.setIcon(new ArrowIcon(3));
        this.expandCheckBox.setSelected(this.isExpanded());
        this.expandCheckBox.addChangeListener(new CollapseListener());
        box.add(this.expandCheckBox);
        return box;
    }

    public void setExpanded(boolean bl) {
        boolean bl2 = this.expanded;
        if (bl2 != bl) {
            if (this.expandCheckBox != null) {
                this.expandCheckBox.setSelected(bl);
            }
            this.childPrefSize = this.child.getPreferredSize();
            this.expanded = bl;
            if (this.isShowing()) {
                Animator animator = null;
                if (this.orientation == Orientation.VERTICAL) {
                    animator = new Animator(600, new PropertySetter((Object)this, "collapseHeight", bl ? 0 : this.childPrefSize.height, bl ? this.childPrefSize.height : 0));
                }
                if (this.orientation == Orientation.HORIZONTAL) {
                    animator = new Animator(600, new PropertySetter((Object)this, "collapseWidth", bl ? 0 : this.childPrefSize.width, bl ? this.childPrefSize.width : 0));
                }
                animator.setStartDelay(10);
                animator.setAcceleration(0.2f);
                animator.setDeceleration(0.3f);
                animator.start();
            } else if (this.orientation == Orientation.VERTICAL) {
                this.setCollapseHeight(bl ? this.childPrefSize.height : 0);
            } else if (this.orientation == Orientation.HORIZONTAL) {
                this.setCollapseWidth(bl ? this.childPrefSize.width : 0);
            }
            this.firePropertyChange("expanded", bl2, bl);
        }
    }

    public void setCollapseHeight(int n) {
        this.panel.setPreferredSize(new Dimension(this.childPrefSize.width, n));
        this.child.revalidate();
        this.repaint();
    }

    public void setCollapseWidth(int n) {
        this.panel.setPreferredSize(new Dimension(n, this.childPrefSize.height));
        this.child.revalidate();
        this.repaint();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpandedIcon(Icon icon) {
        if (this.expandCheckBox != null) {
            this.expandCheckBox.setSelectedIcon(icon);
        }
    }

    public void setCollapsedIcon(Icon icon) {
        if (this.expandCheckBox != null) {
            this.expandCheckBox.setIcon(icon);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.expandCheckBox != null) {
            this.expandCheckBox.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.expandCheckBox != null) {
            this.expandCheckBox.setForeground(color);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected void configureDefaults() {
        if (this.expandCheckBox != null) {
            if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
                this.expandCheckBox.setBorder(new EmptyBorder(0, 4, 0, 0));
            } else {
                this.expandCheckBox.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        }
    }

    private class CollapseListener
    implements ChangeListener {
        private CollapseListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            CollapsiblePanel.this.setExpanded(CollapsiblePanel.this.expandCheckBox.isSelected());
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

