/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swingset3.utilities;

import com.sun.swingset3.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
SwingConstants {
    private static final float DB = -0.06f;
    private int direction;
    private int arrowSize;
    private Dimension imgSize;
    private Color color;
    private BufferedImage arrowImage;

    public ArrowIcon(int n) {
        this(n, 10, new Dimension(10, 10), null);
    }

    public ArrowIcon(int n, Color color) {
        this(n, 10, new Dimension(10, 10), color);
    }

    public ArrowIcon(int n, Dimension dimension) {
        this(n, 10, dimension, null);
    }

    public ArrowIcon(int n, int n2, Dimension dimension, Color color) {
        this.arrowSize = n2;
        this.imgSize = dimension;
        this.direction = n;
        this.color = color;
    }

    @Override
    public int getIconHeight() {
        return this.imgSize.height;
    }

    @Override
    public int getIconWidth() {
        return this.imgSize.width;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.drawImage(this.getArrowImage(), n, n2, component);
    }

    protected Image getArrowImage() {
        if (this.arrowImage == null) {
            BufferedImage bufferedImage = Utilities.createTranslucentImage(this.arrowSize, this.arrowSize);
            AffineTransform affineTransform = this.direction != 5 ? new AffineTransform() : null;
            switch (this.direction) {
                case 1: {
                    affineTransform.setToRotation(Math.PI, this.arrowSize / 2, this.arrowSize / 2);
                    break;
                }
                case 3: {
                    affineTransform.setToRotation(-1.5707963267948966, this.arrowSize / 2, this.arrowSize / 2);
                    break;
                }
                case 7: {
                    affineTransform.setToRotation(1.5707963267948966, this.arrowSize / 2, this.arrowSize / 2);
                }
            }
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            if (affineTransform != null) {
                graphics2D.setTransform(affineTransform);
            }
            int n = this.arrowSize;
            int n2 = this.arrowSize / 2 + 1;
            int n3 = (this.arrowSize - n) / 2;
            int n4 = (this.arrowSize - n2 + 1) / 2;
            Color color = this.color != null ? this.color : UIManager.getColor("controlDkShadow").darker();
            this.paintArrow(graphics2D, color, n3, n4);
            this.paintArrowBevel(graphics2D, color, n3, n4);
            this.paintArrowBevel(graphics2D, Utilities.deriveColorHSB(color, 0.0f, 0.0f, 0.2f), n3, n4 + 1);
            this.arrowImage = Utilities.createTranslucentImage(this.imgSize.width, this.imgSize.height);
            this.arrowImage.getGraphics().drawImage(bufferedImage, (this.imgSize.width - this.arrowSize) / 2, (this.imgSize.height - this.arrowSize) / 2, null);
            bufferedImage.flush();
            bufferedImage = null;
        }
        return this.arrowImage;
    }

    protected void paintArrow(Graphics2D graphics2D, Color color, int n, int n2) {
        graphics2D.setColor(color);
        int n3 = n;
        int n4 = n2 - 1;
        for (int i = this.arrowSize - 2; i >= 2; i -= 2) {
            graphics2D.fillRect(++n3, ++n4, i, 1);
        }
    }

    protected void paintArrowBevel(Graphics graphics, Color color, int n, int n2) {
        int n3 = this.arrowSize;
        int n4 = n;
        int n5 = n2;
        Color color2 = Utilities.deriveColorHSB(color, 0.0f, 0.0f, 0.06f * (float)(this.arrowSize / 2));
        while (n3 >= 2) {
            color2 = Utilities.deriveColorHSB(color2, 0.0f, 0.0f, -0.06f);
            graphics.setColor(color2);
            graphics.fillRect(n4, n5, 1, 1);
            graphics.fillRect(n4 + n3 - 1, n5, 1, 1);
            n3 -= 2;
            ++n4;
            ++n5;
        }
    }
}

