/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.tools;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.eibport.net.mcast.EibPortList;
import de.eibport.net.mcast.MulticastThread;
import de.eibport.net.mcast.packets.v2.BodyBeaconEP;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import de.eibport.net.mcast.packets.v2.EpDatagramBody;
import de.eibport.tools.Messages;
import de.eibport.tools.NetworkConfiguration;
import de.eibport.utils.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EpDiscovery
extends JFrame {
    private String urlstr;
    private AbstractAction configAction;
    private AbstractAction openInBrowserAction;
    private EibPortList eibPortList;
    private MulticastThread mt;
    private JLabel hostL;
    private JLabel fwL;
    private JLabel portHttpL;
    private JLabel portSshL;
    private JLabel portBmxTcpL;
    private JLabel portBmxUdpL;
    private JTextField hostTf = new JTextField("");
    private JTextField fwTf = new JTextField("");
    private JTextField portHttp = new JTextField("");
    private JTextField portSsh = new JTextField("");
    private JTextField portBmxTcp = new JTextField("");
    private JTextField portBmxUdp = new JTextField("");
    protected FormLayout fl = new FormLayout("90dlu:grow, 90dlu:grow", "");
    protected DefaultFormBuilder ff = new DefaultFormBuilder(this.fl);

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("No Nimbus Look&Feel installed");
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    unsupportedLookAndFeelException.printStackTrace();
                }
                EpDiscovery epDiscovery = new EpDiscovery();
                epDiscovery.setVisible(true);
            }
        });
    }

    public EpDiscovery() {
        this.setDefaultCloseOperation(3);
        URL uRL = this.getClass().getResource("/icons/Find16.gif");
        Image image = new ImageIcon(uRL).getImage();
        this.setIconImage(image);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(new JMenuItem(new AbstractAction(Messages.getString("action.refresh")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpDiscovery.this.refreshList();
            }
        }));
        this.mt = new MulticastThread(MulticastThread.DEFAULT_GROUP_ADDRESS, 1735, 64, true);
        this.mt.start();
        this.eibPortList = new EibPortList(this.mt);
        this.hostL = new JLabel(Messages.getString("property.ip_address"));
        this.hostTf.setEditable(false);
        this.hostTf.setFont(this.hostTf.getFont().deriveFont(1));
        this.hostTf.setCursor(new Cursor(12));
        this.hostTf.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (EpDiscovery.this.hostTf.getText().length() > 0) {
                    try {
                        BrowserLauncher.openURL("http://" + EpDiscovery.this.hostTf.getText() + ":" + EpDiscovery.this.portHttp.getText());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        this.fwL = new JLabel(Messages.getString("property.firmware"));
        this.fwTf.setEditable(false);
        this.fwTf.setFont(this.fwTf.getFont().deriveFont(1));
        this.portHttpL = new JLabel(Messages.getString("property.port_http"));
        this.portHttp.setEditable(false);
        this.portHttp.setFont(this.portHttp.getFont().deriveFont(1));
        this.portSshL = new JLabel(Messages.getString("property.port_ssh"));
        this.portSsh.setEditable(false);
        this.portSsh.setFont(this.portSsh.getFont().deriveFont(1));
        this.portBmxTcpL = new JLabel(Messages.getString("property.port_bmx_tcp"));
        this.portBmxTcp.setEditable(false);
        this.portBmxTcp.setFont(this.portBmxTcp.getFont().deriveFont(1));
        this.portBmxUdpL = new JLabel(Messages.getString("property.port_bmx_udp"));
        this.portBmxUdp.setEditable(false);
        this.portBmxUdp.setFont(this.portBmxUdp.getFont().deriveFont(1));
        this.configAction = new AbstractAction(Messages.getString("action.network_setup")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                int n = 0;
                Object e = EpDiscovery.this.eibPortList.getSelectedValue();
                if (!(e instanceof EpDatagram)) {
                    return;
                }
                Object object = (EpDatagram)e;
                n = ((EpDatagram)object).getBody().getPropertyInteger("bSernr");
                string = ((BodyBeaconEP)((EpDatagram)object).getBody()).getCompleteVersion();
                object = new NetworkConfiguration(EpDiscovery.this, EpDiscovery.this.mt, n, string){

                    @Override
                    protected void finished(boolean bl) {
                        System.out.println("finished network configuration: " + bl);
                        if (bl) {
                            EpDiscovery.this.refreshList();
                        }
                    }
                };
                ((NetworkConfiguration)object).showNetworkConfiguration();
            }
        };
        this.openInBrowserAction = new AbstractAction(Messages.getString("action.open_in_browser")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserLauncher.openURL("http://" + EpDiscovery.this.hostTf.getText() + ":" + EpDiscovery.this.portHttp.getText());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        this.ff.setDefaultDialogBorder();
        this.ff.setRowGroupingEnabled(true);
        this.ff.appendRow("fill:60dlu:grow");
        this.ff.add((Component)new JScrollPane(this.eibPortList, 22, 31), new CellConstraints(1, this.ff.getRow(), 2, 1));
        this.nextRow(this.ff);
        this.addComp(this.hostL, this.ff, 1);
        this.addComp(this.hostTf, this.ff, 2);
        this.nextRow(this.ff);
        this.addComp(this.fwL, this.ff, 1);
        this.addComp(this.fwTf, this.ff, 2);
        this.nextRow(this.ff);
        this.addComp(this.portHttpL, this.ff, 1);
        this.addComp(this.portHttp, this.ff, 2);
        this.nextRow(this.ff);
        this.addComp(this.portSshL, this.ff, 1);
        this.addComp(this.portSsh, this.ff, 2);
        this.nextRow(this.ff);
        this.addComp(this.portBmxTcpL, this.ff, 1);
        this.addComp(this.portBmxTcp, this.ff, 2);
        this.nextRow(this.ff);
        this.addComp(this.portBmxUdpL, this.ff, 1);
        this.addComp(this.portBmxUdp, this.ff, 2);
        this.nextRow(this.ff);
        this.nextRow(this.ff);
        this.addComp(new JButton(this.openInBrowserAction), this.ff, 1);
        this.openInBrowserAction.setEnabled(false);
        this.addComp(new JButton(this.configAction), this.ff, 2);
        this.configAction.setEnabled(false);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.ff.getPanel(), "Center");
        this.setTitle(Messages.getString("title"));
        this.setSize(400, 450);
        this.eibPortList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = EpDiscovery.this.eibPortList.getSelectedValue();
                if (e instanceof EpDatagram) {
                    EpDatagram epDatagram = (EpDatagram)e;
                    if (epDatagram.isReachable() == 1 || epDatagram.isReachable() == 2) {
                        EpDiscovery.this.hostTf.setText(epDatagram.getHeader().getInetAddress("hIP").getHostAddress());
                    } else if (epDatagram.isReachable() == 0) {
                        EpDiscovery.this.hostTf.setText(epDatagram.getHeader().getInetAddress("hIP").getHostAddress());
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), Messages.getString("message.not_reachable"), Messages.getString("message.notice"), 1);
                    }
                    EpDatagramBody epDatagramBody = epDatagram.getBody();
                    EpDiscovery.this.fwTf.setText(epDatagramBody.getPropertyString("bVersion"));
                    EpDiscovery.this.portHttp.setText(Integer.toString(epDatagramBody.getPropertyShort("bPortHttp") & 0xFFFF));
                    EpDiscovery.this.portSsh.setText(Integer.toString(epDatagramBody.getPropertyShort("bPortSsh") & 0xFFFF));
                    EpDiscovery.this.portBmxTcp.setText(Integer.toString(epDatagramBody.getPropertyShort("bPortBmx") & 0xFFFF));
                    EpDiscovery.this.portBmxUdp.setText(Integer.toString(epDatagramBody.getPropertyShort("bPortUdp") & 0xFFFF));
                    EpDiscovery.this.openInBrowserAction.setEnabled(true);
                    short s = epDatagramBody.getPropertyShort("bFlags");
                    boolean bl = (s & 0x200) > 0;
                    EpDiscovery.this.configAction.setEnabled(bl);
                } else {
                    EpDiscovery.this.hostTf.setText("");
                    EpDiscovery.this.fwTf.setText("");
                    EpDiscovery.this.portHttp.setText("");
                    EpDiscovery.this.portSsh.setText("");
                    EpDiscovery.this.portBmxTcp.setText("");
                    EpDiscovery.this.portBmxUdp.setText("");
                }
            }
        });
        this.eibPortList.startListening((short)64);
        this.setLocationRelativeTo(null);
    }

    private void refreshList() {
        new Thread(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EpDiscovery.this.eibPortList.stopListening(true);
                    }
                });
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EpDiscovery.this.eibPortList.startListening((short)64);
                    }
                });
            }
        }.start();
    }

    protected void nextRow(DefaultFormBuilder defaultFormBuilder) {
        defaultFormBuilder.appendRow("3dlu");
        defaultFormBuilder.appendRow("pref");
        defaultFormBuilder.nextLine(2);
    }

    protected void addComp(Component component, DefaultFormBuilder defaultFormBuilder, int n) {
        defaultFormBuilder.add(component, new CellConstraints(n, defaultFormBuilder.getRow()));
    }

    public String getUrlstr() {
        return this.urlstr;
    }
}

