/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.lang.reflect.Type;

public class JsonUtils {
    private static final boolean DEBUG = false;
    public static Gson gson = new Gson();

    public static void addProperty(JsonObject jsonObject, String string, Boolean bl, Boolean bl2) {
        if (bl.equals(bl2)) {
            return;
        }
        jsonObject.addProperty(string, bl);
    }

    public static void addProperty(JsonObject jsonObject, String string, Character c, Character c2) {
        if (c.equals(c2)) {
            return;
        }
        jsonObject.addProperty(string, c);
    }

    public static void addProperty(JsonObject jsonObject, String string, Number number, Number number2) {
        if (number.equals(number2)) {
            return;
        }
        jsonObject.addProperty(string, number);
    }

    public static void addProperty(JsonObject jsonObject, String string, String string2, String string3) {
        if (string2 != null && string2.equals(string3)) {
            return;
        }
        jsonObject.addProperty(string, string2);
    }

    public static void addPropertyColor(JsonObject jsonObject, String string, Color color) {
        jsonObject.addProperty(string, Integer.toHexString(color.getRGB()));
    }

    public static void addProperty(JsonObject jsonObject, String string, int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = nArray2;
        }
        jsonObject.add(string, gson.toJsonTree(nArray, (Type)((Object)int[].class)));
    }

    public static String getString(JsonObject jsonObject, String string, String string2) {
        try {
            return jsonObject.get(string).getAsString();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static int getInt(JsonObject jsonObject, String string, int n) {
        try {
            return jsonObject.get(string).getAsInt();
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static boolean getBool(JsonObject jsonObject, String string, boolean bl) {
        try {
            return jsonObject.get(string).getAsBoolean();
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static float getFloat(JsonObject jsonObject, String string, float f) {
        try {
            return jsonObject.get(string).getAsFloat();
        }
        catch (Exception exception) {
            return f;
        }
    }

    public static double getDouble(JsonObject jsonObject, String string, double d) {
        try {
            return jsonObject.get(string).getAsDouble();
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static int getHex2Int(JsonObject jsonObject, String string, int n) {
        try {
            return (int)Long.parseLong(jsonObject.get(string).getAsString(), 16);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static Color getColor(JsonObject jsonObject, String string, Color color) {
        return new Color(JsonUtils.getHex2Int(jsonObject, string, color.getRGB()));
    }

    public static int[] getIntArray(JsonArray jsonArray) {
        return gson.fromJson((JsonElement)jsonArray, int[].class);
    }
}

