/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DefaultComponentFactory
implements ComponentFactory {
    private static final DefaultComponentFactory INSTANCE = new DefaultComponentFactory();
    private static final char MNEMONIC_MARKER = '&';
    private static final ColumnSpec PREF_GROWING_COL_SPEC = new ColumnSpec(ColumnSpec.FILL, Sizes.PREFERRED, 1.0);
    private static Boolean cachedIsLafAqua;
    private static boolean changeHandlerRegistered;

    private DefaultComponentFactory() {
    }

    public static DefaultComponentFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        DefaultComponentFactory.setTextAndMnemonic(jLabel, string);
        return jLabel;
    }

    @Override
    public JLabel createTitle(String string) {
        TitleLabel titleLabel = new TitleLabel();
        DefaultComponentFactory.setTextAndMnemonic(titleLabel, string);
        titleLabel.setVerticalAlignment(0);
        return titleLabel;
    }

    public JComponent createSeparator(String string) {
        return this.createSeparator(string, 2);
    }

    @Override
    public JComponent createSeparator(String string, int n) {
        if (string == null || string.length() == 0) {
            return new JSeparator();
        }
        JLabel jLabel = this.createTitle(string);
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec(DefaultComponentFactory.isLafAqua() ? Sizes.DLUX1 : Sizes.DLUX3);
        CellConstraints cellConstraints = new CellConstraints();
        if (n == 2) {
            FormLayout formLayout = new FormLayout(new ColumnSpec[]{FormFactory.PREF_COLSPEC, columnSpec, PREF_GROWING_COL_SPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            jPanel.setLayout(formLayout);
            jPanel.add((Component)jLabel, cellConstraints.xy(1, 1));
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(3, 1));
        } else if (n == 4) {
            FormLayout formLayout = new FormLayout(new ColumnSpec[]{PREF_GROWING_COL_SPEC, columnSpec, FormFactory.PREF_COLSPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            jPanel.setLayout(formLayout);
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(1, 1));
            jPanel.add((Component)jLabel, cellConstraints.xy(3, 1));
        } else if (n == 0) {
            FormLayout formLayout = new FormLayout(new ColumnSpec[]{PREF_GROWING_COL_SPEC, columnSpec, FormFactory.PREF_COLSPEC, columnSpec, PREF_GROWING_COL_SPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            jPanel.setLayout(formLayout);
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(1, 1));
            jPanel.add((Component)jLabel, cellConstraints.xy(3, 1));
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(5, 1));
        }
        return jPanel;
    }

    private static void setTextAndMnemonic(JLabel jLabel, String string) {
        int n;
        int n2 = string.indexOf(38);
        if (n2 == -1) {
            jLabel.setText(string);
            return;
        }
        int n3 = -1;
        int n4 = 0;
        int n5 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (n2 + 1 < n5 && string.charAt(n2 + 1) == '&') {
                n = n2 + 1;
            } else {
                n = n2;
                if (n3 == -1) {
                    n3 = n2;
                }
            }
            stringBuffer.append(string.substring(n4, n));
        } while ((n2 = (n4 = n + 1) < n5 ? string.indexOf(38, n4) : -1) != -1);
        stringBuffer.append(string.substring(n4));
        jLabel.setText(stringBuffer.toString());
        if (n3 != -1 && n3 + 1 < n5) {
            jLabel.setDisplayedMnemonic(string.charAt(n3 + 1));
            jLabel.setDisplayedMnemonicIndex(n3);
        }
    }

    private static synchronized void ensureLookAndFeelChangeHandlerRegistered() {
        if (!changeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
        }
    }

    private static boolean isLafAqua() {
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = DefaultComponentFactory.computeIsLafAqua();
            DefaultComponentFactory.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafAqua;
    }

    private static boolean computeIsLafAqua() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel.getName().startsWith("Mac OS X Aqua");
    }

    static {
        changeHandlerRegistered = false;
    }

    private static class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            cachedIsLafAqua = null;
        }
    }

    private static class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Color color = UIManager.getColor("TitledBorder.titleColor");
            if (color != null) {
                this.setForeground(color);
            }
            this.setFont(this.getTitleFont());
        }

        private Font getTitleFont() {
            return DefaultComponentFactory.isLafAqua() ? UIManager.getFont("Label.font").deriveFont(1) : UIManager.getFont("TitledBorder.font");
        }
    }
}

