/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonScope;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.google.gson.stream.StringPool;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private final StringPool stringPool = new StringPool();
    private final Reader in;
    private boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int bufferStartLine = 1;
    private int bufferStartColumn = 1;
    private JsonScope[] stack = new JsonScope[32];
    private int stackSize = 0;
    private JsonToken token;
    private String name;
    private String value;
    private int valuePos;
    private int valueLength;
    private boolean skipping;

    public JsonReader(Reader reader) {
        this.push(JsonScope.EMPTY_DOCUMENT);
        this.skipping = false;
        if (reader == null) {
            throw new NullPointerException("in == null");
        }
        this.in = reader;
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public void beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
    }

    public void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
    }

    public void beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
    }

    public void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
    }

    private void expect(JsonToken jsonToken) throws IOException {
        this.peek();
        if (this.token != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
    }

    public boolean hasNext() throws IOException {
        this.peek();
        return this.token != JsonToken.END_OBJECT && this.token != JsonToken.END_ARRAY;
    }

    public JsonToken peek() throws IOException {
        if (this.token != null) {
            return this.token;
        }
        switch (this.stack[this.stackSize - 1]) {
            case EMPTY_DOCUMENT: {
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_DOCUMENT;
                JsonToken jsonToken = this.nextValue();
                if (!this.lenient && this.token != JsonToken.BEGIN_ARRAY && this.token != JsonToken.BEGIN_OBJECT) {
                    throw new IOException("Expected JSON document to start with '[' or '{' but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
                }
                return jsonToken;
            }
            case EMPTY_ARRAY: {
                return this.nextInArray(true);
            }
            case NONEMPTY_ARRAY: {
                return this.nextInArray(false);
            }
            case EMPTY_OBJECT: {
                return this.nextInObject(true);
            }
            case DANGLING_NAME: {
                return this.objectValue();
            }
            case NONEMPTY_OBJECT: {
                return this.nextInObject(false);
            }
            case NONEMPTY_DOCUMENT: {
                int n = this.nextNonWhitespace(false);
                if (n == -1) {
                    return JsonToken.END_DOCUMENT;
                }
                --this.pos;
                if (!this.lenient) {
                    throw this.syntaxError("Expected EOF");
                }
                return this.nextValue();
            }
            case CLOSED: {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        throw new AssertionError();
    }

    private void consumeNonExecutePrefix() throws IOException {
        this.nextNonWhitespace(true);
        --this.pos;
        if (this.pos + NON_EXECUTE_PREFIX.length > this.limit && !this.fillBuffer(NON_EXECUTE_PREFIX.length)) {
            return;
        }
        for (int i = 0; i < NON_EXECUTE_PREFIX.length; ++i) {
            if (this.buffer[this.pos + i] == NON_EXECUTE_PREFIX[i]) continue;
            return;
        }
        this.pos += NON_EXECUTE_PREFIX.length;
    }

    private JsonToken advance() throws IOException {
        this.peek();
        JsonToken jsonToken = this.token;
        this.token = null;
        this.value = null;
        this.name = null;
        return jsonToken;
    }

    public String nextName() throws IOException {
        this.peek();
        if (this.token != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        String string = this.name;
        this.advance();
        return string;
    }

    public String nextString() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        String string = this.value;
        this.advance();
        return string;
    }

    public boolean nextBoolean() throws IOException {
        this.peek();
        if (this.token != JsonToken.BOOLEAN) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        boolean bl = this.value == TRUE;
        this.advance();
        return bl;
    }

    public void nextNull() throws IOException {
        this.peek();
        if (this.token != JsonToken.NULL) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
    }

    public double nextDouble() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        double d = Double.parseDouble(this.value);
        if (d >= 1.0 && this.value.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
        return d;
    }

    public long nextLong() throws IOException {
        long l;
        block4: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            try {
                l = Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                l = (long)d;
                if ((double)l == d) break block4;
                throw new NumberFormatException("Expected a long but was " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
        }
        if (l >= 1L && this.value.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
        return l;
    }

    public int nextInt() throws IOException {
        int n;
        block4: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.token) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            try {
                n = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                n = (int)d;
                if ((double)n == d) break block4;
                throw new NumberFormatException("Expected an int but was " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
        }
        if ((long)n >= 1L && this.value.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.value + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.advance();
        return n;
    }

    @Override
    public void close() throws IOException {
        this.value = null;
        this.token = null;
        this.stack[0] = JsonScope.CLOSED;
        this.stackSize = 1;
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipValue() throws IOException {
        this.skipping = true;
        try {
            int n = 0;
            do {
                JsonToken jsonToken;
                if ((jsonToken = this.advance()) == JsonToken.BEGIN_ARRAY || jsonToken == JsonToken.BEGIN_OBJECT) {
                    ++n;
                    continue;
                }
                if (jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_OBJECT) continue;
                --n;
            } while (n != 0);
        }
        finally {
            this.skipping = false;
        }
    }

    private void push(JsonScope jsonScope) {
        if (this.stackSize == this.stack.length) {
            JsonScope[] jsonScopeArray = new JsonScope[this.stackSize * 2];
            System.arraycopy(this.stack, 0, jsonScopeArray, 0, this.stackSize);
            this.stack = jsonScopeArray;
        }
        this.stack[this.stackSize++] = jsonScope;
    }

    private JsonToken nextInArray(boolean bl) throws IOException {
        if (bl) {
            this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_ARRAY;
        } else {
            switch (this.nextNonWhitespace(true)) {
                case 93: {
                    --this.stackSize;
                    this.token = JsonToken.END_ARRAY;
                    return this.token;
                }
                case 59: {
                    this.checkLenient();
                }
                case 44: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated array");
                }
            }
        }
        switch (this.nextNonWhitespace(true)) {
            case 93: {
                if (bl) {
                    --this.stackSize;
                    this.token = JsonToken.END_ARRAY;
                    return this.token;
                }
            }
            case 44: 
            case 59: {
                this.checkLenient();
                --this.pos;
                this.value = "null";
                this.token = JsonToken.NULL;
                return this.token;
            }
        }
        --this.pos;
        return this.nextValue();
    }

    private JsonToken nextInObject(boolean bl) throws IOException {
        if (bl) {
            switch (this.nextNonWhitespace(true)) {
                case 125: {
                    --this.stackSize;
                    this.token = JsonToken.END_OBJECT;
                    return this.token;
                }
            }
            --this.pos;
        } else {
            switch (this.nextNonWhitespace(true)) {
                case 125: {
                    --this.stackSize;
                    this.token = JsonToken.END_OBJECT;
                    return this.token;
                }
                case 44: 
                case 59: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated object");
                }
            }
        }
        int n = this.nextNonWhitespace(true);
        switch (n) {
            case 39: {
                this.checkLenient();
            }
            case 34: {
                this.name = this.nextString((char)n);
                break;
            }
            default: {
                this.checkLenient();
                --this.pos;
                this.name = this.nextLiteral(false);
                if (this.name.length() != 0) break;
                throw this.syntaxError("Expected name");
            }
        }
        this.stack[this.stackSize - 1] = JsonScope.DANGLING_NAME;
        this.token = JsonToken.NAME;
        return this.token;
    }

    private JsonToken objectValue() throws IOException {
        switch (this.nextNonWhitespace(true)) {
            case 58: {
                break;
            }
            case 61: {
                this.checkLenient();
                if (this.pos >= this.limit && !this.fillBuffer(1) || this.buffer[this.pos] != '>') break;
                ++this.pos;
                break;
            }
            default: {
                throw this.syntaxError("Expected ':'");
            }
        }
        this.stack[this.stackSize - 1] = JsonScope.NONEMPTY_OBJECT;
        return this.nextValue();
    }

    private JsonToken nextValue() throws IOException {
        int n = this.nextNonWhitespace(true);
        switch (n) {
            case 123: {
                this.push(JsonScope.EMPTY_OBJECT);
                this.token = JsonToken.BEGIN_OBJECT;
                return this.token;
            }
            case 91: {
                this.push(JsonScope.EMPTY_ARRAY);
                this.token = JsonToken.BEGIN_ARRAY;
                return this.token;
            }
            case 39: {
                this.checkLenient();
            }
            case 34: {
                this.value = this.nextString((char)n);
                this.token = JsonToken.STRING;
                return this.token;
            }
        }
        --this.pos;
        return this.readLiteral();
    }

    private boolean fillBuffer(int n) throws IOException {
        int n2;
        char[] cArray = this.buffer;
        int n3 = this.bufferStartLine;
        int n4 = this.bufferStartColumn;
        int n5 = this.pos;
        for (n2 = 0; n2 < n5; ++n2) {
            if (cArray[n2] == '\n') {
                ++n3;
                n4 = 1;
                continue;
            }
            ++n4;
        }
        this.bufferStartLine = n3;
        this.bufferStartColumn = n4;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(cArray, this.pos, cArray, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((n2 = this.in.read(cArray, this.limit, cArray.length - this.limit)) != -1) {
            this.limit += n2;
            if (this.bufferStartLine == 1 && this.bufferStartColumn == 1 && this.limit > 0 && cArray[0] == '\ufeff') {
                ++this.pos;
                --this.bufferStartColumn;
            }
            if (this.limit < n) continue;
            return true;
        }
        return false;
    }

    private int getLineNumber() {
        int n = this.bufferStartLine;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] != '\n') continue;
            ++n;
        }
        return n;
    }

    private int getColumnNumber() {
        int n = this.bufferStartColumn;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] == '\n') {
                n = 1;
                continue;
            }
            ++n;
        }
        return n;
    }

    private int nextNonWhitespace(boolean bl) throws IOException {
        block14: {
            char c;
            char[] cArray = this.buffer;
            int n = this.pos;
            int n2 = this.limit;
            block9: while (true) {
                if (n == n2) {
                    this.pos = n;
                    if (!this.fillBuffer(1)) break block14;
                    n = this.pos;
                    n2 = this.limit;
                }
                c = cArray[n++];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block9;
                    }
                    case '/': {
                        this.pos = n;
                        if (n == n2 && !this.fillBuffer(1)) {
                            return c;
                        }
                        this.checkLenient();
                        char c2 = cArray[this.pos];
                        switch (c2) {
                            case '*': {
                                ++this.pos;
                                if (!this.skipTo("*/")) {
                                    throw this.syntaxError("Unterminated comment");
                                }
                                n = this.pos + 2;
                                n2 = this.limit;
                                continue block9;
                            }
                            case '/': {
                                ++this.pos;
                                this.skipToEndOfLine();
                                n = this.pos;
                                n2 = this.limit;
                                continue block9;
                            }
                        }
                        return c;
                    }
                    case '#': {
                        this.pos = n;
                        this.checkLenient();
                        this.skipToEndOfLine();
                        n = this.pos;
                        n2 = this.limit;
                        continue block9;
                    }
                }
                break;
            }
            this.pos = n;
            return c;
        }
        if (bl) {
            throw new EOFException("End of input at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        return -1;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() throws IOException {
        char c;
        while ((this.pos < this.limit || this.fillBuffer(1)) && (c = this.buffer[this.pos++]) != '\r' && c != '\n') {
        }
    }

    private boolean skipTo(String string) throws IOException {
        while (this.pos + string.length() <= this.limit || this.fillBuffer(string.length())) {
            block3: {
                for (int i = 0; i < string.length(); ++i) {
                    if (this.buffer[this.pos + i] == string.charAt(i)) {
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++this.pos;
        }
        return false;
    }

    private String nextString(char c) throws IOException {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = null;
        do {
            int n = this.pos;
            int n2 = this.limit;
            int n3 = n;
            while (n < n2) {
                char c2;
                if ((c2 = cArray[n++]) == c) {
                    this.pos = n;
                    if (this.skipping) {
                        return "skipped!";
                    }
                    if (stringBuilder == null) {
                        return this.stringPool.get(cArray, n3, n - n3 - 1);
                    }
                    stringBuilder.append(cArray, n3, n - n3 - 1);
                    return stringBuilder.toString();
                }
                if (c2 != '\\') continue;
                this.pos = n;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(cArray, n3, n - n3 - 1);
                stringBuilder.append(this.readEscapeCharacter());
                n = this.pos;
                n2 = this.limit;
                n3 = n;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(cArray, n3, n - n3);
            this.pos = n;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private String nextLiteral(boolean bl) throws IOException {
        String string;
        StringBuilder stringBuilder = null;
        this.valuePos = -1;
        this.valueLength = 0;
        int n = 0;
        block4: while (true) {
            if (this.pos + n < this.limit) {
                switch (this.buffer[this.pos + n]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++n;
                        break;
                    }
                }
                continue;
            }
            if (n < this.buffer.length) {
                if (this.fillBuffer(n + 1)) continue;
                this.buffer[this.limit] = '\u0000';
                break;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.buffer, this.pos, n);
            this.valueLength += n;
            this.pos += n;
            n = 0;
            if (!this.fillBuffer(1)) break;
        }
        if (bl && stringBuilder == null) {
            this.valuePos = this.pos;
            string = null;
        } else if (this.skipping) {
            string = "skipped!";
        } else if (stringBuilder == null) {
            string = this.stringPool.get(this.buffer, this.pos, n);
        } else {
            stringBuilder.append(this.buffer, this.pos, n);
            string = stringBuilder.toString();
        }
        this.valueLength += n;
        this.pos += n;
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " near " + this.getSnippet();
    }

    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char c = this.buffer[this.pos++];
        switch (c) {
            case 'u': {
                int n;
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                char c2 = '\u0000';
                int n2 = n + 4;
                for (n = this.pos; n < n2; ++n) {
                    char c3 = this.buffer[n];
                    c2 = (char)(c2 << 4);
                    if (c3 >= '0' && c3 <= '9') {
                        c2 = (char)(c2 + (c3 - 48));
                        continue;
                    }
                    if (c3 >= 'a' && c3 <= 'f') {
                        c2 = (char)(c2 + (c3 - 97 + 10));
                        continue;
                    }
                    if (c3 >= 'A' && c3 <= 'F') {
                        c2 = (char)(c2 + (c3 - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + this.stringPool.get(this.buffer, this.pos, 4));
                }
                this.pos += 4;
                return c2;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return c;
    }

    private JsonToken readLiteral() throws IOException {
        this.value = this.nextLiteral(true);
        if (this.valueLength == 0) {
            throw this.syntaxError("Expected literal value");
        }
        this.token = this.decodeLiteral();
        if (this.token == JsonToken.STRING) {
            this.checkLenient();
        }
        return this.token;
    }

    private JsonToken decodeLiteral() throws IOException {
        if (this.valuePos == -1) {
            return JsonToken.STRING;
        }
        if (!(this.valueLength != 4 || 'n' != this.buffer[this.valuePos] && 'N' != this.buffer[this.valuePos] || 'u' != this.buffer[this.valuePos + 1] && 'U' != this.buffer[this.valuePos + 1] || 'l' != this.buffer[this.valuePos + 2] && 'L' != this.buffer[this.valuePos + 2] || 'l' != this.buffer[this.valuePos + 3] && 'L' != this.buffer[this.valuePos + 3])) {
            this.value = "null";
            return JsonToken.NULL;
        }
        if (!(this.valueLength != 4 || 't' != this.buffer[this.valuePos] && 'T' != this.buffer[this.valuePos] || 'r' != this.buffer[this.valuePos + 1] && 'R' != this.buffer[this.valuePos + 1] || 'u' != this.buffer[this.valuePos + 2] && 'U' != this.buffer[this.valuePos + 2] || 'e' != this.buffer[this.valuePos + 3] && 'E' != this.buffer[this.valuePos + 3])) {
            this.value = TRUE;
            return JsonToken.BOOLEAN;
        }
        if (!(this.valueLength != 5 || 'f' != this.buffer[this.valuePos] && 'F' != this.buffer[this.valuePos] || 'a' != this.buffer[this.valuePos + 1] && 'A' != this.buffer[this.valuePos + 1] || 'l' != this.buffer[this.valuePos + 2] && 'L' != this.buffer[this.valuePos + 2] || 's' != this.buffer[this.valuePos + 3] && 'S' != this.buffer[this.valuePos + 3] || 'e' != this.buffer[this.valuePos + 4] && 'E' != this.buffer[this.valuePos + 4])) {
            this.value = FALSE;
            return JsonToken.BOOLEAN;
        }
        this.value = this.stringPool.get(this.buffer, this.valuePos, this.valueLength);
        return this.decodeNumber(this.buffer, this.valuePos, this.valueLength);
    }

    private JsonToken decodeNumber(char[] cArray, int n, int n2) {
        int n3 = n;
        char c = cArray[n3];
        if (c == '-') {
            c = cArray[++n3];
        }
        if (c == '0') {
            c = cArray[++n3];
        } else if (c >= '1' && c <= '9') {
            c = cArray[++n3];
            while (c >= '0' && c <= '9') {
                c = cArray[++n3];
            }
        } else {
            return JsonToken.STRING;
        }
        if (c == '.') {
            c = cArray[++n3];
            while (c >= '0' && c <= '9') {
                c = cArray[++n3];
            }
        }
        if (c == 'e' || c == 'E') {
            if ((c = cArray[++n3]) == '+' || c == '-') {
                c = cArray[++n3];
            }
            if (c >= '0' && c <= '9') {
                c = cArray[++n3];
                while (c >= '0' && c <= '9') {
                    c = cArray[++n3];
                }
            } else {
                return JsonToken.STRING;
            }
        }
        if (n3 == n + n2) {
            return JsonToken.NUMBER;
        }
        return JsonToken.STRING;
    }

    private IOException syntaxError(String string) throws IOException {
        throw new MalformedJsonException(string + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    private CharSequence getSnippet() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = Math.min(this.pos, 20);
        stringBuilder.append(this.buffer, this.pos - n, n);
        int n2 = Math.min(this.limit - this.pos, 20);
        stringBuilder.append(this.buffer, this.pos, n2);
        return stringBuilder;
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                    return;
                }
                jsonReader.peek();
                if (jsonReader.token != JsonToken.NAME) {
                    throw new IllegalStateException("Expected a name but was " + (Object)((Object)jsonReader.peek()) + " " + " at line " + jsonReader.getLineNumber() + " column " + jsonReader.getColumnNumber());
                }
                jsonReader.value = jsonReader.name;
                jsonReader.name = null;
                jsonReader.token = JsonToken.STRING;
            }
        };
    }
}

